/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hints;

import com.atlassian.jira.hints.Hint;
import com.atlassian.jira.hints.HintImpl;
import com.atlassian.jira.hints.HintManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHintManager
implements HintManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultHintManager.class);
    public static final String ALL_HINTS_SECTION = "jira.hints/all";
    public static final String HINTS_PREFIX = "jira.hints/";
    private final Random random = new Random();
    private final DynamicWebInterfaceManager webInterfaceManager;

    public DefaultHintManager(DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public Hint getRandomHint(ApplicationUser user, JiraHelper jiraHelper) {
        return this.getRandomHint(this.getAllHints(user, jiraHelper));
    }

    public List<Hint> getAllHints(ApplicationUser user, JiraHelper jiraHelper) {
        return this.getHintsForSection(user, jiraHelper, ALL_HINTS_SECTION);
    }

    public Hint getHintForContext(ApplicationUser remoteUser, JiraHelper jiraHelper, HintManager.Context context) {
        Assertions.notNull((String)"context", (Object)context);
        return this.getRandomHint(this.getHintsForSection(remoteUser, jiraHelper, HINTS_PREFIX + context.toString()));
    }

    private Hint getRandomHint(List<Hint> hints) {
        if (hints.isEmpty()) {
            return null;
        }
        int randomPosition = this.random.nextInt(hints.size());
        return hints.get(randomPosition);
    }

    private List<Hint> getHintsForSection(ApplicationUser user, JiraHelper helper, String section) {
        Assertions.notNull((String)"helper", (Object)helper);
        Map context = helper.getContextParams();
        context.put("user", user);
        Iterable items = this.webInterfaceManager.getDisplayableWebItems(section, context);
        return CollectionUtil.transform((Iterable)items, (Function)new Function<WebItem, Hint>(){

            public Hint apply(WebItem input) {
                Option label = Option.option((Object)input.getLabel());
                if (label.isEmpty()) {
                    log.warn("Hint web item with key '" + input.getCompleteKey() + "' does not define a label");
                }
                return new HintImpl((String)label.getOrElse((Object)""), input.getTitle());
            }
        });
    }
}

