/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class JiraLocaleResolver
implements LocaleResolver {
    private final LocaleManager localeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;

    public JiraLocaleResolver(LocaleManager localeManager, JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager, ApplicationProperties applicationProperties) {
        this.localeManager = localeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.jiraAuthenticationContext.getLocale();
    }

    public Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    public Locale getLocale(UserKey userKey) {
        ApplicationUser user = Optional.ofNullable(userKey).map(UserKey::getStringValue).map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).orElse(null);
        return this.localeManager.getLocaleFor(user);
    }

    public Locale getApplicationLocale() {
        return this.applicationProperties.getDefaultLocale();
    }

    public Set<Locale> getSupportedLocales() {
        return this.localeManager.getInstalledLocales();
    }
}

