/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@EventName(value="jira.terminology.changed")
@Immutable
public final class TerminologyChangedAnalyticEvent {
    private final String originalName;
    private final boolean changedToOriginal;

    public TerminologyChangedAnalyticEvent(TerminologyEntry newEntry) {
        this.originalName = newEntry.getOriginalName();
        this.changedToOriginal = !newEntry.hasNonOriginalNames();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public boolean getChangedToOriginal() {
        return this.changedToOriginal;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{originalName='" + this.originalName + "', changedToOriginal='" + this.changedToOriginal + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminologyChangedAnalyticEvent that = (TerminologyChangedAnalyticEvent)o;
        return this.changedToOriginal == that.changedToOriginal && this.originalName.equals(that.originalName);
    }

    public int hashCode() {
        return Objects.hash(this.originalName, this.changedToOriginal);
    }
}

