/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.i18n.terminology.TerminologyChangedAnalyticEvent;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryChangedEvent;
import com.atlassian.jira.i18n.terminology.TerminologyEntryDao;
import com.atlassian.jira.i18n.terminology.TerminologyEntryReader;
import com.atlassian.jira.i18n.terminology.TerminologyEntryValidator;
import com.atlassian.jira.i18n.terminology.TerminologyEntryWriter;
import com.atlassian.jira.i18n.terminology.TerminologyPreChangeEvent;
import com.atlassian.jira.license.DataCenterOrDevModeCheck;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class TerminologyEntryWriterImpl
implements TerminologyEntryWriter {
    private static final Logger log = LoggerFactory.getLogger(TerminologyEntryWriterImpl.class);
    private final TerminologyEntryReader terminologyEntryReader;
    private final TerminologyEntryDao terminologyEntryDao;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final TerminologyEntryValidator terminologyEntryValidator;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final DataCenterOrDevModeCheck dataCenterOrDevModeCheck;

    public TerminologyEntryWriterImpl(TerminologyEntryReader terminologyEntryReader, TerminologyEntryDao terminologyEntryDao, GlobalPermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, TerminologyEntryValidator terminologyEntryValidator, EventPublisher eventPublisher, FeatureManager featureManager, DataCenterOrDevModeCheck dataCenterOrDevModeCheck) {
        this.terminologyEntryReader = terminologyEntryReader;
        this.terminologyEntryDao = terminologyEntryDao;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.terminologyEntryValidator = terminologyEntryValidator;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.dataCenterOrDevModeCheck = dataCenterOrDevModeCheck;
    }

    public TerminologyEntryWriter.TerminologyValidationResult validateAndPrepareTerminologyChange(Collection<TerminologyEntry> terminologyEntries) {
        ErrorCollection permissionErrors = this.validateIsAdmin();
        if (permissionErrors.hasAnyErrors()) {
            return TerminologyEntryWriter.TerminologyValidationResult.error((ErrorCollection)permissionErrors);
        }
        return this.terminologyEntryValidator.validateNewTerminologyEntries(terminologyEntries);
    }

    public void changeTerminology(TerminologyEntryWriter.TerminologyValidationResult terminologyValidationResults) {
        this.validatePreconditions(terminologyValidationResults);
        Collection terminologyEntryDTOs = terminologyValidationResults.getTerminologyEntries().stream().map(newEntry -> new NomenclatureEntryDTO(null, newEntry.getOriginalName(), newEntry.getNewName().trim(), newEntry.getNewNamePlural().trim(), Instant.now().toEpochMilli())).collect(Collectors.toList());
        ImmutableMap.Builder previousTerminologyEntriesBuilder = ImmutableMap.builder();
        terminologyValidationResults.getTerminologyEntries().forEach(newEntry -> previousTerminologyEntriesBuilder.put(newEntry, (Object)this.terminologyEntryReader.getTerminologyEntry(newEntry.getOriginalName())));
        ImmutableMap previousTerminologyEntries = previousTerminologyEntriesBuilder.build();
        terminologyValidationResults.getTerminologyEntries().stream().forEach(arg_0 -> this.lambda$changeTerminology$2((Map)previousTerminologyEntries, arg_0));
        this.terminologyEntryDao.setTerminologyEntries(terminologyEntryDTOs);
        previousTerminologyEntries.entrySet().forEach(entry -> {
            Optional previousTerminologyEntry = (Optional)entry.getValue();
            TerminologyEntry newEntry = (TerminologyEntry)entry.getKey();
            if (previousTerminologyEntry.isPresent()) {
                log.info("Terminology entry has been updated: '{}' -> '{}'", previousTerminologyEntry.get(), (Object)newEntry);
            } else {
                log.info("Terminology entry has been created: '{}' ", (Object)newEntry);
            }
            this.eventPublisher.publish((Object)new TerminologyEntryChangedEvent(previousTerminologyEntry, newEntry));
            if (this.isNotTheSameAsPreviousTerminologyEntry(previousTerminologyEntry, newEntry)) {
                this.eventPublisher.publish((Object)new TerminologyChangedAnalyticEvent(newEntry));
            }
        });
    }

    private void validatePreconditions(TerminologyEntryWriter.TerminologyValidationResult terminologyValidationResult) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES)) {
            throw new IllegalStateException("You cannot change terminology with the " + JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES.featureKey() + " feature flag disabled.");
        }
        if (!terminologyValidationResult.isValid()) {
            throw new IllegalStateException("You can not create a terminology entry with an invalid validation result.");
        }
        if (!this.dataCenterOrDevModeCheck.isDataCenterOrDevMode()) {
            throw new IllegalStateException("You can only change terminology with a valid Data Center license or in dev mode.");
        }
    }

    private ErrorCollection validateIsAdmin() {
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.jiraAuthenticationContext.getLoggedInUser())) {
            return new SimpleErrorCollection("No permission to set terminology entry.", ErrorCollection.Reason.FORBIDDEN);
        }
        return new SimpleErrorCollection();
    }

    private boolean isNotTheSameAsPreviousTerminologyEntry(Optional<TerminologyEntry> previousTerminologyEntry, TerminologyEntry newEntry) {
        return previousTerminologyEntry.map(terminologyEntry -> !newEntry.equals(terminologyEntry)).orElse(true);
    }

    private /* synthetic */ void lambda$changeTerminology$2(Map previousTerminologyEntries, TerminologyEntry newEntry) {
        this.eventPublisher.publish((Object)new TerminologyPreChangeEvent((Optional)previousTerminologyEntries.get(newEntry), newEntry));
    }
}

