/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.model.querydsl.NomenclatureEntryDTO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.util.Assert;

@ParametersAreNonnullByDefault
public class ValidatedTerminologyEntryImpl
implements Serializable,
TerminologyEntry {
    private static final long serialVersionUID = -8362870544204367298L;
    private final AllowedOriginalName originalName;
    private final String newName;
    private final String newNamePlural;

    ValidatedTerminologyEntryImpl(AllowedOriginalName originalName, String newName, String newNamePlural) {
        Assert.isTrue((Objects.nonNull((Object)originalName) && Objects.nonNull(newName) && Objects.nonNull(newNamePlural) ? 1 : 0) != 0, (String)"All fields must not be null");
        this.originalName = originalName;
        this.newName = newName;
        this.newNamePlural = newNamePlural;
    }

    public ValidatedTerminologyEntryImpl(String originalName, String newName, String newNamePlural) {
        AllowedOriginalName allowedOriginalName;
        Assert.isTrue((Objects.nonNull(originalName) && Objects.nonNull(newName) && Objects.nonNull(newNamePlural) ? 1 : 0) != 0, (String)"All fields must not be null");
        this.originalName = allowedOriginalName = AllowedOriginalName.fromSingular(originalName.toLowerCase().trim()).orElseThrow(() -> new IllegalArgumentException(originalName + " is not a valid original name"));
        this.newName = newName;
        this.newNamePlural = newNamePlural;
    }

    static TerminologyEntry fromDTO(NomenclatureEntryDTO terminologyEntryDTO) {
        Assert.notNull((Object)terminologyEntryDTO, (String)"terminologyEntryDTO must not be null");
        AllowedOriginalName originalName = AllowedOriginalName.fromSingular(terminologyEntryDTO.getOriginalName()).orElseThrow(() -> new IllegalArgumentException("originalName in DTO must be one of allowed names"));
        return new ValidatedTerminologyEntryImpl(originalName, terminologyEntryDTO.getNewName(), terminologyEntryDTO.getNewNamePlural());
    }

    public String getOriginalName() {
        return this.originalName.getSingular();
    }

    public String getOriginalNamePlural() {
        return this.originalName.getPlural();
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewNamePlural() {
        return this.newNamePlural;
    }

    public boolean hasNonOriginalNames() {
        return !this.newName.equals(this.originalName.getSingular()) || !this.newNamePlural.equals(this.originalName.getPlural());
    }

    public String toString() {
        return "TerminologyEntry{originalName='" + this.originalName.getSingular() + "', newName='" + this.newName + "', newNamePlural='" + this.newNamePlural + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedTerminologyEntryImpl that = (ValidatedTerminologyEntryImpl)o;
        return this.originalName.equals((Object)that.originalName) && this.newName.equals(that.newName) && this.newNamePlural.equals(that.newNamePlural);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.originalName, this.newName, this.newNamePlural});
    }

    public static enum AllowedOriginalName {
        SPRINT("sprint", "sprints"),
        EPIC("epic", "epics");

        private final String singular;
        private final String plural;

        private AllowedOriginalName(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }

        public String getSingular() {
            return this.singular;
        }

        public String getPlural() {
            return this.plural;
        }

        public static Optional<AllowedOriginalName> fromSingular(String name) {
            return Arrays.stream(AllowedOriginalName.values()).filter(n -> n.singular.equals(name)).findFirst();
        }
    }
}

