/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.ao.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ao.handler.PluggableImportAoEntityHandler;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.util.AoImportTemporaryFiles;
import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.ofbiz.core.util.UtilFormatOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoPartitionHandler
implements PluggableImportAoEntityHandler {
    private static final Logger logger = LoggerFactory.getLogger(AoPartitionHandler.class);
    private final AoImportTemporaryFiles aoImportTemporaryFiles;
    private final String encoding;
    PrintWriter entityWriter;
    private String currentEntityName;
    private List<String> columnNames;

    public AoPartitionHandler(AoImportTemporaryFiles aoImportTemporaryFiles, String encoding) {
        this.aoImportTemporaryFiles = aoImportTemporaryFiles;
        this.encoding = encoding;
    }

    public boolean handlesEntity(String entityName) {
        return true;
    }

    public Long getEntityWeight(String entityName) {
        return WEIGHT_NONE;
    }

    public void handleEntity(String entityName, Map<String, Object> attributes) throws ParseException, AbortImportException {
        if (entityName != this.currentEntityName) {
            this.closeTable();
            this.columnNames = new ArrayList<String>(attributes.keySet());
            this.openTable(entityName, this.columnNames);
            this.currentEntityName = entityName;
        }
        this.entityWriter.println("<row>");
        for (String columnName : this.columnNames) {
            Object value = attributes.get(columnName);
            if (value == null) {
                this.writeStringValue("");
                continue;
            }
            if (value instanceof String) {
                this.writeStringValue((String)value);
                continue;
            }
            if (value instanceof Long) {
                this.writeLongValue((Long)value);
                continue;
            }
            if (value instanceof Double) {
                this.writeDoubleValue((Double)value);
                continue;
            }
            if (value instanceof Boolean) {
                this.writeBooleanValue((Boolean)value);
                continue;
            }
            if (!(value instanceof Date)) continue;
            this.writeDateValue((Date)value);
        }
        this.entityWriter.println("</row>");
    }

    private void writeStringValue(String s) {
        this.entityWriter.println("<string>" + this.encode(s) + "</string>");
    }

    private void writeLongValue(Long value) {
        this.entityWriter.println("<integer>" + this.encode(value.toString()) + "</integer>");
    }

    private void writeDoubleValue(Double value) {
        this.entityWriter.println("<double>" + this.encode(value.toString()) + "</double>");
    }

    private void writeBooleanValue(Boolean value) {
        this.entityWriter.println("<boolean>" + this.encode(value.toString()) + "</boolean>");
    }

    private void writeDateValue(Date value) {
        this.entityWriter.println("<timestamp>" + this.encode(value) + "</timestamp>");
    }

    private String encode(Date value) {
        return this.encode(this.newDateFormat().format(value));
    }

    private String encode(String s) {
        return XMLEscapeUtil.unicodeEncode(UtilFormatOut.encodeXmlValue((String)s));
    }

    private DateFormat newDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.closeTable();
    }

    public void endTable(String tableName) {
        this.closeTable();
    }

    private void openTable(String entityName, List<String> columnNames) throws AbortImportException {
        try {
            File aoXmlFile = this.aoImportTemporaryFiles.createFileForEntity(entityName);
            this.aoImportTemporaryFiles.registerAoXmlFile(entityName, aoXmlFile);
            this.entityWriter = this.getWriter(aoXmlFile, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AbortImportException();
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AbortImportException();
        }
        if (this.entityWriter != null) {
            this.entityWriter.println("<backup>");
            this.entityWriter.println("<data tableName=\"" + entityName + "\" >");
            for (String columnName : columnNames) {
                this.entityWriter.println("<column name=\"" + columnName + "\"/>");
            }
        }
    }

    private void closeTable() {
        if (this.entityWriter != null) {
            try {
                this.entityWriter.println("</data>");
                this.entityWriter.println("</backup>");
            }
            finally {
                this.entityWriter.close();
                this.entityWriter = null;
            }
        }
    }

    PrintWriter getWriter(File file, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
        BufferedWriter bufferedWriter = new BufferedWriter(out, 32768);
        return new PrintWriter(bufferedWriter);
    }

    public void setBackupProject(BackupProject backupProject) {
    }

    public void setBackupSystemInformation(BackupSystemInformation backupSystemInformation) {
    }

    public void setProjectImportMapper(ProjectImportMapper projectImportMapper) {
    }

    public void setProjectImportResults(@Nullable ProjectImportResults projectImportResults) {
    }
}

