/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.issue.label.Label;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalIssueImpl
implements ExternalIssue {
    private static final Logger log = LoggerFactory.getLogger(ExternalIssueImpl.class);
    private String oldId;
    private String id;
    private String key;
    private String summary;
    private String reporter;
    private String assignee;
    private String description;
    private String environment;
    private String project;
    private String issueType;
    private String status;
    private String priority;
    private String resolution;
    private String securityLevel;
    private Date created;
    private Date updated;
    private Date resolutionDate;
    private Date duedate;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long timeSpent;
    private Long estimate;
    private final String creator;
    private ExternalProject externalProject;
    private List<String> affectedVersions;
    private List<String> fixedVersions;
    private List<String> externalComponents;
    private List<ExternalComment> externalComments;
    private List<ExternalCustomFieldValue> externalCustomFieldValues;
    private Set<Label> labels;

    public ExternalIssueImpl(@Nullable String creator) {
        this.creator = creator;
    }

    public void setLabels(Set<Label> labels) {
        this.labels = labels;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public String getOldId() {
        return this.oldId;
    }

    public void setOldId(String oldId) {
        this.oldId = oldId;
    }

    public ExternalProject getExternalProject() {
        return this.externalProject;
    }

    public void setExternalProject(ExternalProject externalProject) {
        this.externalProject = externalProject;
    }

    public List<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }

    public List<String> getFixedVersions() {
        return this.fixedVersions;
    }

    public void setFixedVersions(List<String> fixedVersions) {
        this.fixedVersions = fixedVersions;
    }

    public List<String> getExternalComponents() {
        return this.externalComponents;
    }

    public void setExternalComponents(List<String> externalComponents) {
        this.externalComponents = externalComponents;
    }

    public List<ExternalComment> getExternalComments() {
        return this.externalComments;
    }

    public void setExternalComments(List<ExternalComment> externalComments) {
        this.externalComments = externalComments;
    }

    public List<ExternalCustomFieldValue> getExternalCustomFieldValues() {
        return this.externalCustomFieldValues;
    }

    public void setExternalCustomFieldValues(List<ExternalCustomFieldValue> externalCustomFieldValues) {
        this.externalCustomFieldValues = externalCustomFieldValues;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public Long getVotes() {
        return this.votes;
    }

    public void setVotes(Long votes) {
        this.votes = votes;
    }

    public Long getWatches() {
        return this.watches;
    }

    public void setWatches(Long watches) {
        this.watches = watches;
    }

    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setOriginalEstimate(Long originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Long getEstimate() {
        return this.estimate;
    }

    public void setEstimate(Long estimate) {
        this.estimate = estimate;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(String securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void setField(String fieldName, String value) {
        try {
            fieldName = this.processFieldName(fieldName);
            BeanUtils.setProperty((Object)this, (String)fieldName, (Object)value);
        }
        catch (Exception e) {
            log.warn("Unable to set field using reflection for :" + fieldName + ":" + value);
        }
    }

    public String getField(String fieldName) {
        try {
            fieldName = this.processFieldName(fieldName);
            return BeanUtils.getProperty((Object)this, (String)fieldName);
        }
        catch (Exception e) {
            log.warn("Unable to get field using reflection for :" + fieldName);
            return null;
        }
    }

    private String processFieldName(String fieldName) {
        if (ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(fieldName)) {
            fieldName = "issueType";
        }
        return fieldName;
    }

    public String toString() {
        return "Issue {summary=" + this.summary + ", type=" + this.issueType + (String)(this.project != null ? ", project=" + this.project : "") + "}";
    }
}

