/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldOption;
import com.atlassian.jira.imports.project.mapper.AutomaticDataMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldOptionMapper;
import com.atlassian.jira.imports.project.mapper.IssueLinkTypeMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.StatusMapper;
import com.atlassian.jira.imports.project.util.IssueTypeImportHelper;
import com.atlassian.jira.imports.project.validation.CustomFieldMapperValidator;
import com.atlassian.jira.imports.project.validation.StatusMapperValidator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.JiraCollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticDataMapperImpl
implements AutomaticDataMapper {
    private static final Logger log = LoggerFactory.getLogger(AutomaticDataMapperImpl.class);
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldMapperValidator customFieldMapperValidator;
    private final ProjectManager projectManager;
    private final IssueTypeImportHelper issueTypeImportHelper;
    private final StatusMapperValidator statusMapperValidator;
    private final ProjectRoleManager projectRoleManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final SubTaskManager subTaskManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public AutomaticDataMapperImpl(ConstantsManager constantsManager, CustomFieldManager customFieldManager, CustomFieldMapperValidator customFieldMapperValidator, ProjectManager projectManager, IssueTypeImportHelper issueTypeImportHelper, StatusMapperValidator statusMapperValidator, ProjectRoleManager projectRoleManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.customFieldMapperValidator = customFieldMapperValidator;
        this.projectManager = projectManager;
        this.issueTypeImportHelper = issueTypeImportHelper;
        this.statusMapperValidator = statusMapperValidator;
        this.projectRoleManager = projectRoleManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    public void mapIssueTypes(BackupProject backupProject, IssueTypeMapper issueTypeMapper) {
        for (String oldId : issueTypeMapper.getRegisteredOldIds()) {
            IssueType newIssueType = this.issueTypeImportHelper.getIssueTypeForName(issueTypeMapper.getKey(oldId));
            if (newIssueType == null || !this.issueTypeImportHelper.isMappingValid(newIssueType, backupProject.getProject().getKey(), issueTypeMapper.isSubTask(oldId))) continue;
            issueTypeMapper.mapValue(oldId, newIssueType.getId());
        }
    }

    @Override
    public void mapIssueLinkTypes(IssueLinkTypeMapper issueLinkTypeMapper) {
        for (String oldId : issueLinkTypeMapper.getRegisteredOldIds()) {
            String issueLinkTypeName = issueLinkTypeMapper.getKey(oldId);
            IssueLinkType newIssueLinkType = this.getIssueLinkTypeByName(issueLinkTypeName);
            if (newIssueLinkType == null || !this.checkStyleIsValid(oldId, newIssueLinkType, issueLinkTypeMapper)) continue;
            issueLinkTypeMapper.mapValue(oldId, newIssueLinkType.getId().toString());
        }
    }

    private boolean checkStyleIsValid(String oldId, IssueLinkType issueLinkType, IssueLinkTypeMapper issueLinkTypeMapper) {
        String oldStyle = issueLinkTypeMapper.getStyle(oldId);
        String newStyle = issueLinkType.getStyle();
        if (oldStyle == null) {
            return newStyle == null;
        }
        if (oldStyle.equals("jira_subtask") && !this.subTaskManager.isSubTasksEnabled()) {
            return false;
        }
        return oldStyle.equals(newStyle);
    }

    private IssueLinkType getIssueLinkTypeByName(String linkTypeName) {
        Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(linkTypeName);
        if (linkTypes.isEmpty()) {
            return null;
        }
        return (IssueLinkType)linkTypes.iterator().next();
    }

    @Override
    public void mapPriorities(SimpleProjectImportIdMapper priorityMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Priority priority : this.constantsManager.getPriorities()) {
            nameToIdMap.put(priority.getName(), priority.getId());
        }
        this.autopopulateMapper((ProjectImportIdMapper)priorityMapper, nameToIdMap);
    }

    @Override
    public void mapResolutions(SimpleProjectImportIdMapper resolutionMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Resolution resolution : this.constantsManager.getResolutions()) {
            nameToIdMap.put(resolution.getName(), resolution.getId());
        }
        this.autopopulateMapper((ProjectImportIdMapper)resolutionMapper, nameToIdMap);
    }

    @Override
    public void mapStatuses(BackupProject backupProject, StatusMapper statusMapper, IssueTypeMapper issueTypeMapper) {
        for (String oldStatusId : statusMapper.getRegisteredOldIds()) {
            Status newStatus = this.constantsManager.getStatusByName(statusMapper.getKey(oldStatusId));
            if (newStatus == null || !this.statusMapperValidator.isStatusValid(oldStatusId, newStatus, statusMapper, issueTypeMapper, backupProject.getProject().getKey())) continue;
            statusMapper.mapValue(oldStatusId, newStatus.getId());
        }
    }

    @Override
    public void mapProjectRoles(SimpleProjectImportIdMapper projectRoleMapper) {
        for (String oldProjectRoleId : projectRoleMapper.getRegisteredOldIds()) {
            ProjectRole newProjectRole = this.projectRoleManager.getProjectRole(projectRoleMapper.getKey(oldProjectRoleId));
            if (newProjectRole == null) continue;
            projectRoleMapper.mapValue(oldProjectRoleId, newProjectRole.getId().toString());
        }
    }

    @Override
    public void mapIssueSecurityLevels(String projectKey, SimpleProjectImportIdMapper securityLevelMapper) {
        Long issueSecuritySchemeId = this.getIssueSecuritySchemeId(projectKey);
        if (issueSecuritySchemeId == null) {
            return;
        }
        List securityLevelsInScheme = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(issueSecuritySchemeId);
        for (String oldSecurityLevelId : securityLevelMapper.getRegisteredOldIds()) {
            String name = securityLevelMapper.getKey(oldSecurityLevelId);
            if (name == null) continue;
            for (GenericValue genericValue : securityLevelsInScheme) {
                if (!name.equals(genericValue.getString("name"))) continue;
                securityLevelMapper.mapValue(oldSecurityLevelId, genericValue.getLong("id").toString());
            }
        }
    }

    @Override
    public void mapProjects(SimpleProjectImportIdMapper projectMapper) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Project project : this.projectManager.getProjectObjects()) {
            nameToIdMap.put(project.getKey(), project.getId().toString());
        }
        this.autopopulateMapper((ProjectImportIdMapper)projectMapper, nameToIdMap);
    }

    @Override
    public void mapCustomFields(BackupProject backupProject, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper) {
        block0: for (ExternalCustomFieldConfiguration oldCustomFieldConfig : backupProject.getCustomFields()) {
            ExternalCustomField oldCustomField = oldCustomFieldConfig.getCustomField();
            String oldCustomFieldTypeKey = oldCustomField.getTypeKey();
            if (!this.customFieldMapperValidator.customFieldTypeIsImportable(oldCustomFieldTypeKey)) {
                customFieldMapper.ignoreCustomField(oldCustomField.getId());
                continue;
            }
            String oldCustomFieldId = oldCustomField.getId();
            Collection customFieldsWithName = this.customFieldManager.getCustomFieldObjectsByName(oldCustomField.getName());
            if (customFieldsWithName == null) continue;
            for (CustomField newCustomField : customFieldsWithName) {
                if (!oldCustomFieldTypeKey.equals(newCustomField.getCustomFieldType().getKey()) || !this.customFieldMapperValidator.customFieldIsValidForRequiredContexts(oldCustomFieldConfig, newCustomField, oldCustomFieldId, customFieldMapper, issueTypeMapper, backupProject.getProject().getKey())) continue;
                customFieldMapper.mapValue(oldCustomField.getId(), newCustomField.getIdAsLong().toString());
                continue block0;
            }
        }
        for (String oldId : customFieldMapper.getRequiredOldIds()) {
            if (customFieldMapper.getKey(oldId) != null) continue;
            log.warn("The backup data has a custom field value in use for custom field with id: '" + oldId + "' but the backup data contains no reference to this field. The data will be not be imported.");
            customFieldMapper.ignoreCustomField(oldId);
        }
    }

    @Override
    public void mapCustomFieldOptions(BackupProject backupProject, CustomFieldOptionMapper customFieldOptionMapper, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper) {
        for (ExternalCustomFieldConfiguration externalCustomFieldConfiguration : backupProject.getCustomFields()) {
            log.debug("Mapping CustomField values for configuration {}", (Object)externalCustomFieldConfiguration);
            Collection oldParentOptions = customFieldOptionMapper.getParentOptions(externalCustomFieldConfiguration.getFieldConfigId());
            if (oldParentOptions.isEmpty()) continue;
            log.debug("Mapping {} options", (Object)oldParentOptions.size());
            List<Options> options = this.getNewOptions(backupProject, customFieldMapper, issueTypeMapper, externalCustomFieldConfiguration);
            this.mapOptions(options, customFieldOptionMapper, oldParentOptions);
        }
    }

    List<Options> getNewOptions(BackupProject backupProject, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper, ExternalCustomFieldConfiguration externalCustomFieldConfiguration) {
        Optional<CustomField> newCustomField = Optional.ofNullable(customFieldMapper.getMappedId(externalCustomFieldConfiguration.getCustomField().getId())).map(newCustomFieldId -> this.customFieldManager.getCustomFieldObject(new Long((String)newCustomFieldId)));
        if (newCustomField.isPresent()) {
            return JiraCollectionUtils.streamFromOptional(newCustomField).flatMap(customField -> this.getConfigurationSchemesForCustomField((CustomField)customField, backupProject).stream()).map(scheme -> ((CustomField)newCustomField.get()).getOptions(null, scheme.getOneAndOnlyConfig(), null)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    JiraContextNode getProjectContext(Long newProjectId) {
        return new ProjectContext(newProjectId);
    }

    void mapOptions(List<Options> options, CustomFieldOptionMapper customFieldOptionMapper, Collection<ExternalCustomFieldOption> parentOptions) {
        for (ExternalCustomFieldOption oldParentOption : parentOptions) {
            options.stream().filter(newOptions -> newOptions.getOptionForValue(oldParentOption.getValue(), null) != null).findFirst().ifPresent(newOptions -> this.mapOption(oldParentOption, (Options)newOptions, customFieldOptionMapper));
        }
    }

    private void mapOption(ExternalCustomFieldOption oldParentOption, Options options, CustomFieldOptionMapper customFieldOptionMapper) {
        Option newParentOption = options.getOptionForValue(oldParentOption.getValue(), null);
        customFieldOptionMapper.mapValue(oldParentOption.getId(), newParentOption.getOptionId().toString());
        Collection childOptions = customFieldOptionMapper.getChildOptions(oldParentOption.getId());
        for (ExternalCustomFieldOption childOption : childOptions) {
            Option newChildOption = options.getOptionForValue(childOption.getValue(), newParentOption.getOptionId());
            if (newChildOption == null) continue;
            customFieldOptionMapper.mapValue(childOption.getId(), newChildOption.getOptionId().toString());
        }
    }

    Long getIssueSecuritySchemeId(String projectKey) {
        Project projectGV = this.projectManager.getProjectObjByKey(projectKey);
        if (projectGV == null) {
            return null;
        }
        Scheme scheme = this.issueSecuritySchemeManager.getSchemeFor(projectGV);
        if (scheme == null) {
            return null;
        }
        return scheme.getId();
    }

    private void autopopulateMapper(ProjectImportIdMapper projectImportIdMapper, Map<String, String> nameToIdMap) {
        for (String oldId : projectImportIdMapper.getRegisteredOldIds()) {
            String newId = nameToIdMap.get(projectImportIdMapper.getKey(oldId));
            if (newId == null) continue;
            projectImportIdMapper.mapValue(oldId, newId);
        }
    }

    private Set<FieldConfigScheme> getConfigurationSchemesForCustomField(CustomField customField, BackupProject backupProject) {
        Project project = this.projectManager.getProjectObjByKey(backupProject.getProject().getKey());
        LinkedHashSet<FieldConfigScheme> configs = new LinkedHashSet<FieldConfigScheme>(2);
        Optional.ofNullable(this.fieldConfigSchemeManager.getRelevantConfigScheme(project, (ConfigurableField)customField)).ifPresent(configs::add);
        Optional.ofNullable(this.fieldConfigSchemeManager.getRelevantConfigScheme((Project)null, (ConfigurableField)customField)).ifPresent(configs::add);
        return configs;
    }
}

