/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.validation.ProjectRoleActorMapperValidator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

public class ProjectRoleActorMapperValidatorImpl
implements ProjectRoleActorMapperValidator {
    private final UserManager userManager;

    public ProjectRoleActorMapperValidatorImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public MessageSet validateProjectRoleActors(I18nHelper i18nHelper, ProjectImportMapper projectImportMapper, ProjectImportOptions projectImportOptions) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (projectImportOptions.overwriteProjectDetails()) {
            for (ExternalProjectRoleActor projectRoleActor : projectImportMapper.getProjectRoleActorMapper().getProjectRoleActors()) {
                String projectRoleName;
                if (projectRoleActor.isUserActor()) {
                    if (this.isExternalUserManagementEnabled()) {
                        if (projectImportMapper.getUserMapper().userExists(projectRoleActor.getRoleActor())) continue;
                        projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                        messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.project.role.actor.validation.user.missing", projectRoleName, projectRoleActor.getRoleActor()));
                        messageSet.addWarningMessageInEnglish("Project role '" + projectRoleName + "' contains a user '" + projectRoleActor.getRoleActor() + "' that doesn't exist in the current system. This user will not be added to the project role membership.");
                        continue;
                    }
                    String userKey = projectRoleActor.getRoleActor();
                    if (projectImportMapper.getUserMapper().userExists(userKey) || projectImportMapper.getUserMapper().getExternalUser(userKey) != null) continue;
                    String projectRoleName2 = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                    messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.project.role.actor.validation.user.missing", projectRoleName2, userKey));
                    messageSet.addWarningMessageInEnglish("Project role '" + projectRoleName2 + "' contains a user '" + userKey + "' that doesn't exist in the current system. This user will not be added to the project role membership.");
                    continue;
                }
                if (projectRoleActor.isGroupActor()) {
                    if (projectImportMapper.getGroupMapper().getMappedId(projectRoleActor.getRoleActor()) != null) continue;
                    projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                    messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.project.role.actor.validation.group.missing", projectRoleName, projectRoleActor.getRoleActor()));
                    messageSet.addWarningMessageInEnglish("Project role '" + projectRoleName + "' contains a group '" + projectRoleActor.getRoleActor() + "' that doesn't exist in the current system. This group will not be added to the project role membership.");
                    continue;
                }
                projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.project.role.actor.validation.unknown.role.type", projectRoleName, projectRoleActor.getRoleActor(), projectRoleActor.getRoleType()));
                messageSet.addWarningMessageInEnglish("Project role '" + projectRoleName + "' contains an actor '" + projectRoleActor.getRoleActor() + "' of unknown role type '" + projectRoleActor.getRoleType() + "'. This actor will not be added to the project role.");
            }
        }
        return messageSet;
    }

    boolean isExternalUserManagementEnabled() {
        return !this.userManager.hasWritableDirectory();
    }
}

