/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.xml;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.BackupFileStoreProvider;
import com.atlassian.jira.filestore.NoOpBackupFileStoreProvider;
import com.atlassian.jira.filestore.S3BackupFileStoreProvider;
import java.util.Optional;

public class BackupPathProvider {
    private final FeatureManager featureManager;
    private final BackupFileStoreProvider backupFileStoreProvider;
    private final FileStores fileStores;

    public BackupPathProvider(FeatureManager featureManager, BackupFileStoreProvider backupFileStoreProvider, FileStores fileStores) {
        this.featureManager = featureManager;
        this.backupFileStoreProvider = backupFileStoreProvider;
        this.fileStores = fileStores;
    }

    public String getBackupPath() {
        if (this.isFileStoreWellConfigured() && this.isFileStoreFeatureFlagEnabled()) {
            return this.backupFileStoreProvider.getBasePath().toString();
        }
        return this.fileStores.getExportBackupsPath().asJavaPath().toString();
    }

    public Optional<S3FileStoreConfig> getS3FileStoreConfig() {
        if (this.isFileStoreConfiguredForS3()) {
            S3BackupFileStoreProvider s3BackupFileStoreProvider = (S3BackupFileStoreProvider)this.backupFileStoreProvider;
            return Optional.of(s3BackupFileStoreProvider.getS3FileStoreConfig());
        }
        return Optional.empty();
    }

    public boolean isS3InUse() {
        return this.isFileStoreConfiguredForS3() && this.isFileStoreFeatureFlagEnabled();
    }

    public boolean isFileStoreFullyConfigured() {
        return this.isFileStoreWellConfigured() && this.isFileStoreFeatureFlagEnabled();
    }

    private boolean isFileStoreWellConfigured() {
        return !(this.backupFileStoreProvider instanceof NoOpBackupFileStoreProvider);
    }

    private boolean isFileStoreConfiguredForS3() {
        return this.backupFileStoreProvider instanceof S3BackupFileStoreProvider;
    }

    private boolean isFileStoreFeatureFlagEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.BACKUPS_STORAGE_CONFIGURABLE);
    }
}

