/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingFailureException;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.RateLimitingLogger;
import io.atlassian.util.concurrent.Timeout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class AccumulatingResultBuilder {
    private static final RateLimitingLogger log = new RateLimitingLogger(AccumulatingResultBuilder.class);
    private final Collection<InFlightResult> inFlightResults = new LinkedBlockingQueue<InFlightResult>();
    private int successesToDate = 0;
    private int failuresToDate = 0;
    private final Collection<Runnable> completionTasks = new LinkedList<Runnable>();

    public AccumulatingResultBuilder add(@Nonnull Index.Result result) {
        Assertions.notNull((String)"result", (Object)result);
        if (result instanceof CompositeResult) {
            CompositeResult compositeResult = (CompositeResult)result;
            for (InFlightResult ifr : compositeResult.getResults()) {
                this.addInternal(ifr);
            }
            this.successesToDate += compositeResult.getSuccesses();
            this.failuresToDate += compositeResult.getFailures();
        } else {
            this.addInternal(null, null, result);
        }
        return this;
    }

    public AccumulatingResultBuilder add(String indexName, Long identifier, @Nonnull Index.Result result) {
        Assertions.notNull((String)"result", (Object)result);
        if (result instanceof CompositeResult) {
            this.add(result);
        } else {
            this.addInternal(indexName, identifier, result);
        }
        return this;
    }

    private void addInternal(InFlightResult ifr) {
        this.checkCompleted();
        if (ifr.getResult().isDone()) {
            this.collectResult(ifr.getIndexName(), ifr.getIdentifier(), ifr.getResult());
        } else {
            this.inFlightResults.add(ifr);
        }
    }

    private void addInternal(String indexName, Long identifier, @Nonnull Index.Result result) {
        this.checkCompleted();
        if (result.isDone()) {
            this.collectResult(indexName, identifier, result);
        } else {
            this.inFlightResults.add(new InFlightResult(indexName, identifier, result));
        }
    }

    public void addCompletionTask(@Nonnull Runnable runnable) {
        this.completionTasks.add((Runnable)Assertions.notNull((String)"runnable", (Object)runnable));
    }

    private void checkCompleted() {
        Iterator<InFlightResult> iterator = this.inFlightResults.iterator();
        while (iterator.hasNext()) {
            InFlightResult ifr = iterator.next();
            if (!ifr.getResult().isDone()) continue;
            this.collectResult(ifr.getIndexName(), ifr.getIdentifier(), ifr.getResult());
            iterator.remove();
        }
    }

    private void collectResult(String indexName, Long identifier, Index.Result result) {
        try {
            result.await();
            ++this.successesToDate;
        }
        catch (RuntimeException e) {
            ++this.failuresToDate;
            AccumulatingResultBuilder.logFailure(indexName, identifier, e);
        }
        catch (Error e) {
            ++this.failuresToDate;
            AccumulatingResultBuilder.logFailure(indexName, identifier, e);
        }
    }

    public Index.Result toResult() {
        return new CompositeResult(this.inFlightResults, this.successesToDate, this.failuresToDate, this.completionTasks);
    }

    private static void logFailure(String indexName, Long identifier, Throwable e) {
        if (indexName != null) {
            log.warn("Indexing failed for " + indexName + " - '" + identifier + "'");
        }
        log.warn(e.getMessage(), e);
    }

    static class CompositeResult
    implements Index.Result {
        private final Collection<InFlightResult> results;
        private final Queue<Runnable> completionTasks;
        private int successes;
        private int failures;

        CompositeResult(Collection<InFlightResult> inFlightResults, int successes, int failures, Collection<Runnable> completionTasks) {
            this.successes = successes;
            this.failures = failures;
            this.results = new LinkedBlockingQueue<InFlightResult>(inFlightResults);
            this.completionTasks = new LinkedList<Runnable>(completionTasks);
        }

        @Override
        public void await() {
            Iterator<InFlightResult> it = this.results.iterator();
            while (it.hasNext()) {
                InFlightResult ifr = it.next();
                Index.Result result = ifr.getResult();
                try {
                    result.await();
                    ++this.successes;
                }
                catch (RuntimeException e) {
                    ++this.failures;
                    AccumulatingResultBuilder.logFailure(ifr.getIndexName(), ifr.getIdentifier(), e);
                }
                it.remove();
            }
            if (this.failures > 0) {
                throw new IndexingFailureException(this.failures);
            }
            this.complete();
        }

        private void complete() {
            while (!this.completionTasks.isEmpty()) {
                Runnable task = this.completionTasks.poll();
                if (task == null) continue;
                task.run();
            }
        }

        @Override
        public boolean await(long time, TimeUnit unit) {
            Timeout timeout = Timeout.getNanosTimeout((long)time, (TimeUnit)unit);
            Iterator<InFlightResult> it = this.results.iterator();
            while (it.hasNext()) {
                InFlightResult ifr = it.next();
                Index.Result result = ifr.getResult();
                try {
                    if (!result.await(timeout.getTime(), timeout.getUnit())) {
                        return false;
                    }
                    ++this.successes;
                }
                catch (RuntimeException e) {
                    ++this.failures;
                    AccumulatingResultBuilder.logFailure(ifr.getIndexName(), ifr.getIdentifier(), e);
                }
                it.remove();
            }
            if (this.failures > 0) {
                throw new IndexingFailureException(this.failures);
            }
            this.complete();
            return true;
        }

        @Override
        public boolean isDone() {
            for (InFlightResult ifr : this.results) {
                if (ifr.getResult().isDone()) continue;
                return false;
            }
            return true;
        }

        Iterable<InFlightResult> getResults() {
            return this.results;
        }

        int getSuccesses() {
            return this.successes;
        }

        int getFailures() {
            return this.failures;
        }
    }

    static class InFlightResult {
        private final String indexName;
        private final Long identifier;
        private final Index.Result result;

        InFlightResult(String indexName, Long identifier, Index.Result result) {
            this.indexName = indexName;
            this.identifier = identifier;
            this.result = result;
        }

        String getIndexName() {
            return this.indexName;
        }

        Long getIdentifier() {
            return this.identifier;
        }

        Index.Result getResult() {
            return this.result;
        }
    }
}

