/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;

public class DefaultConfiguration
implements Configuration {
    private final Directory directory;
    private final Analyzer analyzer;
    private final IndexWriterConfiguration writerConfiguration;

    public DefaultConfiguration(@Nonnull Directory directory, @Nonnull Analyzer analyzer) {
        this(directory, analyzer, Default.writerConfiguration);
    }

    public DefaultConfiguration(@Nonnull Directory directory, @Nonnull Analyzer analyzer, @Nonnull IndexWriterConfiguration writerConfiguration) {
        this.directory = (Directory)Assertions.notNull((String)"directory", (Object)directory);
        this.analyzer = (Analyzer)Assertions.notNull((String)"analyzer", (Object)analyzer);
        this.writerConfiguration = (IndexWriterConfiguration)Assertions.notNull((String)"writerConfiguration", (Object)writerConfiguration);
    }

    @Override
    @Nonnull
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    @Nonnull
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    @Nonnull
    public IndexWriterConfiguration.WriterSettings getWriterSettings(Index.UpdateMode mode) {
        return mode.getWriterSettings(this.writerConfiguration);
    }

    static final class Default {
        private static final IndexWriterConfiguration.WriterSettings interactiveWriterSettings = new IndexWriterConfiguration.WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return 1024;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }

            @Override
            public boolean getReaderPooling() {
                return true;
            }
        };
        private static final IndexWriterConfiguration.WriterSettings batchWriterSettings = new IndexWriterConfiguration.WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return 1024;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }

            @Override
            public boolean getReaderPooling() {
                return true;
            }
        };
        private static final IndexWriterConfiguration writerConfiguration = new IndexWriterConfiguration(){

            @Override
            public IndexWriterConfiguration.WriterSettings getInteractiveSettings() {
                return interactiveWriterSettings;
            }

            @Override
            public IndexWriterConfiguration.WriterSettings getBatchSettings() {
                return batchWriterSettings;
            }
        };

        Default() {
        }
    }
}

