/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultIndex
implements CloseableIndex {
    private final Engine engine;

    DefaultIndex(@Nonnull Engine engine) {
        this.engine = (Engine)Assertions.notNull((String)"engine", (Object)engine);
    }

    @Override
    @Nonnull
    public Index.Result perform(@Nonnull Index.Operation operation) {
        Assertions.notNull((String)"operation", (Object)operation);
        try {
            this.engine.write(operation);
            return new Success();
        }
        catch (IOException e) {
            return new Failure(e);
        }
        catch (Error e) {
            return new Failure(e);
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    @Override
    public void close() {
        this.engine.close();
    }

    static interface Engine
    extends Closeable {
        public void write(@Nonnull Index.Operation var1) throws IOException;

        @Override
        public void close();

        @Nonnull
        public UnmanagedIndexSearcher getSearcher();

        public void clean();
    }

    public static class Success
    implements Index.Result {
        @Override
        public void await() {
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    public static class Failure
    implements Index.Result {
        private final Throwable failure;

        public Failure(Error failure) {
            this.failure = failure;
        }

        public Failure(RuntimeException failure) {
            this.failure = failure;
        }

        public Failure(Exception failure) {
            this.failure = new RuntimeException(failure);
        }

        @Override
        public void await() {
            this.doThrow();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return this.doThrow();
        }

        @Override
        public boolean isDone() {
            return true;
        }

        private boolean doThrow() {
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            throw (Error)this.failure;
        }
    }
}

