/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.index.AtomicSupplier;
import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.QueueingIndexPriority;
import com.atlassian.jira.index.QueueingIndexStats;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueingIndex
implements CloseableIndex {
    private static final Logger log = LoggerFactory.getLogger(QueueingIndex.class);
    private final Task task = new Task();
    private final AtomicSupplier<Thread> indexerThread = new AtomicSupplier<Thread>(){

        @Override
        @Nonnull
        protected Thread create() {
            Thread thread = QueueingIndex.this.threadFactory.newThread(QueueingIndex.this.task);
            thread.setPriority(10);
            thread.start();
            return thread;
        }
    };
    private final ThreadFactory threadFactory;
    private final CloseableIndex delegate;
    final PriorityBlockingQueue<FutureOperation> queuePrimary;
    final PriorityBlockingQueue<FutureOperation> queueSecondary;
    final int maxQueueSize;
    private final Lock lock = new ReentrantLock();
    private final Condition queueNotFull = this.lock.newCondition();
    private final Condition queueNotEmpty = this.lock.newCondition();
    private final QueueingIndexStats.TotalAndSnapshotQueueingIndexStats stats;

    QueueingIndex(@Nonnull String name, @Nonnull CloseableIndex delegate, int maxQueueSize) {
        this(name, ThreadFactories.namedThreadFactory((String)Assertions.notNull((String)"name", (Object)name) + "-indexQueue"), delegate, maxQueueSize);
    }

    @VisibleForTesting
    QueueingIndex(@Nonnull String indexName, @Nonnull ThreadFactory threadFactory, @Nonnull CloseableIndex delegate, int maxQueueSize) {
        this.threadFactory = (ThreadFactory)Assertions.notNull((String)"threadFactory", (Object)threadFactory);
        this.delegate = (CloseableIndex)Assertions.notNull((String)"delegate", (Object)delegate);
        this.queuePrimary = new PriorityBlockingQueue<FutureOperation>(maxQueueSize, FutureOperation.PRIORITY_COMPARATOR);
        this.queueSecondary = new PriorityBlockingQueue<FutureOperation>(maxQueueSize, FutureOperation.PRIORITY_COMPARATOR);
        this.maxQueueSize = maxQueueSize;
        this.stats = new QueueingIndexStats.TotalAndSnapshotQueueingIndexStats(indexName);
    }

    boolean isQueuePrimary() {
        return ExecutingHttpRequest.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilQueueNotFullAndAdd(boolean isQueuePrimary, FutureOperation future) throws InterruptedException {
        this.lock.lock();
        try {
            PriorityBlockingQueue<FutureOperation> currentQueue = isQueuePrimary ? this.queuePrimary : this.queueSecondary;
            String currentQueueName = isQueuePrimary ? "queue.primary" : "queue.secondary";
            boolean queueFull = false;
            while (currentQueue.size() >= this.maxQueueSize) {
                queueFull = true;
                log.trace("[INDEXING-QUEUE] Waiting for space in {}, queue.primary.size:{}, queue.secondary.size:{}", new Object[]{currentQueueName, this.queuePrimary.size(), this.queueSecondary.size()});
                this.queueNotFull.await();
            }
            log.trace("[INDEXING-QUEUE] Queue {} not full, queue.primary.size:{}, queue.secondary.size:{}. Adding...", new Object[]{currentQueueName, this.queuePrimary.size(), this.queueSecondary.size()});
            currentQueue.put(future);
            log.trace("[INDEXING-QUEUE] Added index.operation to {}, queue.primary.size:{}, queue.secondary.size:{}", new Object[]{currentQueueName, this.queuePrimary.size(), this.queueSecondary.size()});
            this.stats.onQueuePut(future, currentQueue.size(), queueFull);
            this.queueNotEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private FutureOperation waitUntilAnyQueueNotEmptyAndPoll() throws InterruptedException {
        FutureOperation futureOperation;
        this.lock.lock();
        try {
            while (this.queuePrimary.isEmpty() && this.queueSecondary.isEmpty()) {
                this.queueNotEmpty.await();
            }
            if (!this.queuePrimary.isEmpty()) {
                log.trace("[INDEXING-QUEUE] Consuming indexing.operation from queue.primary, queue.primary.size:{}, queue.secondary.size:{}", (Object)this.queuePrimary.size(), (Object)this.queueSecondary.size());
                futureOperation = this.queuePrimary.poll();
            } else if (!this.queueSecondary.isEmpty()) {
                log.trace("[INDEXING-QUEUE] Consuming indexing.operation from queue.secondary, queue.primary.size:{}, queue.secondary.size:{}", (Object)this.queuePrimary.size(), (Object)this.queueSecondary.size());
                futureOperation = this.queueSecondary.poll();
            } else {
                throw new IllegalStateException("Both indexing queues can not be empty.");
            }
            this.queueNotFull.signalAll();
            this.stats.onQueueGet(futureOperation);
        }
        finally {
            this.lock.unlock();
        }
        return futureOperation;
    }

    @Override
    @Nonnull
    public Index.Result perform(@Nonnull Index.Operation operation) {
        boolean isQueuePrimary = this.isQueuePrimary();
        FutureOperation future = new FutureOperation(operation, QueueingIndexPriority.getPriority(), isQueuePrimary);
        try {
            this.waitUntilQueueNotFullAndAdd(isQueuePrimary, future);
        }
        catch (InterruptedException e) {
            return new DefaultIndex.Failure(e);
        }
        this.ensureRunning();
        return new ResultWithCallbacks(new FutureResult((Future<Index.Result>)((Object)future)), () -> this.stats.onOperationComplete(future), () -> this.stats.onOperationFailed(future), () -> this.stats.onOperationTimeout(future));
    }

    @Override
    public void close() {
        Thread thread = this.indexerThread.get();
        try {
            while (thread.isAlive()) {
                this.task.interrupt(thread);
                thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        finally {
            this.indexerThread.compareAndSetNull(thread);
            this.delegate.close();
        }
    }

    private void ensureRunning() {
        Thread thread;
        while (!(thread = this.indexerThread.get()).isAlive()) {
            this.stats.onNotRunning();
            this.indexerThread.compareAndSetNull(thread);
        }
        return;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.index();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        synchronized void interrupt(Thread thread) {
            thread.interrupt();
        }

        synchronized void perform(CompositeOperation operation) {
            boolean interrupted = Thread.interrupted();
            try {
                operation.set(QueueingIndex.this.delegate.perform(operation));
            }
            finally {
                if (interrupted) {
                    QueueingIndex.selfInterrupt();
                }
            }
        }

        void index() throws InterruptedException {
            FutureOperation futureOperation = QueueingIndex.this.waitUntilAnyQueueNotEmptyAndPoll();
            Stopwatch timeToUpdateIndex = Stopwatch.createStarted();
            this.perform(new CompositeOperation((List<FutureOperation>)ImmutableList.of((Object)((Object)futureOperation))));
            QueueingIndex.this.stats.onIndexUpdate(futureOperation, timeToUpdateIndex.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    static class FutureOperation
    extends SettableFuture<Index.Result> {
        private final Index.Operation operation;
        private final long timestamp;
        private final int priority;
        private final boolean primaryQueue;
        private static Comparator<FutureOperation> PRIORITY_COMPARATOR = Comparator.comparingInt(FutureOperation::getPriority).thenComparingLong(FutureOperation::getTimestamp);

        FutureOperation(Index.Operation operation, int priority, boolean primaryQueue) {
            this.operation = (Index.Operation)Assertions.notNull((String)"operation", (Object)operation);
            this.primaryQueue = primaryQueue;
            this.priority = priority;
            this.timestamp = QueueingIndexStats.Time.CLOCK.millis();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isPrimaryQueue() {
            return this.primaryQueue;
        }

        Index.UpdateMode mode() {
            return this.operation.mode();
        }
    }

    private final class ResultWithCallbacks
    implements Index.Result {
        private final AtomicBoolean hasOutcome = new AtomicBoolean(false);
        private final Index.Result delegate;
        private final Runnable finishedWithSuccess;
        private final Runnable finishedWithFailure;
        private final Runnable finishedWithTimeout;

        private ResultWithCallbacks(Index.Result delegate, Runnable finishedWithSuccess, Runnable finishedWithFailure, Runnable finishedWithTimeout) {
            this.delegate = delegate;
            this.finishedWithSuccess = finishedWithSuccess;
            this.finishedWithFailure = finishedWithFailure;
            this.finishedWithTimeout = finishedWithTimeout;
        }

        @Override
        public void await() {
            try {
                this.delegate.await();
                this.onSuccess();
            }
            catch (Exception e) {
                this.onFailure();
                throw e;
            }
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            try {
                boolean result = this.delegate.await(timeout, unit);
                if (result) {
                    this.onSuccess();
                } else {
                    this.onTimeout();
                }
                return result;
            }
            catch (Exception e) {
                this.onFailure();
                throw e;
            }
        }

        private void onTimeout() {
            if (this.hasOutcome.compareAndSet(false, true)) {
                this.finishedWithTimeout.run();
            }
        }

        private void onFailure() {
            if (this.hasOutcome.compareAndSet(false, true)) {
                this.finishedWithFailure.run();
            }
        }

        private void onSuccess() {
            if (this.hasOutcome.compareAndSet(false, true)) {
                this.finishedWithSuccess.run();
            }
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }
    }

    static class CompositeOperation
    extends Index.Operation {
        private final List<FutureOperation> operations;

        CompositeOperation(List<FutureOperation> operations) {
            this.operations = Collections.unmodifiableList(operations);
        }

        public void set(Index.Result result) {
            for (FutureOperation future : this.operations) {
                future.set(result);
            }
        }

        @Override
        void perform(@Nonnull Writer writer) throws IOException {
            Iterator<FutureOperation> iter = this.operations.iterator();
            try {
                while (iter.hasNext()) {
                    iter.next().operation.perform(writer);
                }
            }
            catch (RuntimeException re) {
                CompositeOperation.cancelTheRest(iter, re);
                throw re;
            }
            catch (IOException ioe) {
                CompositeOperation.cancelTheRest(iter, ioe);
                throw ioe;
            }
        }

        private static void cancelTheRest(Iterator<FutureOperation> iter, Throwable cause) {
            CancellationException ce = new CancellationException("Cancelled composite indexing operation due to unhandled exception " + cause);
            ce.initCause(cause);
            while (iter.hasNext()) {
                iter.next().setException(ce);
            }
        }

        @Override
        Index.UpdateMode mode() {
            for (FutureOperation future : this.operations) {
                if (future.mode() != Index.UpdateMode.BATCH) continue;
                return Index.UpdateMode.BATCH;
            }
            return Index.UpdateMode.INTERACTIVE;
        }
    }
}

