/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.index.QueueingIndex;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.time.Clock;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface QueueingIndexStats {
    public static QueueingIndexStats create(String indexName) {
        return new TotalAndSnapshotQueueingIndexStats(indexName);
    }

    public void onQueuePut(QueueingIndex.FutureOperation var1, int var2, boolean var3);

    public void onQueueGet(QueueingIndex.FutureOperation var1);

    public void onIndexUpdate(QueueingIndex.FutureOperation var1, long var2);

    public void onOperationComplete(QueueingIndex.FutureOperation var1);

    public void onOperationFailed(QueueingIndex.FutureOperation var1);

    public void onOperationTimeout(QueueingIndex.FutureOperation var1);

    public void onNotRunning();

    public static class TotalAndSnapshotQueueingIndexStats
    implements QueueingIndexStats {
        private static final Logger log = LoggerFactory.getLogger(QueueingIndexStats.class);
        private static final String PREFIX = "[JIRA-STATS] [INDEXING-QUEUE] ";
        static final long STATS_PERIOD_MILLIS = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
        private final String indexName;
        private final PrimaryAndSecondaryQueueingIndexStats totalStats;
        private final PrimaryAndSecondaryQueueingIndexStats snapshotStats;
        private long lastPrintTimestamp;

        TotalAndSnapshotQueueingIndexStats(String indexName) {
            this.indexName = indexName;
            this.totalStats = new PrimaryAndSecondaryQueueingIndexStats();
            this.snapshotStats = new PrimaryAndSecondaryQueueingIndexStats();
            this.lastPrintTimestamp = Time.CLOCK.millis();
        }

        @Override
        public void onQueuePut(QueueingIndex.FutureOperation futureOperation, int currentQueueSize, boolean queueFull) {
            this.totalStats.onQueuePut(futureOperation, currentQueueSize, queueFull);
            this.snapshotStats.onQueuePut(futureOperation, currentQueueSize, queueFull);
            this.printStatsNotToOften();
        }

        @Override
        public void onQueueGet(QueueingIndex.FutureOperation futureOperation) {
            this.totalStats.onQueueGet(futureOperation);
            this.snapshotStats.onQueueGet(futureOperation);
            this.printStatsNotToOften();
        }

        @Override
        public void onIndexUpdate(QueueingIndex.FutureOperation futureOperation, long timeToUpdateIndexMillis) {
            this.totalStats.onIndexUpdate(futureOperation, timeToUpdateIndexMillis);
            this.snapshotStats.onIndexUpdate(futureOperation, timeToUpdateIndexMillis);
            this.printStatsNotToOften();
        }

        @Override
        public void onOperationComplete(QueueingIndex.FutureOperation futureOperation) {
            this.totalStats.onOperationComplete(futureOperation);
            this.snapshotStats.onOperationComplete(futureOperation);
            this.printStatsNotToOften();
        }

        @Override
        public void onOperationFailed(QueueingIndex.FutureOperation futureOperation) {
            this.totalStats.onOperationFailed(futureOperation);
            this.snapshotStats.onOperationFailed(futureOperation);
            this.printStatsNotToOften();
        }

        @Override
        public void onOperationTimeout(QueueingIndex.FutureOperation futureOperation) {
            this.totalStats.onOperationTimeout(futureOperation);
            this.snapshotStats.onOperationTimeout(futureOperation);
            this.printStatsNotToOften();
        }

        @Override
        public void onNotRunning() {
            this.totalStats.onNotRunning();
            this.snapshotStats.onNotRunning();
            this.printStatsNotToOften();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void printStatsNotToOften() {
            if (this.canPrintStats()) {
                TotalAndSnapshotQueueingIndexStats totalAndSnapshotQueueingIndexStats = this;
                synchronized (totalAndSnapshotQueueingIndexStats) {
                    if (this.canPrintStats()) {
                        this.printAndResetStats();
                    }
                }
            }
        }

        private boolean canPrintStats() {
            return Time.CLOCK.millis() - this.lastPrintTimestamp > STATS_PERIOD_MILLIS;
        }

        private void printAndResetStats() {
            Gson gson = new Gson();
            String totalJsonPrimary = gson.toJson((Object)this.totalStats.primaryQueueStats.get());
            String totalJsonSecondary = gson.toJson((Object)this.totalStats.secondaryQueueStats.get());
            String snapshotJsonPrimary = gson.toJson((Object)this.snapshotStats.primaryQueueStats.get());
            String snapshotJsonSecondary = gson.toJson((Object)this.snapshotStats.secondaryQueueStats.get());
            log.info("{} index:{}, total primary queue stats: {}", new Object[]{PREFIX, this.indexName, totalJsonPrimary});
            log.info("{} index:{}, total secondary queue stats: {}", new Object[]{PREFIX, this.indexName, totalJsonSecondary});
            log.info("{} index:{}, snapshot primary queue stats: {}", new Object[]{PREFIX, this.indexName, snapshotJsonPrimary});
            log.info("{} index:{}, snapshot secondary queue stats: {}", new Object[]{PREFIX, this.indexName, snapshotJsonSecondary});
            this.lastPrintTimestamp = Time.CLOCK.millis();
            this.snapshotStats.reset();
        }
    }

    public static class MutableQueueingIndexStats
    implements QueueingIndexStats {
        private static final String SYSTEM_PROPERTY_MAX_THREAD_STATS_STORED = "com.atlassian.jira.index.queueing.stats.max.threads";
        private static final String SYSTEM_PROPERTY_TOP_N_THREADS = "com.atlassian.jira.index.queueing.stats.top.threads";
        private final Comparator<Map.Entry<String, AtomicLong>> COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC = Map.Entry.comparingByValue(Comparator.comparingLong(AtomicLong::longValue).reversed()).thenComparing(Map.Entry.comparingByKey());
        private static final long MAX_THREAD_STATS_STORED = JiraSystemProperties.getInstance().getLong("com.atlassian.jira.index.queueing.stats.max.threads", Long.valueOf(1000L));
        private static final int TOP_N_THREADS = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.index.queueing.stats.top.threads", Integer.valueOf(10));
        private final AtomicInteger maxQueueSize = new AtomicInteger(0);
        private final AtomicLong putCounter = new AtomicLong(0L);
        private final AtomicInteger queueFullOnPut = new AtomicInteger(0);
        private final AtomicLong getCounter = new AtomicLong(0L);
        private final MutableLongStats timeInQueueMillis = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 20000L, 30000L});
        private final MutableLongStats timeToUpdateIndexMillis = new MutableLongStats(new long[]{0L, 1L, 10L, 50L, 100L, 500L, 1000L});
        private final MutableLongStats totalTimeMillis = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 20000L, 30000L});
        private final MutableLongStats totalTimeFailedMillis = new MutableLongStats(new long[0]);
        private final MutableLongStats totalTimeTimedOutMillis = new MutableLongStats(new long[0]);
        private final LoadingCache<String, AtomicLong> putCounterByThread = CacheBuilder.newBuilder().maximumSize(MAX_THREAD_STATS_STORED).build((CacheLoader)new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(String key) {
                return new AtomicLong(0L);
            }
        });
        private final AtomicLong indexerNotRunningCounter = new AtomicLong(0L);

        Result get() {
            return new Result();
        }

        private void reset() {
            this.maxQueueSize.set(0);
            this.putCounter.set(0L);
            this.queueFullOnPut.set(0);
            this.putCounterByThread.invalidateAll();
            this.getCounter.set(0L);
            this.timeInQueueMillis.reset();
            this.timeToUpdateIndexMillis.reset();
            this.totalTimeMillis.reset();
            this.totalTimeFailedMillis.reset();
            this.totalTimeTimedOutMillis.reset();
            this.indexerNotRunningCounter.set(0L);
        }

        @Override
        public void onQueuePut(QueueingIndex.FutureOperation futureOperation, int currentQueueSize, boolean queueFull) {
            this.maxQueueSize.updateAndGet(c -> Math.max(c, currentQueueSize));
            if (queueFull) {
                this.queueFullOnPut.incrementAndGet();
            }
            this.putCounter.incrementAndGet();
            ((AtomicLong)this.putCounterByThread.getUnchecked((Object)Thread.currentThread().getName())).incrementAndGet();
        }

        @Override
        public void onQueueGet(QueueingIndex.FutureOperation futureOperation) {
            this.getCounter.incrementAndGet();
            this.timeInQueueMillis.accept(Time.CLOCK.millis() - futureOperation.getTimestamp());
        }

        @Override
        public void onIndexUpdate(QueueingIndex.FutureOperation futureOperation, long timeToUpdateIndexMillis) {
            this.timeToUpdateIndexMillis.accept(timeToUpdateIndexMillis);
        }

        @Override
        public void onOperationComplete(QueueingIndex.FutureOperation futureOperation) {
            this.totalTimeMillis.accept(Time.CLOCK.millis() - futureOperation.getTimestamp());
        }

        @Override
        public void onOperationFailed(QueueingIndex.FutureOperation futureOperation) {
            this.totalTimeFailedMillis.accept(Time.CLOCK.millis() - futureOperation.getTimestamp());
        }

        @Override
        public void onOperationTimeout(QueueingIndex.FutureOperation futureOperation) {
            this.totalTimeTimedOutMillis.accept(Time.CLOCK.millis() - futureOperation.getTimestamp());
        }

        @Override
        public void onNotRunning() {
            this.indexerNotRunningCounter.incrementAndGet();
        }

        private class Result {
            private final Integer maxQueueSize;
            private final Long putCounter;
            private final Integer queueFullOnPut;
            private final Long getCounter;
            private final LongStats timeInQueueMillis;
            private final LongStats timeToUpdateIndexMillis;
            private final LongStats totalTimeMillis;
            private final LongStats totalTimeFailedMillis;
            private final LongStats totalTimeTimedOutMillis;
            private final Map<String, Long> putCounterByThreadTopN;
            private Long indexerNotRunningCounter;

            private Result() {
                this.maxQueueSize = MutableQueueingIndexStats.this.maxQueueSize.get();
                this.putCounter = MutableQueueingIndexStats.this.putCounter.get();
                this.queueFullOnPut = MutableQueueingIndexStats.this.queueFullOnPut.get();
                this.getCounter = MutableQueueingIndexStats.this.getCounter.get();
                this.timeInQueueMillis = MutableQueueingIndexStats.this.timeInQueueMillis.get();
                this.timeToUpdateIndexMillis = MutableQueueingIndexStats.this.timeToUpdateIndexMillis.get();
                this.totalTimeMillis = MutableQueueingIndexStats.this.totalTimeMillis.get();
                this.totalTimeFailedMillis = MutableQueueingIndexStats.this.totalTimeFailedMillis.get();
                this.totalTimeTimedOutMillis = MutableQueueingIndexStats.this.totalTimeTimedOutMillis.get();
                this.putCounterByThreadTopN = (Map)MutableQueueingIndexStats.this.putCounterByThread.asMap().entrySet().stream().sorted(MutableQueueingIndexStats.this.COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC).limit(TOP_N_THREADS).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
                this.indexerNotRunningCounter = MutableQueueingIndexStats.this.indexerNotRunningCounter.get();
            }
        }
    }

    public static class PrimaryAndSecondaryQueueingIndexStats
    implements QueueingIndexStats {
        private final MutableQueueingIndexStats primaryQueueStats = new MutableQueueingIndexStats();
        private final MutableQueueingIndexStats secondaryQueueStats = new MutableQueueingIndexStats();

        private Result get() {
            return new Result();
        }

        private void reset() {
            this.primaryQueueStats.reset();
            this.secondaryQueueStats.reset();
        }

        private MutableQueueingIndexStats getQueueStats(boolean isQueuePrimary) {
            return isQueuePrimary ? this.primaryQueueStats : this.secondaryQueueStats;
        }

        private MutableQueueingIndexStats getQueueStats(QueueingIndex.FutureOperation futureOperation) {
            return this.getQueueStats(futureOperation.isPrimaryQueue());
        }

        @Override
        public void onQueuePut(QueueingIndex.FutureOperation futureOperation, int currentSize, boolean queueFull) {
            this.getQueueStats(futureOperation.isPrimaryQueue()).onQueuePut(futureOperation, currentSize, queueFull);
        }

        @Override
        public void onQueueGet(QueueingIndex.FutureOperation futureOperation) {
            this.getQueueStats(futureOperation).onQueueGet(futureOperation);
        }

        @Override
        public void onIndexUpdate(QueueingIndex.FutureOperation futureOperation, long timeToUpdateIndexMillis) {
            this.getQueueStats(futureOperation).onIndexUpdate(futureOperation, timeToUpdateIndexMillis);
        }

        @Override
        public void onOperationComplete(QueueingIndex.FutureOperation futureOperation) {
            this.getQueueStats(futureOperation).onOperationComplete(futureOperation);
        }

        @Override
        public void onOperationFailed(QueueingIndex.FutureOperation futureOperation) {
            this.getQueueStats(futureOperation).onOperationFailed(futureOperation);
        }

        @Override
        public void onOperationTimeout(QueueingIndex.FutureOperation futureOperation) {
            this.getQueueStats(futureOperation).onOperationTimeout(futureOperation);
        }

        @Override
        public void onNotRunning() {
            this.getQueueStats(true).onNotRunning();
            this.getQueueStats(false).onNotRunning();
        }

        private class Result {
            final MutableQueueingIndexStats.Result primaryQueueStats;
            final MutableQueueingIndexStats.Result secondaryQueueStats;

            private Result() {
                this.primaryQueueStats = PrimaryAndSecondaryQueueingIndexStats.this.primaryQueueStats.get();
                this.secondaryQueueStats = PrimaryAndSecondaryQueueingIndexStats.this.secondaryQueueStats.get();
            }
        }
    }

    public static class Time {
        static Clock CLOCK = Clock.systemDefaultZone();
    }
}

