/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexCopyService
implements IndexCopyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexCopyService.class);
    public static final String BACKUP_INDEX_DONE = "Index Backed Up";
    public static final String BACKUP_INDEX = "Backup Index";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexCopyService.class);
    private final MessageConsumer messageConsumer;

    public DefaultIndexCopyService(FileStores fileStores, IndexSnapshotOperator indexSnapshotOperator, MessageHandlerService messageHandlerService, EventPublisher eventPublisher, IndexRecoveryManager indexRecoveryManager, I18nHelper i18n, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager issueManager) {
        String sharedIndexSnapshotPath = fileStores.getIndexSnapshotsPath().asJavaFile().getAbsolutePath();
        this.messageConsumer = new MessageConsumer(indexSnapshotOperator, indexRecoveryManager, messageHandlerService, sharedIndexSnapshotPath, eventPublisher, ofBizNodeIndexOperationStore, issueManager);
        messageHandlerService.registerListener(BACKUP_INDEX, this.messageConsumer);
        messageHandlerService.registerListener(BACKUP_INDEX_DONE, this.messageConsumer);
    }

    @Override
    public String backupIndex(@Nullable String requestingNode) {
        return this.backupIndex(null, requestingNode);
    }

    @Override
    public String backupIndex(@Nullable TemporaryFilesProvider temporaryFilesProvider, @Nullable String requestingNode) {
        return this.messageConsumer.backupIndex(temporaryFilesProvider, requestingNode);
    }

    @Override
    public void restoreIndex(String filePath) {
        this.messageConsumer.restoreIndex(filePath);
    }

    @VisibleForTesting
    String copyIndex(@Nullable String requestingNodeId) {
        return this.messageConsumer.copyIndex(null, requestingNodeId);
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private final IndexSnapshotOperator indexSnapshotOperator;
        private final IndexRecoveryManager indexRecoveryManager;
        private final MessageHandlerService messageHandlerService;
        private final String sharedIndexSnapshotPath;
        private final EventPublisher eventPublisher;
        private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
        private final IssueIndexManager issueManager;
        private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);

        public MessageConsumer(IndexSnapshotOperator indexSnapshotOperator, IndexRecoveryManager indexRecoveryManager, MessageHandlerService messageHandlerService, String sharedIndexSnapshotPath, EventPublisher eventPublisher, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager issueManager) {
            this.indexSnapshotOperator = indexSnapshotOperator;
            this.indexRecoveryManager = indexRecoveryManager;
            this.messageHandlerService = messageHandlerService;
            this.sharedIndexSnapshotPath = sharedIndexSnapshotPath;
            this.eventPublisher = eventPublisher;
            this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
            this.issueManager = issueManager;
        }

        public String backupIndex(String requestingNode) {
            return this.backupIndex(null, requestingNode);
        }

        public String backupIndex(TemporaryFilesProvider temporaryFilesProvider, String requestingNode) {
            if (!((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                throw new UnsupportedOperationException("This method should be called in DC configuration only");
            }
            String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
            LOG.info("Index backup started. Requesting node: {}, currentNode: {}", (Object)requestingNode, (Object)nodeId);
            if (!this.isIndexUpToDate()) {
                LOG.warn("Index backup failed - the index is out of date. Requesting node: {}, currentNode: {}", (Object)requestingNode, (Object)nodeId);
                return null;
            }
            if (!this.issueManager.isIndexConsistent()) {
                LOG.error("Note that node: {} is waiting for an index and failed to restore the index from shared and from this node.This state require admin action. Both nodes: {} and {}, must obtain a consistent index.Please check KB: {} to find out how can you solve this problem.", new Object[]{requestingNode, requestingNode, nodeId, "https://confluence.atlassian.com/x/OYNyQg"});
                return null;
            }
            String backupFileName = this.copyIndex(temporaryFilesProvider, requestingNode);
            if (!requestingNode.equals(nodeId)) {
                log.info("Sending message: \"{}\":{} - notification that current node: {} created an index snapshot which can be restored on requesting node: {}", new Object[]{DefaultIndexCopyService.BACKUP_INDEX_DONE, backupFileName, nodeId, requestingNode});
                this.messageHandlerService.sendMessage(requestingNode, new Message(DefaultIndexCopyService.BACKUP_INDEX_DONE, backupFileName));
            } else {
                log.debug("Not sending message: {} to itself on node: {}", (Object)DefaultIndexCopyService.BACKUP_INDEX_DONE, (Object)nodeId);
            }
            LOG.info("Index backup complete. Snapshot file: {}", (Object)backupFileName);
            return backupFileName;
        }

        private boolean isIndexUpToDate() {
            Long latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(((ClusterManager)this.clusterManagerRef.get()).getNodeId());
            return latestOperation != null || this.issueManager.isIndexConsistent();
        }

        @VisibleForTesting
        String copyIndex(@Nullable TemporaryFilesProvider temporaryFilesProvider, @Nullable String requestingNodeId) {
            return this.indexSnapshotOperator.forceCreateSnapshot(temporaryFilesProvider, requestingNodeId).getSnapshotName();
        }

        public void restoreIndex(String fileName) {
            if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                LOG.info("Starting index restore");
                try {
                    LOG.info("Total {} issues on instance before loading Snapshot file: {}", (Object)this.getNumberOfIssues(), (Object)fileName);
                }
                catch (Exception e) {
                    String message = "Could not read local index size before loading Snapshot file: {}. This might occur when local index is corrupted but does not affect the snapshot restore process. Proceeding with restore";
                    if (log.isDebugEnabled()) {
                        log.debug("Could not read local index size before loading Snapshot file: {}. This might occur when local index is corrupted but does not affect the snapshot restore process. Proceeding with restore", (Object)fileName, (Object)e);
                    }
                    log.warn("Could not read local index size before loading Snapshot file: {}. This might occur when local index is corrupted but does not affect the snapshot restore process. Proceeding with restore", (Object)fileName);
                }
                File backupFile = new File(this.sharedIndexSnapshotPath, fileName);
                try {
                    this.indexRecoveryManager.recoverIndexFromBackup(backupFile, TaskProgressSink.NULL_SINK);
                }
                catch (IndexException e) {
                    throw new RuntimeException(e);
                }
                this.eventPublisher.publish((Object)IndexesRestoredEvent.INSTANCE);
                LOG.info("Index restore complete. Total {} issues on instance", (Object)this.getNumberOfIssues());
            }
        }

        private String getNumberOfIssues() {
            return Optional.ofNullable(this.issueManager).map(IssueIndexManager::getIssueSearcher).map(issueSearcher -> issueSearcher.getIndexReader()).map(IndexReader::numDocs).map(Long::toString).orElse("[Unknown]");
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX)) {
                log.info("Received message: \"{}\" - request to create index snapshot from node: {} on current node: {}", new Object[]{channel, senderId, ((ClusterManager)this.clusterManagerRef.get()).getNodeId()});
                this.backupIndex(senderId);
            } else if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX_DONE)) {
                log.info("Received message: \"{}\" - notification that node: {} created an index snapshot which can be restored on current node: {}", new Object[]{channel, senderId, ((ClusterManager)this.clusterManagerRef.get()).getNodeId()});
                this.restoreIndex(message);
            }
        }
    }
}

