/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.core.util.DateUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryResult;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.ReindexMetadata;
import com.atlassian.jira.index.ha.events.IndexSnapshotConsumedEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.InternalIndexingService;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.startup.ThreadDumper;
import com.atlassian.jira.task.CompositeProgressSink;
import com.atlassian.jira.task.LoggingProgressSink;
import com.atlassian.jira.task.ScalingTaskProgessSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.compression.ArchiveUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.versioning.EntityVersion;
import com.atlassian.jira.versioning.EntityVersioningManager;
import com.atlassian.jira.versioning.VersioningCleanupService;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class DefaultIndexRecoveryManager
implements IndexRecoveryManager {
    public static final String INDEX_FIXER = "[INDEX-FIXER] ";
    private static final String FIXING_INSTRUCTION = "Any changes made since snapshot creation have not been added to the new index! You can run a background reindex to add missing issue changes to the index.";
    private static final Logger LOG = Logger.getLogger(DefaultIndexRecoveryManager.class);
    private static final int DELETE_OLD_INDEXES_MAX_RETRIES = 3;
    private final IndexLifecycleManager indexLifecycleManager;
    private final IndexPathManager indexPathManager;
    private final SharedEntityIndexManager sharedEntityIndexManager;
    private final IndexingCounterManager indexingCounterManager;
    private final IssueIndexManager indexManager;
    private final IssueIndexingService issueIndexingService;
    private final AtomicBoolean recoveryInProgress;
    private final ThreadDumper threadDumper;
    private final CommentManager commentManager;
    private final WorklogManager worklogManager;
    private final EntityVersioningManager entityVersioningManager;
    private final VersioningCleanupService versionsCleaner;
    private final EventPublisher eventPublisher;
    private final ClusterNodes clusterNodes;
    private final IssueIndexer issueIndexer;
    private final InternalIndexingService internalIndexingService;
    private final I18nHelper i18nHelper;

    public DefaultIndexRecoveryManager(IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager, IssueIndexManager indexManager, CommentManager commentManager, WorklogManager worklogManager, EntityVersioningManager entityVersioningManager, VersioningCleanupService versionsCleaner, EventPublisher eventPublisher, ClusterNodes clusterNodes, IssueIndexer issueIndexer, InternalIndexingService internalIndexingService, I18nHelper i18nHelper) {
        this.indexLifecycleManager = indexLifecycleManager;
        this.indexPathManager = indexPathManager;
        this.sharedEntityIndexManager = sharedEntityIndexManager;
        this.indexingCounterManager = indexingCounterManager;
        this.indexManager = indexManager;
        this.issueIndexingService = indexManager;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.entityVersioningManager = entityVersioningManager;
        this.versionsCleaner = versionsCleaner;
        this.eventPublisher = eventPublisher;
        this.clusterNodes = clusterNodes;
        this.issueIndexer = issueIndexer;
        this.internalIndexingService = internalIndexingService;
        this.i18nHelper = i18nHelper;
        this.recoveryInProgress = new AtomicBoolean(false);
        this.threadDumper = new ThreadDumper(0L);
    }

    @Override
    public IndexCommandResult safeRecoverIndexFromBackup(File recoveryFile, TaskProgressSink taskProgressSink) throws IndexException {
        return this.recoverIndexFromBackup(recoveryFile, taskProgressSink, true);
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(File recoveryFile, TaskProgressSink taskProgressSink) throws IndexException {
        return this.recoverIndexFromBackup(recoveryFile, taskProgressSink, false);
    }

    private IndexCommandResult recoverIndexFromBackup(File recoveryFile, TaskProgressSink taskProgressSink, boolean shouldThrowOnNullRange) throws IndexException {
        File workDir = new File(this.indexPathManager.getIndexRootPath(), "JIRAIndexRestore");
        if (!this.recoveryInProgress.compareAndSet(false, true)) {
            throw new IndexException("Index recovery already in progress");
        }
        try {
            Stopwatch reindexRecoveryTimeStopwatch = Stopwatch.createStarted();
            ArchiveUtils.decompress(recoveryFile, workDir);
            Duration decompressionTime = reindexRecoveryTimeStopwatch.elapsed();
            this.validateIssueIndex(workDir);
            CompositeProgressSink compositeSink = new CompositeProgressSink(taskProgressSink, new LoggingProgressSink(LOG, "[INDEX-FIXER] {1} - {0}% complete... {2}", 1));
            long startTime = System.currentTimeMillis();
            ReplaceIndexRunner runner = new ReplaceIndexRunner(workDir, this.indexLifecycleManager, this.indexPathManager, compositeSink, shouldThrowOnNullRange);
            compositeSink.makeProgress(1L, "Restoring search indexes from snapshot and catching up with changes", "Starting");
            LOG.info((Object)"[INDEX-FIXER] Starting the index recovery process by replacing existing indexes. For the whole time of recovering the index (restoring and catch up) we will be holding the index write lock");
            if (!this.indexManager.withReindexLock(JiraThreadLocalUtils.wrap(runner))) {
                throw new IndexException("Failed to acquire reindex lock");
            }
            Duration totalTime = reindexRecoveryTimeStopwatch.elapsed();
            int nodeIdentifier = IndexUtils.getNodeIdentifier(this.clusterNodes.current());
            this.eventPublisher.publish((Object)new IndexSnapshotConsumedEvent(nodeIdentifier, decompressionTime, totalTime));
            IndexCommandResult indexCommandResult = new IndexCommandResult(System.currentTimeMillis() - startTime);
            return indexCommandResult;
        }
        catch (IOException e) {
            throw new IndexException((Exception)e);
        }
        catch (CatchupRuntimeIndexException e) {
            throw e.getIndexException();
        }
        finally {
            FileUtils.deleteQuietly((File)workDir);
            this.recoveryInProgress.set(false);
        }
    }

    private void validateIssueIndex(File workDir) throws IOException, IndexFormatTooOldException {
        int basePathLength = this.indexPathManager.getIndexRootPath().length();
        String issuesSubdirectory = this.indexPathManager.getIssueIndexPath().substring(basePathLength + 1);
        try (FSDirectory issuesDirectory = FSDirectory.open((Path)workDir.toPath().resolve(issuesSubdirectory));
             DirectoryReader issuesReader = DirectoryReader.open((Directory)issuesDirectory);){
            int numDocs = issuesReader.numDocs();
            LOG.info((Object)("[INDEX-FIXER] We will restore index snapshot with " + numDocs + " issues"));
        }
    }

    @Override
    public IndexRecoveryResult reindexWithVersionCheckEntitiesUpdatedInTheLast(Duration duration, TaskProgressSink taskProgressSink) throws IndexException {
        return this.reindexWithVersionCheckEntitiesUpdatedInTheLast(duration, false, taskProgressSink);
    }

    @Override
    public IndexRecoveryResult deindexEntitiesDeletedInTheLast(Duration duration, TaskProgressSink taskProgressSink) throws IndexException {
        return this.reindexWithVersionCheckEntitiesUpdatedInTheLast(duration, true, taskProgressSink);
    }

    private IndexRecoveryResult reindexWithVersionCheckEntitiesUpdatedInTheLast(Duration duration, boolean deIndexOnly, TaskProgressSink taskProgressSink) throws IndexException {
        Stopwatch timeTotal = Stopwatch.createStarted();
        boolean durationIsLongerThanRetentionPeriod = this.durationIsLongerThanRetentionPeriod(duration);
        if (durationIsLongerThanRetentionPeriod) {
            LOG.warn((Object)String.format("[INDEX-FIXER] The Versioning Cleanup Service may have run in the last %s. Records of deleted versions may have already been removed from the db. Some stale issues may linger in the index because of this.", DefaultIndexRecoveryManager.readableDuration(duration)));
        }
        taskProgressSink.makeProgress(30L, "Catch up", String.format("Re-indexing issues modified in the last %s. (Versioning short-circuit checks are enabled.)", DefaultIndexRecoveryManager.readableDuration(duration)));
        Stopwatch stopwatchReadFromDB = Stopwatch.createStarted();
        List<EntityVersion> dbIssueVersionsUpdatedSinceDuration = this.entityVersioningManager.findEntityVersionsUpdatedInTheLast(IndexDirectoryFactory.Name.ISSUE, duration);
        List<EntityVersion> dbCommentVersionsUpdatedSinceDuration = this.entityVersioningManager.findEntityVersionsUpdatedInTheLast(IndexDirectoryFactory.Name.COMMENT, duration);
        List<EntityVersion> dbWorklogVersionsUpdatedSinceDuration = this.entityVersioningManager.findEntityVersionsUpdatedInTheLast(IndexDirectoryFactory.Name.WORKLOG, duration);
        String timeToReadFromDB = stopwatchReadFromDB.toString();
        Stopwatch stopwatchDeindex = Stopwatch.createStarted();
        Set<WithId> issueIdsThatWereDeindexed = this.deindexDeletedEntities(dbIssueVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.ISSUE);
        Set<WithId> commentIdsThatWereDeindexed = this.deindexDeletedEntities(dbCommentVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.COMMENT);
        Set<WithId> worklogIdsThatWereDeindexed = this.deindexDeletedEntities(dbWorklogVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.WORKLOG);
        String timeToDeindex = stopwatchDeindex.toString();
        Stopwatch stopwatchReindex = Stopwatch.createStarted();
        List issueIdsThatWereReindexed = deIndexOnly ? Collections.emptyList() : this.reindexOutdatedEntities(dbIssueVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.ISSUE, taskProgressSink);
        List commentIdsThatWereReindexed = deIndexOnly ? Collections.emptyList() : this.reindexOutdatedEntities(dbCommentVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.COMMENT, taskProgressSink);
        List worklogIdsThatWereReindexed = deIndexOnly ? Collections.emptyList() : this.reindexOutdatedEntities(dbWorklogVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name.WORKLOG, taskProgressSink);
        String timeToReindex = stopwatchReindex.toString();
        String doneSummary = String.format("Done catching up. " + (deIndexOnly ? "Indexing was skipped. " : "Potentially outdated issues were updated in the index. ") + "Any deleted issues (plus comments & worklogs) in this range were removed from the index. %d issues, %d comments and %d worklogs scanned. %d issues, %d comments and %d worklogs reindexed. %d issues, %d comments and %d worklogs deindexed. It took %s to read from DB, %s to reindex, %s to deindex, %s in total", dbIssueVersionsUpdatedSinceDuration.size(), dbCommentVersionsUpdatedSinceDuration.size(), dbWorklogVersionsUpdatedSinceDuration.size(), issueIdsThatWereReindexed.size(), commentIdsThatWereReindexed.size(), worklogIdsThatWereReindexed.size(), issueIdsThatWereDeindexed.size(), commentIdsThatWereDeindexed.size(), worklogIdsThatWereDeindexed.size(), timeToReadFromDB, timeToReindex, timeToDeindex, timeTotal);
        taskProgressSink.makeProgress(95L, "Catch up", doneSummary);
        int processedDeindexOperations = issueIdsThatWereDeindexed.size() + commentIdsThatWereDeindexed.size() + worklogIdsThatWereDeindexed.size();
        int processedReindexOperations = issueIdsThatWereReindexed.size() + commentIdsThatWereReindexed.size() + worklogIdsThatWereReindexed.size();
        return new IndexRecoveryResult(processedDeindexOperations, processedReindexOperations, durationIsLongerThanRetentionPeriod);
    }

    private boolean durationIsLongerThanRetentionPeriod(Duration targetDuration) {
        return targetDuration.compareTo(this.versionsCleaner.getRetentionPeriod().minus(Duration.ofMinutes(1L))) > 0;
    }

    private Set<WithId> deindexDeletedEntities(List<EntityVersion> dbEntityVersionsUpdatedSinceDuration, IndexDirectoryFactory.Name targetIndex) throws IndexException {
        Set<WithId> idsToDeindex = dbEntityVersionsUpdatedSinceDuration.stream().filter(EntityVersion::isDeleted).collect(Collectors.toSet());
        switch (targetIndex) {
            case ISSUE: {
                this.indexManager.deIndexIssueObjectsById(idsToDeindex, false);
                break;
            }
            case COMMENT: {
                this.indexManager.deIndexComments(idsToDeindex, false);
                break;
            }
            case WORKLOG: {
                this.indexManager.deIndexWorklogs(idsToDeindex, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized index type " + targetIndex);
            }
        }
        LOG.trace((Object)String.format("[INDEX-FIXER] Done replaying de-indexing for %s: %d entities were deleted from the index.", targetIndex.name(), idsToDeindex.size()));
        return idsToDeindex;
    }

    private List<Long> reindexOutdatedEntities(List<EntityVersion> dbEntityVersionsUpdatedInRange, IndexDirectoryFactory.Name targetIndex, TaskProgressSink taskProgressSink) throws IndexException {
        Set<EntityVersion> notDeleted = dbEntityVersionsUpdatedInRange.stream().filter(ev -> !ev.isDeleted()).collect(Collectors.toSet());
        Set<EntityVersion> needToReindex = this.filterOutAlreadyIndexedEntities(notDeleted, targetIndex);
        List<Long> idsToReindex = needToReindex.stream().map(EntityVersion::getId).collect(Collectors.toList());
        switch (targetIndex) {
            case ISSUE: {
                this.reindexIssueByIds(idsToReindex, taskProgressSink);
                break;
            }
            case COMMENT: {
                this.reindexCommentsByIds(idsToReindex, taskProgressSink);
                break;
            }
            case WORKLOG: {
                this.reindexWorklogsByIds(idsToReindex, taskProgressSink);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported index " + targetIndex);
            }
        }
        LOG.trace((Object)String.format("[INDEX-FIXER] Done replaying re-indexing for %s: %d outdated entities were reindexed.", targetIndex.name(), idsToReindex.size()));
        return idsToReindex;
    }

    private void reindexIssueByIds(List<Long> idsToReindex, TaskProgressSink taskProgressSink) throws IndexException {
        if (idsToReindex.size() > 0) {
            Context context = this.createContextWithScalingProgressSink(idsToReindex, taskProgressSink);
            this.internalIndexingService.reindexIssuesBatchMode(idsToReindex, context, IssueIndexingParams.INDEX_ISSUE_WITH_HISTORY);
        } else {
            taskProgressSink.makeProgress(80L, "Updating issue index with recent changes", "There were no issue changes, skipping.");
        }
    }

    private Context createContextWithScalingProgressSink(final List<Long> idsToReindex, TaskProgressSink taskProgressSink) {
        ScalingTaskProgessSink scalingTaskProgessSink = new ScalingTaskProgessSink(30L, 80L, taskProgressSink);
        Context context = Contexts.builder().progress((TaskProgressSink)scalingTaskProgessSink, this.i18nHelper, "catch.up.reindex.issues.percentage.progress", "catch.up.reindex.issues.subtask").sized(new Sized(){

            public int size() {
                return idsToReindex.size();
            }

            public boolean isEmpty() {
                return false;
            }
        }).build();
        context.setName("Updating index with recent changes");
        return context;
    }

    private void reindexCommentsByIds(List<Long> idsToReindex, TaskProgressSink taskProgressSink) throws IndexException {
        List<Comment> commentsToReindex = idsToReindex.stream().map(arg_0 -> ((CommentManager)this.commentManager).getCommentById(arg_0)).collect(Collectors.toList());
        if (commentsToReindex.isEmpty()) {
            taskProgressSink.makeProgress(85L, "Updating index with recent changes", "There were no comment changes, skipping.");
        } else {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOG.info((Object)"Reindexing comments.");
            this.internalIndexingService.reindexCommentsInParallel(commentsToReindex, Contexts.nullContext());
            LOG.info((Object)("Finished reindexing " + commentsToReindex.size() + " comments, took: " + stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            taskProgressSink.makeProgress(85L, "Updating index with recent changes", "Reindex of comments completed.");
        }
    }

    private void reindexWorklogsByIds(List<Long> idsToReindex, TaskProgressSink taskProgressSink) throws IndexException {
        Set<Worklog> worklogsToReindex = idsToReindex.stream().map(arg_0 -> ((WorklogManager)this.worklogManager).getById(arg_0)).collect(Collectors.toSet());
        if (worklogsToReindex.isEmpty()) {
            taskProgressSink.makeProgress(90L, "Updating index with recent changes", "There were no worklog changes, skipping.");
        } else {
            Stopwatch started = Stopwatch.createStarted();
            LOG.info((Object)"Reindexing worklogs.");
            this.internalIndexingService.reindexWorklogsInParallel(worklogsToReindex, Contexts.nullContext());
            LOG.info((Object)("Finished reindexing " + worklogsToReindex.size() + " worklogs, took: " + started.elapsed(TimeUnit.MILLISECONDS)));
            taskProgressSink.makeProgress(90L, "Updating index with recent changes", "Reindex of worklogs completed.");
        }
    }

    private Set<EntityVersion> filterOutAlreadyIndexedEntities(Collection<EntityVersion> dbEntityVersions, IndexDirectoryFactory.Name targetIndex) {
        Map<Long, Optional<Long>> indexVersions = this.getCorrespondingEntityIndexVersions(dbEntityVersions, targetIndex);
        return dbEntityVersions.stream().filter(dbVers -> ((Optional)indexVersions.get(dbVers.getId())).map(indexVersion -> indexVersion < dbVers.getVersion()).orElse(true)).collect(Collectors.toSet());
    }

    private Map<Long, Optional<Long>> getCorrespondingEntityIndexVersions(Collection<EntityVersion> dbEntityVersions, IndexDirectoryFactory.Name targetIndex) throws RuntimeIOException {
        try {
            return this.entityVersioningManager.getLocalVersions(dbEntityVersions.stream().map(EntityVersion::getId).collect(Collectors.toSet()), targetIndex);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public DateUtils.DateRange getDurationToCatchUpUsingVersions() {
        Instant latestIndexInstant = this.indexManager.getLatestIndexDate();
        Timestamp latestIndexDate = latestIndexInstant != null ? Timestamp.from(latestIndexInstant) : null;
        Date latestDbDate = this.getLatestDbDateFromVersioningTable();
        if (latestDbDate == null || latestIndexDate == null) {
            LOG.info((Object)String.format("[INDEX-FIXER] Failed to find duration to catch up. Latest index date: {%s}, Latest DB issue-version date: {%s}", latestIndexDate, latestDbDate));
            return null;
        }
        LOG.info((Object)String.format("[INDEX-FIXER] Latest index date: {%1$tF %1$tT}, Latest DB issue-version date: {%2$tF %2$tT}", latestIndexDate, latestDbDate));
        return new DateUtils.DateRange((Date)latestIndexDate, latestDbDate);
    }

    private Date getLatestDbDateFromVersioningTable() {
        Date result;
        LOG.trace((Object)"[INDEX-FIXER] Getting latest issue update date from the issue_version table");
        Optional<Instant> latest = this.entityVersioningManager.getLatestEntityUpdate(IndexDirectoryFactory.Name.ISSUE).map(EntityVersion::getDbUpdatedTime);
        if (latest.isPresent()) {
            result = Date.from(latest.get());
            LOG.debug((Object)String.format("[INDEX-FIXER] Latest issue-version update in the db was at: {%s}", result));
        } else {
            LOG.debug((Object)"[INDEX-FIXER] Unable to get latest issue-version update in the db--no results found.");
            result = null;
        }
        return result;
    }

    public static Duration padDurationBetween(Instant priorTime, Supplier<Instant> currentTime) {
        return Duration.between(priorTime, currentTime.get()).plusDays(1L);
    }

    public static String readableDuration(Duration duration) {
        return "{" + duration.toDays() + " days, " + duration.toHours() % 24L + " hours, " + duration.toMinutes() % 60L + " minutes, and " + duration.getSeconds() % 60L + " seconds}";
    }

    public int size() {
        return 100;
    }

    public boolean isEmpty() {
        return false;
    }

    private class ReplaceIndexRunner
    implements Runnable {
        private final File workDir;
        private final IndexLifecycleManager indexLifecycleManager;
        private final IndexPathManager indexPathManager;
        private final TaskProgressSink taskProgressSink;
        private final boolean shouldThrowOnNullRange;

        ReplaceIndexRunner(File workDir, IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager, TaskProgressSink taskProgressSink, boolean shouldThrowOnNullRange) {
            this.workDir = workDir;
            this.indexLifecycleManager = indexLifecycleManager;
            this.indexPathManager = indexPathManager;
            this.taskProgressSink = taskProgressSink;
            this.shouldThrowOnNullRange = shouldThrowOnNullRange;
        }

        @Override
        @GuardedBy(value="external index write lock")
        public void run() {
            this.indexLifecycleManager.deactivate();
            this.removeIndexes();
            this.replaceIndexesAndReactivateManager();
            this.taskProgressSink.makeProgress(30L, "Restoring search indexes", "Restored index backup");
            try {
                this.catchUp();
            }
            catch (IndexException exception) {
                String errorMessage = "[INDEX-FIXER] There was an error while reindexing missing issues. Any changes made since snapshot creation have not been added to the new index! You can run a background reindex to add missing issue changes to the index.";
                LOG.error((Object)"[INDEX-FIXER] There was an error while reindexing missing issues. Any changes made since snapshot creation have not been added to the new index! You can run a background reindex to add missing issue changes to the index.", (Throwable)exception);
                throw new CatchupRuntimeIndexException(exception);
            }
            catch (NullRangeException e) {
                String errorMsg = "[INDEX-FIXER] The indexes have been restored from the snapshot but we couldn't calculate the duration to catch up on changes introduced since index snapshot was created. Any changes made since snapshot creation have not been added to the new index! You can run a background reindex to add missing issue changes to the index.";
                LOG.error((Object)errorMsg, (Throwable)e);
                if (this.shouldThrowOnNullRange) {
                    throw new CatchupRuntimeIndexException(new IndexException(errorMsg, (Exception)e));
                }
                LOG.info((Object)"We will ignore the error and continue with further steps of index recovery.");
            }
            this.taskProgressSink.makeProgress(99L, "Recovering", "Done catching up");
            DefaultIndexRecoveryManager.this.sharedEntityIndexManager.reIndexAll(Contexts.nullContext());
            DefaultIndexRecoveryManager.this.indexingCounterManager.incrementValue();
            this.taskProgressSink.makeProgress(100L, "Recovering", "Recovered all indexes");
        }

        private void replaceIndexesAndReactivateManager() {
            try {
                this.replaceIndexes(this.workDir);
            }
            finally {
                this.indexLifecycleManager.shutdown();
                this.indexLifecycleManager.activate(Contexts.nullContext(), false);
            }
            LOG.info((Object)"[INDEX-FIXER] Done replacing existing indexes. We will continue with the index catch up.");
        }

        private void catchUp() throws IndexException, NullRangeException {
            DateUtils.DateRange range = this.calculateDurationToRecoverUsingVersions();
            if (range == null) {
                LOG.error((Object)"[INDEX-FIXER] Could not calculate the duration to catch up based on latest index date from issue index and latest db issue-version date. Any changes made since snapshot creation have not been added to the new index! You can run a background reindex to add missing issue changes to the index.");
                throw new NullRangeException();
            }
            Instant rangeStart = range.startDate.toInstant();
            Duration paddedDuration = DefaultIndexRecoveryManager.padDurationBetween(rangeStart, Instant::now);
            LOG.info((Object)String.format("[INDEX-FIXER] Re-indexing issues updated in the last %s. (Note: it's an intentionally wider range)", DefaultIndexRecoveryManager.readableDuration(paddedDuration)));
            DefaultIndexRecoveryManager.this.reindexWithVersionCheckEntitiesUpdatedInTheLast(paddedDuration, false, this.taskProgressSink);
        }

        @Nullable
        private DateUtils.DateRange calculateDurationToRecoverUsingVersions() {
            DateUtils.DateRange dateRange = null;
            try {
                ReindexMetadata metadata = new ReindexMetadata(this.workDir);
                Date startTime = metadata.getIndexStartTime();
                LOG.debug((Object)String.format("[INDEX-FIXER] Checking reindex metadata for a startTime; found {%s}", startTime));
                if (startTime != null) {
                    Date latestDbVersionDate = DefaultIndexRecoveryManager.this.getLatestDbDateFromVersioningTable();
                    LOG.debug((Object)String.format("[INDEX-FIXER] Checking DB for latest issue-version date; found {%s}", latestDbVersionDate));
                    if (latestDbVersionDate != null) {
                        dateRange = new DateUtils.DateRange(startTime, latestDbVersionDate);
                        LOG.info((Object)String.format("[INDEX-FIXER] Re-index start time: {%1$tF %1$tT.%1$tL}, Latest DB issue-version date: {%2$tF %2$tT.%2$tL}", startTime, latestDbVersionDate));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"[INDEX-FIXER] Could not calculate the duration to catch up based on snapshot metadata and latest db issue-version date", (Throwable)e);
            }
            if (dateRange == null) {
                LOG.debug((Object)"[INDEX-FIXER] Since we could not determine the duration to catch up using snapshot metadata, we're falling back to comparing the latest index date with the latest db issue-version date");
                dateRange = DefaultIndexRecoveryManager.this.getDurationToCatchUpUsingVersions();
            }
            return dateRange;
        }

        private void removeIndexes() {
            SharedEntityIndexer sharedEntityIndexer = (SharedEntityIndexer)ComponentAccessor.getComponent(SharedEntityIndexer.class);
            DefaultIndexRecoveryManager.this.issueIndexer.deleteIndexes();
            sharedEntityIndexer.clear(SearchRequest.ENTITY_TYPE);
            sharedEntityIndexer.clear(PortalPage.ENTITY_TYPE);
        }

        private void replaceIndexes(File workDir) {
            File indexDirectory = new File(this.indexPathManager.getIndexRootPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getSharedEntityIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getWorklogIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getChangeHistoryIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getCommentIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getIssueIndexPath());
            if (!indexDirectory.exists()) {
                indexDirectory.mkdirs();
            }
            this.moveIndexFiles(new File(workDir, "entities"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "worklogs"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "changes"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "comments"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "issues"), indexDirectory);
        }

        private void cleanDirectoryWithRetries(String path) {
            File directory = new File(path);
            if (!directory.exists()) {
                return;
            }
            for (int attempts = 1; attempts <= 3; ++attempts) {
                try {
                    FileUtils.cleanDirectory((File)directory);
                    return;
                }
                catch (IOException e) {
                    if (attempts < 3) {
                        LOG.warn((Object)String.format("[INDEX-FIXER] Failed to clean the indexes in directory '%s', attempt [%d] out of [%d]. Retrying the operation.", path, attempts, 3));
                        try {
                            Thread.sleep((long)attempts * 100L);
                        }
                        catch (InterruptedException interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        LOG.error((Object)String.format("[INDEX-FIXER] Failed to clean the indexes in directory '%s', attempt [%d] out of [%d]. Giving up. Old indexes should get automatically deleted during the next index recovery.", path, attempts, 3));
                    }
                    DefaultIndexRecoveryManager.this.threadDumper.run();
                    continue;
                }
            }
        }

        private void moveIndexFiles(File workIndexDir, File indexDir) {
            File actualIndexDir = new File(indexDir, workIndexDir.getName());
            if (!workIndexDir.exists() || !workIndexDir.isDirectory()) {
                LOG.warn((Object)String.format("[INDEX-FIXER] '%s' does not exist or is not a directory", workIndexDir));
                return;
            }
            Collection indexFiles = FileUtils.listFiles((File)workIndexDir, null, (boolean)true);
            for (File indexFile : indexFiles) {
                File dest = new File(actualIndexDir, workIndexDir.toURI().relativize(indexFile.toURI()).getPath());
                try {
                    FileUtils.moveFile((File)indexFile, (File)dest);
                }
                catch (IOException e) {
                    LOG.error((Object)String.format("[INDEX-FIXER] Unable to move the index file from '%s' to '%s'", indexFile, dest), (Throwable)e);
                }
            }
        }
    }

    private static final class CatchupRuntimeIndexException
    extends RuntimeException {
        private final IndexException indexException;

        public CatchupRuntimeIndexException(IndexException indexException) {
            this.indexException = indexException;
        }

        public IndexException getIndexException() {
            return this.indexException;
        }
    }

    private static final class NullRangeException
    extends Exception {
        private NullRangeException() {
        }
    }
}

