/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.WithIdAndVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;

class EntityWithOperation
implements WithIdAndVersion {
    private final IndexDirectoryFactory.Name indexName;
    private final long entityId;
    private Date indexTime;
    private ReplicatedIndexOperation.Operation operation;
    private Long entityVersion;

    EntityWithOperation(IndexDirectoryFactory.Name indexName, long entityId) {
        this.indexName = indexName;
        this.entityId = entityId;
    }

    static Comparator<EntityWithOperation> indexTimeBasedComparator() {
        return Comparator.comparing(entityWithOperation -> entityWithOperation.indexTime);
    }

    static EntityWithOperation create(IndexDirectoryFactory.Name indexName, long entityId) {
        return new EntityWithOperation(indexName, entityId);
    }

    static EntityWithOperation createForVersionZero(IndexDirectoryFactory.Name indexName, long entityId, ReplicatedIndexOperation.Operation newOperation, Date indexTime) {
        EntityWithOperation entityWithVersionOperation = new EntityWithOperation(indexName, entityId);
        entityWithVersionOperation.operation = newOperation;
        entityWithVersionOperation.indexTime = indexTime;
        entityWithVersionOperation.entityVersion = EntityDocumentFactory.ENTITY_VERSION_ZERO;
        return entityWithVersionOperation;
    }

    void maybeSetOperationAndVersion(ReplicatedIndexOperation.Operation newOperation, Date indexTime, long newEntityVersion) {
        if (this.entityVersion == null || newEntityVersion >= this.entityVersion) {
            this.operation = this.existingOperationVsNewOperation(newOperation);
            this.indexTime = indexTime;
            this.entityVersion = newEntityVersion;
        } else if (newOperation == ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED && this.operation == ReplicatedIndexOperation.Operation.UPDATE) {
            this.operation = ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED;
        }
    }

    ReplicatedIndexOperation.Operation existingOperationVsNewOperation(ReplicatedIndexOperation.Operation newOperation) {
        if (this.operation == ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED && newOperation == ReplicatedIndexOperation.Operation.UPDATE) {
            return ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED;
        }
        return newOperation;
    }

    Date getIndexTime() {
        return this.indexTime;
    }

    ReplicatedIndexOperation.Operation getOperation() {
        return this.operation;
    }

    public Long getId() {
        return this.entityId;
    }

    @Override
    public Long getVersion() {
        return this.entityVersion;
    }

    public IndexDirectoryFactory.Name getIndexName() {
        return this.indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityWithOperation that = (EntityWithOperation)o;
        return this.entityId == that.entityId && this.getIndexName() == that.getIndexName() && this.getOperation() == that.getOperation();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexName, this.getId(), this.getOperation()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityWithVersionOperation{");
        sb.append("indexName=").append((Object)this.indexName);
        sb.append(", entityId=").append(this.entityId);
        sb.append(", indexTime=").append(this.indexTime);
        sb.append(", operation=").append((Object)this.operation);
        sb.append(", entityVersion=").append(this.entityVersion);
        sb.append('}');
        return sb.toString();
    }
}

