/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;

class FailedReplicationOperation {
    private long tries;
    private final long maxRetries;
    private LocalDateTime nextAttemptTime;
    private final Set<ReplicatedIndexOperation> operations;
    private Clock clock;

    FailedReplicationOperation(Set<ReplicatedIndexOperation> operations, long maxRetries) {
        this(operations, maxRetries, Clock.systemDefaultZone());
    }

    FailedReplicationOperation(Set<ReplicatedIndexOperation> operations, long maxRetries, Clock clock) {
        this(0L, maxRetries, operations, clock);
    }

    FailedReplicationOperation(long tries, long maxRetries, Set<ReplicatedIndexOperation> operations, Clock clock) {
        this.maxRetries = maxRetries;
        this.clock = clock;
        this.tries = tries;
        this.operations = operations;
        this.nextAttemptTime = this.calculateNextAttemptTime(tries);
    }

    @VisibleForTesting
    long getTries() {
        return this.tries;
    }

    @VisibleForTesting
    LocalDateTime getNextAttemptTime() {
        return this.nextAttemptTime;
    }

    @VisibleForTesting
    Set<ReplicatedIndexOperation> getOperations() {
        return this.operations;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    boolean shouldRetryNow() {
        return LocalDateTime.now(this.clock).isAfter(this.nextAttemptTime);
    }

    boolean exceedsMaxRetries() {
        return this.tries > this.maxRetries;
    }

    void addFailure() {
        ++this.tries;
        this.nextAttemptTime = this.calculateNextAttemptTime(this.tries);
    }

    LocalDateTime calculateNextAttemptTime(long tries) {
        return LocalDateTime.now(this.clock).plusMinutes(tries * tries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedReplicationOperation that = (FailedReplicationOperation)o;
        return Objects.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(this.operations);
    }

    public String toString() {
        return "FailedReplicatedIndexOperation{tries=" + this.tries + ", maxRetries=" + this.maxRetries + ", attemptTime=" + this.nextAttemptTime + ", operationsCount=" + this.operations.size() + "}";
    }
}

