/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.util.concurrent.TimeUnit;

public interface IndexUtilsStats
extends ManagedStats {
    public static final long[] SNAPSHOT_TIME_DISTRIBUTION_IN_MILLIS = new long[]{TimeUnit.SECONDS.toMillis(10L), TimeUnit.MINUTES.toMillis(1L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(10L), TimeUnit.MINUTES.toMillis(30L), TimeUnit.HOURS.toMillis(1L), TimeUnit.HOURS.toMillis(5L)};
    public static final long[] SNAPSHOT_SIZE_DISTRIBUTION_IN_MEGABYTES = new long[]{1000L, 2000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 500000L};

    public void createdSnapshot(long var1);

    public void compressedSnapshot(long var1);

    public void uncompressedFilesProcessedSizeInMegabytes(long var1);

    public void compressedSizeInMegabytes(long var1);

    public void copyTime(long var1);

    public void deletionTime(long var1);

    public void isParallelCreationAllowed(boolean var1);

    public static class Data
    implements IndexUtilsStats {
        final MutableLongStats createdSnapshotTimeInMillis = new MutableLongStats(SNAPSHOT_TIME_DISTRIBUTION_IN_MILLIS);
        final MutableLongStats compressedSnapshotTimeInMillis = new MutableLongStats(SNAPSHOT_TIME_DISTRIBUTION_IN_MILLIS);
        final MutableLongStats uncompressedFilesProcessedSizeInMegabytes = new MutableLongStats(SNAPSHOT_SIZE_DISTRIBUTION_IN_MEGABYTES);
        final MutableLongStats compressedSizeInMegabytes = new MutableLongStats(SNAPSHOT_SIZE_DISTRIBUTION_IN_MEGABYTES);
        final MutableLongStats copyTimeInMillis = new MutableLongStats(SNAPSHOT_TIME_DISTRIBUTION_IN_MILLIS);
        final MutableLongStats deletionTimeInMillis = new MutableLongStats(SNAPSHOT_TIME_DISTRIBUTION_IN_MILLIS);
        final LastValueSerializableStats<Boolean> isParallelCreationAllowed = new LastValueSerializableStats();

        public String getStatsName() {
            return "IndexUtilsStats";
        }

        @Override
        public void createdSnapshot(long timeInMillis) {
            this.createdSnapshotTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void compressedSnapshot(long timeInMillis) {
            this.compressedSnapshotTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void uncompressedFilesProcessedSizeInMegabytes(long sizeInMegabytes) {
            this.uncompressedFilesProcessedSizeInMegabytes.accept(sizeInMegabytes);
        }

        @Override
        public void compressedSizeInMegabytes(long sizeInMegabytes) {
            this.compressedSizeInMegabytes.accept(sizeInMegabytes);
        }

        @Override
        public void copyTime(long timeInMillis) {
            this.copyTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void deletionTime(long timeInMillis) {
            this.deletionTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void isParallelCreationAllowed(boolean isAllowed) {
            this.isParallelCreationAllowed.store((Object)isAllowed);
        }
    }
}

