/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ReplicatedIndexOperation {
    public static final String ENTITY = "ReplicatedIndexOperation";
    public static final String ID = "id";
    public static final String INDEX_TIME = "indexTime";
    public static final String OPERATION = "operation";
    public static final String AFFECTED_INDEX = "affectedIndex";
    public static final String VERSIONS = "versions";
    public static final String ENTITY_TYPE = "entityType";
    public static final String NODE_ID = "nodeId";
    public static final String AFFECTED_IDS = "affectedIds";
    public static final String BACKUP_FILENAME = "filename";
    private final Timestamp indexTime;
    private final long id;
    private final String nodeId;
    private final Map<Long, Long> affectedIdToVersion;
    private final Operation operation;
    private final AffectedIndex affectedIndex;
    private final SharedEntityType entityType;
    private final String backupFilename;

    ReplicatedIndexOperation(long id, @Nonnull String nodeId, @Nonnull Timestamp indexTime, @Nonnull AffectedIndex affectedIndex, @Nonnull SharedEntityType entityType, @Nonnull Operation operation, @Nonnull Map<Long, Long> affectedIdToVersion, String backupFilename) {
        this.indexTime = (Timestamp)Assertions.notNull((String)INDEX_TIME, (Object)indexTime);
        this.id = (Long)Assertions.notNull((String)ID, (Object)id);
        this.nodeId = (String)Assertions.notNull((String)NODE_ID, (Object)nodeId);
        this.affectedIndex = (AffectedIndex)Assertions.notNull((String)AFFECTED_INDEX, (Object)affectedIndex);
        this.affectedIdToVersion = ImmutableMap.copyOf((Map)((Map)Assertions.notNull((String)AFFECTED_IDS, affectedIdToVersion)));
        this.operation = (Operation)((Object)Assertions.notNull((String)OPERATION, (Object)((Object)operation)));
        this.entityType = (SharedEntityType)Assertions.notNull((String)ENTITY_TYPE, (Object)entityType);
        this.backupFilename = backupFilename == null ? "" : backupFilename;
    }

    public Date getIndexTime() {
        return this.indexTime;
    }

    public long getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public AffectedIndex getAffectedIndex() {
        return this.affectedIndex;
    }

    public SharedEntityType getEntityType() {
        return this.entityType;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Set<Long> getAffectedIds() {
        return this.affectedIdToVersion.keySet();
    }

    public Map<Long, Long> getAffectedIdToVersion() {
        return this.affectedIdToVersion;
    }

    public String getBackupFilename() {
        return this.backupFilename;
    }

    public boolean equals(Object o) {
        return o instanceof ReplicatedIndexOperation && ((ReplicatedIndexOperation)o).id == this.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "ReplicatedIndexOperation{indexTime=" + this.indexTime + ", id=" + this.id + ", nodeId='" + this.nodeId + "', affectedIdToVersion=" + this.affectedIdToVersion + ", operation=" + this.operation + ", affectedIndex=" + this.affectedIndex + ", entityType=" + this.entityType + ", backupFilename='" + this.backupFilename + "'}";
    }

    public static enum Operation {
        UPDATE,
        CREATE,
        DELETE,
        FULL_REINDEX_START,
        FULL_REINDEX_END(true),
        BACKGROUND_REINDEX_START,
        BACKGROUND_REINDEX_END(true),
        PROJECT_REINDEX,
        UPDATE_WITH_RELATED,
        PROJECT_DEINDEX;

        private final boolean reindexEnd;

        private Operation() {
            this(false);
        }

        private Operation(boolean reindexEnd) {
            this.reindexEnd = reindexEnd;
        }

        public boolean isReindexEnd() {
            return this.reindexEnd;
        }
    }
}

