/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.ha.IndexBackupContributionStrategy;
import com.atlassian.jira.index.ha.IndexPerformAndSubpath;
import com.atlassian.jira.index.ha.backup.BackupBuilder;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDeletionPolicyContributionStrategy
implements IndexBackupContributionStrategy {
    private static final Logger log = LoggerFactory.getLogger(SnapshotDeletionPolicyContributionStrategy.class);
    static final String MESSAGE_UNUSED_WRITER = "No index commit to snapshot";
    private final File indexRootFile;
    private final CommitOperationsFactory operationsFactory;

    public SnapshotDeletionPolicyContributionStrategy(IndexPathManager indexPathManager, CommitOperationsFactory operationsFactory) {
        this.indexRootFile = new File(indexPathManager.getIndexRootPath());
        this.operationsFactory = operationsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToBackup(BackupBuilder backupBuilder, Collection<IndexPerformAndSubpath> indexes) {
        ArrayList<IndexCommitStore> indexCommitStores = new ArrayList<IndexCommitStore>();
        try {
            log.info("Creating {} commit points for Lucene indexes", (Object)indexes.size());
            for (IndexPerformAndSubpath entry : indexes) {
                IndexCommitStore indexCommitStore = new IndexCommitStore(entry);
                this.createCommitPoint(indexCommitStore);
                if (indexCommitStore.get() == null) continue;
                indexCommitStores.add(indexCommitStore);
            }
            for (IndexCommitStore commit : indexCommitStores) {
                ArrayList<File> fileNames = new ArrayList<File>();
                Path indexSubpath = commit.getAccessData().getIndexSubpath();
                try {
                    fileNames.addAll(this.getNonEmptyFiles(commit));
                }
                catch (IOException e) {
                    log.error(String.format("could not retrieve list of index files for %s, skipping,", indexSubpath), (Throwable)e);
                }
                log.info("Adding {} files from {} to backup...", (Object)fileNames.size(), (Object)indexSubpath);
                Stopwatch timeToAddToBackup = Stopwatch.createStarted();
                backupBuilder.addToBackup(fileNames, this.indexRootFile);
                log.info("Done adding {} files from {} to backup, time: {} ms", new Object[]{fileNames.size(), indexSubpath, timeToAddToBackup.stop().elapsed(TimeUnit.MILLISECONDS)});
            }
        }
        finally {
            log.info("Releasing {} commit points for Lucene indexes", (Object)indexCommitStores.size());
            for (IndexCommitStore commitPoint : indexCommitStores) {
                this.releaseCommitPoint(commitPoint);
            }
        }
    }

    void releaseCommitPoint(IndexCommitStore commitStore) {
        try {
            Index.Result result = commitStore.getAccessData().apply(this.operationsFactory.newReleaseCommitPoint(commitStore));
            result.await();
        }
        catch (Exception e) {
            log.error(String.format("Exception thrown during closure of commit point in %s, proceeding...", commitStore.getAccessData().getIndexSubpath()), (Throwable)e);
        }
    }

    void createCommitPoint(IndexCommitStore commitStore) {
        try {
            Index.Result result = commitStore.getAccessData().apply(this.operationsFactory.newCreateCommitPoint(commitStore));
            result.await();
        }
        catch (IllegalStateException e) {
            if (MESSAGE_UNUSED_WRITER.equals(e.getMessage())) {
                log.warn("Writer for {} was never used, skipping", (Object)commitStore.getAccessData().getIndexSubpath());
            }
            throw e;
        }
    }

    Collection<File> getNonEmptyFiles(IndexCommitStore commit) throws IOException {
        Path directoryPath = this.indexRootFile.toPath().resolve(commit.getAccessData().getIndexSubpath());
        Map filtered = commit.get().getFileNames().stream().map(f -> this.getFileLocation(directoryPath, (String)f)).collect(Collectors.partitioningBy(File::exists, Collectors.toList()));
        if (filtered.getOrDefault(false, Collections.emptyList()).size() > 0) {
            log.info("Skipping non-existent/empty files: {} ", filtered.get(false));
        }
        return filtered.getOrDefault(true, Collections.emptyList());
    }

    File getFileLocation(Path directoryPath, String filename) {
        return directoryPath.resolve(filename).toFile();
    }

    public static class CommitOperationsFactory {
        public Index.Operation newReleaseCommitPoint(IndexCommitStore commitStore) {
            return Operations.newReleaseCommitPoint(commitStore);
        }

        public Index.Operation newCreateCommitPoint(IndexCommitStore commitStore) {
            return Operations.newCreateCommitPoint(commitStore);
        }
    }

    static class IndexCommitStore
    implements Consumer<IndexCommit>,
    Supplier<IndexCommit> {
        private final IndexPerformAndSubpath accessData;
        private IndexCommit indexCommit;

        public IndexCommitStore(IndexPerformAndSubpath accessData) {
            this.accessData = accessData;
        }

        public IndexPerformAndSubpath getAccessData() {
            return this.accessData;
        }

        @Override
        public void accept(IndexCommit indexCommit) {
            this.indexCommit = indexCommit;
        }

        @Override
        public IndexCommit get() {
            return this.indexCommit;
        }
    }
}

