/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;

public interface WithIdAndVersion
extends WithId {
    public static WithIdAndVersion of(Long id, Long version) {
        return new DefaultWithIdAndVersion(id, version);
    }

    public Long getVersion();

    public static WithIdAndVersion fromDocument(IndexDirectoryFactory.Name indexName, Document document) throws IllegalArgumentException {
        String entityId = indexName.getEntityIdFromDocumentOrThrow(document);
        Long entityVersion = indexName.getEntityVersionFromDocumentOrThrow(document);
        return WithIdAndVersion.of(Long.parseLong(entityId), entityVersion);
    }

    public static Collection<WithIdAndVersion> fromDocuments(IndexDirectoryFactory.Name indexName, Collection<Document> documents) throws IllegalArgumentException {
        return documents.stream().map(document -> WithIdAndVersion.fromDocument(indexName, document)).collect(Collectors.toList());
    }

    public static class DefaultWithIdAndVersion
    implements WithIdAndVersion {
        private final Long id;
        private final Long version;

        public DefaultWithIdAndVersion(Long id, Long version) {
            this.id = id;
            this.version = version;
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public Long getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultWithIdAndVersion that = (DefaultWithIdAndVersion)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }

        public String toString() {
            return "WithIdAndVersion{id=" + this.id + ", version=" + this.version + "}";
        }
    }
}

