/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestCoalescer;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultReindexRequestCoalescer
implements ReindexRequestCoalescer {
    @Override
    @Nonnull
    public List<ReindexRequest> coalesce(@Nonnull List<ReindexRequest> requests) {
        requests = this.normalizeRequests(requests);
        HashMultimap groupedAffectedIndexes = HashMultimap.create();
        HashMultimap groupedSharedEntityTypes = HashMultimap.create();
        ArrayListMultimap groupedRequests = ArrayListMultimap.create();
        for (ReindexRequest reindexRequest : requests) {
            ReindexRequestType type = reindexRequest.getType();
            groupedRequests.put((Object)type, (Object)reindexRequest);
            groupedAffectedIndexes.putAll((Object)type, (Iterable)reindexRequest.getAffectedIndexes());
            groupedSharedEntityTypes.putAll((Object)type, (Iterable)reindexRequest.getSharedEntities());
        }
        EnumMap<ReindexRequestType, ReindexRequest> combinedRequests = new EnumMap<ReindexRequestType, ReindexRequest>(ReindexRequestType.class);
        for (ReindexRequestType type : groupedRequests.keySet()) {
            List sourcesForType = groupedRequests.get((Object)type);
            if (sourcesForType.size() == 1) {
                combinedRequests.put(type, (ReindexRequest)sourcesForType.get(0));
                continue;
            }
            ReindexRequest combinedRequest = new ReindexRequest(null, type, this.lowestRequestTime(sourcesForType), null, null, null, this.combinedStatus(sourcesForType), groupedAffectedIndexes.get((Object)type), groupedSharedEntityTypes.get((Object)type), sourcesForType);
            combinedRequests.put(type, combinedRequest);
        }
        List<ReindexRequest> list = this.eliminateAndCombineTree(combinedRequests.values());
        return ImmutableList.copyOf(list);
    }

    private List<ReindexRequest> eliminateAndCombineTree(Collection<ReindexRequest> oneRequestPerType) {
        ArrayList<ReindexRequest> combinedRequests = new ArrayList<ReindexRequest>();
        EnumSet<AffectedIndex> affectedIndexesProcessed = EnumSet.noneOf(AffectedIndex.class);
        EnumSet<SharedEntityType> sharedEntityTypesProcessed = EnumSet.noneOf(SharedEntityType.class);
        ReindexRequest requestFromPreviousType = null;
        for (ReindexRequest request : oneRequestPerType) {
            EnumSet<AffectedIndex> usefulAffectedIndexesForRequest = DefaultReindexRequestCoalescer.safeCopyOf(request.getAffectedIndexes(), AffectedIndex.class);
            usefulAffectedIndexesForRequest.removeAll(affectedIndexesProcessed);
            EnumSet<SharedEntityType> usefulSharedEntityTypesForRequest = DefaultReindexRequestCoalescer.safeCopyOf(request.getSharedEntities(), SharedEntityType.class);
            usefulSharedEntityTypesForRequest.removeAll(sharedEntityTypesProcessed);
            if (!usefulAffectedIndexesForRequest.isEmpty() || !usefulSharedEntityTypesForRequest.isEmpty()) {
                if (request.getId() == null) {
                    ArrayList<ReindexRequest> newSources = new ArrayList<ReindexRequest>(request.getSources().size());
                    for (ReindexRequest oldSource : request.getSources()) {
                        EnumSet<AffectedIndex> usefulAffectedIndexesInOldSource = DefaultReindexRequestCoalescer.safeCopyOf(oldSource.getAffectedIndexes(), AffectedIndex.class);
                        usefulAffectedIndexesInOldSource.retainAll(usefulAffectedIndexesForRequest);
                        EnumSet<SharedEntityType> usefulSharedEntityTypesInOldSource = DefaultReindexRequestCoalescer.safeCopyOf(oldSource.getSharedEntities(), SharedEntityType.class);
                        usefulSharedEntityTypesInOldSource.retainAll(usefulSharedEntityTypesForRequest);
                        ReindexRequest newSource = new ReindexRequest(oldSource.getId(), oldSource.getType(), oldSource.getRequestTime(), oldSource.getStartTime(), oldSource.getCompletionTime(), oldSource.getExecutionNodeId(), oldSource.getStatus(), usefulAffectedIndexesInOldSource, usefulSharedEntityTypesInOldSource, oldSource.getSources());
                        newSources.add(newSource);
                    }
                    request = new ReindexRequest(null, request.getType(), request.getRequestTime(), request.getStartTime(), request.getCompletionTime(), request.getExecutionNodeId(), request.getStatus(), usefulAffectedIndexesForRequest, usefulSharedEntityTypesForRequest, newSources);
                } else if (!(request.getSources().isEmpty() && usefulAffectedIndexesForRequest.equals(request.getAffectedIndexes()) && usefulSharedEntityTypesForRequest.equals(request.getSharedEntities()))) {
                    request = new ReindexRequest(request.getId(), request.getType(), request.getRequestTime(), request.getStartTime(), request.getCompletionTime(), request.getExecutionNodeId(), request.getStatus(), usefulAffectedIndexesForRequest, usefulSharedEntityTypesForRequest, request.getSources());
                }
                combinedRequests.add(request);
                requestFromPreviousType = request;
            } else {
                List<ReindexRequest> sources = request.getSources();
                if (sources.isEmpty()) {
                    sources = Collections.singletonList(request);
                }
                if (requestFromPreviousType.getId() != null) {
                    ImmutableList newSources = ImmutableList.builder().add(requestFromPreviousType).addAll(sources).build();
                    ReindexRequest updatedRequestFromPreviousType = new ReindexRequest(null, requestFromPreviousType.getType(), requestFromPreviousType.getRequestTime(), requestFromPreviousType.getStartTime(), requestFromPreviousType.getCompletionTime(), requestFromPreviousType.getExecutionNodeId(), requestFromPreviousType.getStatus(), requestFromPreviousType.getAffectedIndexes(), requestFromPreviousType.getSharedEntities(), (List)newSources);
                    combinedRequests.set(combinedRequests.indexOf(requestFromPreviousType), updatedRequestFromPreviousType);
                } else {
                    combinedRequests.set(combinedRequests.indexOf(requestFromPreviousType), requestFromPreviousType.withSources(sources));
                }
            }
            affectedIndexesProcessed.addAll(usefulAffectedIndexesForRequest);
            sharedEntityTypesProcessed.addAll(usefulSharedEntityTypesForRequest);
        }
        return combinedRequests;
    }

    @Nonnull
    private static <E extends Enum<E>> EnumSet<E> safeCopyOf(@Nonnull Set<E> set, @Nonnull Class<E> type) {
        if (set instanceof EnumSet) {
            return EnumSet.copyOf((EnumSet)set);
        }
        if (set.isEmpty()) {
            return EnumSet.noneOf(type);
        }
        return EnumSet.copyOf(set);
    }

    private long lowestRequestTime(@Nonnull Iterable<ReindexRequest> requests) {
        long time = Long.MAX_VALUE;
        for (ReindexRequest request : requests) {
            time = Math.min(time, request.getRequestTime());
        }
        return time;
    }

    @Nonnull
    private ReindexStatus combinedStatus(@Nonnull Iterable<ReindexRequest> requests) {
        ReindexStatus combinedStatus = ReindexStatus.values()[ReindexStatus.values().length - 1];
        for (ReindexRequest request : requests) {
            ReindexStatus curStatus = request.getStatus();
            if (curStatus.compareTo((Enum)combinedStatus) >= 0) continue;
            combinedStatus = curStatus;
        }
        return combinedStatus;
    }

    @Nonnull
    private List<ReindexRequest> normalizeRequests(@Nonnull List<ReindexRequest> requests) {
        ArrayList<ReindexRequest> requestList = new ArrayList<ReindexRequest>(requests.size());
        for (ReindexRequest request : requests) {
            requestList.add(this.normalizeRequest(request));
        }
        return requestList;
    }

    @Nonnull
    private ReindexRequest normalizeRequest(@Nonnull ReindexRequest request) {
        Set<SharedEntityType> sharedEntityTypes = this.normalizeSharedEntityTypes(request.getSharedEntities());
        Set<AffectedIndex> affectedIndexes = this.normalizeAffectedIndexes(request.getAffectedIndexes(), sharedEntityTypes);
        return new ReindexRequest(request.getId(), request.getType(), request.getRequestTime(), request.getStartTime(), request.getCompletionTime(), request.getExecutionNodeId(), request.getStatus(), affectedIndexes, sharedEntityTypes, request.getSources());
    }

    @Nonnull
    private Set<AffectedIndex> normalizeAffectedIndexes(@Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntityTypes) {
        affectedIndexes = affectedIndexes.contains(AffectedIndex.ALL) ? EnumSet.complementOf(EnumSet.of(AffectedIndex.ALL)) : (!affectedIndexes.isEmpty() ? EnumSet.copyOf(affectedIndexes) : EnumSet.noneOf(AffectedIndex.class));
        if (sharedEntityTypes.isEmpty()) {
            affectedIndexes.remove(AffectedIndex.SHAREDENTITY);
        } else {
            affectedIndexes.add(AffectedIndex.SHAREDENTITY);
        }
        return affectedIndexes;
    }

    @Nonnull
    private Set<SharedEntityType> normalizeSharedEntityTypes(@Nonnull Set<SharedEntityType> sharedEntityTypes) {
        if (sharedEntityTypes.contains(SharedEntityType.NONE)) {
            return EnumSet.noneOf(SharedEntityType.class);
        }
        return sharedEntityTypes;
    }
}

