/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.config.BackgroundIndexTaskContext;
import com.atlassian.jira.config.ForegroundIndexTaskContext;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexComponent;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestBase;
import com.atlassian.jira.index.request.ReindexRequestCoalescer;
import com.atlassian.jira.index.request.ReindexRequestDao;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.index.request.TaskDescriptorHelper;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.action.admin.index.ReIndexAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.ReIndexBackgroundIndexerCommand;
import com.atlassian.johnson.JohnsonEventContainer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class DefaultReindexRequestManager
implements ReindexRequestManager {
    private static final Logger log = Logger.getLogger(DefaultReindexRequestManager.class);
    private static final String PROCESS_REQUESTS_LOCK = DefaultReindexRequestManager.class.getName() + ".processRequests";
    private final ReindexRequestDao reindexRequestDao;
    private final Clock clock;
    private final ReindexRequestCoalescer requestCoalescer;
    private final ClusterManager clusterManager;
    private final ClusterLockService clusterLockService;
    private final TaskManager taskManager;
    private final TaskDescriptorHelper taskDescriptorHelper;
    private final IndexLifecycleManager indexLifecycleManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final I18nHelper i18nHelper;
    private final JohnsonProvider johnsonProvider;

    public DefaultReindexRequestManager(ReindexRequestDao reindexRequestDao, Clock clock, ReindexRequestCoalescer requestCoalescer, ClusterManager clusterManager, ClusterLockService clusterLockService, TaskManager taskManager, IndexLifecycleManager indexLifecycleManager, I18nHelper.BeanFactory i18nFactory, I18nHelper i18nHelper, JohnsonProvider johnsonProvider) {
        this.reindexRequestDao = reindexRequestDao;
        this.clock = clock;
        this.requestCoalescer = requestCoalescer;
        this.clusterManager = clusterManager;
        this.clusterLockService = clusterLockService;
        this.taskManager = taskManager;
        this.indexLifecycleManager = indexLifecycleManager;
        this.i18nFactory = i18nFactory;
        this.i18nHelper = i18nHelper;
        this.johnsonProvider = johnsonProvider;
        this.taskDescriptorHelper = new TaskDescriptorHelper(taskManager);
    }

    private ReindexRequest readFullRequest(ReindexRequestBase baseRequest) {
        List<ReindexComponent> components = this.reindexRequestDao.getComponentsForRequest(baseRequest.getId());
        EnumSet<AffectedIndex> affectedIndexes = EnumSet.noneOf(AffectedIndex.class);
        EnumSet<SharedEntityType> entityTypes = EnumSet.noneOf(SharedEntityType.class);
        for (ReindexComponent component : components) {
            if (component.getAffectedIndex() == AffectedIndex.SHAREDENTITY) {
                entityTypes.add(component.getEntityType());
            }
            affectedIndexes.add(component.getAffectedIndex());
        }
        return new ReindexRequest(baseRequest, affectedIndexes, entityTypes);
    }

    public boolean isReindexRequested() {
        return this.isReindexRequested(EnumSet.allOf(ReindexRequestType.class));
    }

    public boolean isReindexRequested(Set<ReindexRequestType> reindexRequestTypes) {
        return this.getPendingReindexRequests(reindexRequestTypes).iterator().hasNext();
    }

    @Nonnull
    public Iterable<ReindexRequest> getPendingReindexRequests(@Nonnull Set<ReindexRequestType> reindexRequestTypes) {
        return this.readPendingReindexRequests(reindexRequestTypes, false);
    }

    @Nonnull
    public Iterable<ReindexRequest> readPendingReindexRequests(@Nonnull Set<ReindexRequestType> reindexRequestTypes, boolean updateCoalescedRequests) {
        List<ReindexRequestBase> baseRequests = this.reindexRequestDao.getRequestsWithStatus(ReindexStatus.PENDING);
        ImmutableList.Builder requestListBuilder = ImmutableList.builder();
        for (ReindexRequestBase baseRequest : baseRequests) {
            ReindexRequest fullRequest = this.readFullRequest(baseRequest);
            requestListBuilder.add((Object)fullRequest);
        }
        ImmutableList requests = requestListBuilder.build();
        List<ReindexRequest> coalescedRequests = this.requestCoalescer.coalesce((List<ReindexRequest>)requests);
        if (updateCoalescedRequests) {
            HashMap coalescedRequestsById = new HashMap();
            this.buildRequestMap(coalescedRequests, coalescedRequestsById);
            for (ReindexRequest originalRequest : requests) {
                ReindexRequest requestAfterCoalesce = (ReindexRequest)coalescedRequestsById.get(originalRequest.getId());
                if (originalRequest.getAffectedIndexes().equals(requestAfterCoalesce.getAffectedIndexes()) && originalRequest.getSharedEntities().equals(requestAfterCoalesce.getSharedEntities())) continue;
                this.reindexRequestDao.removeComponents(requestAfterCoalesce.getId());
                for (AffectedIndex affectedIndex : requestAfterCoalesce.getAffectedIndexes()) {
                    this.reindexRequestDao.writeComponent(new ReindexComponent(null, requestAfterCoalesce.getId(), affectedIndex, SharedEntityType.NONE));
                }
                for (SharedEntityType entityType : requestAfterCoalesce.getSharedEntities()) {
                    this.reindexRequestDao.writeComponent(new ReindexComponent(null, requestAfterCoalesce.getId(), AffectedIndex.SHAREDENTITY, entityType));
                }
            }
        }
        return Iterables.filter(coalescedRequests, input -> reindexRequestTypes.contains(input.getType()));
    }

    private void buildRequestMap(Iterable<ReindexRequest> requests, Map<? super Long, ? super ReindexRequest> requestMap) {
        for (ReindexRequest request : requests) {
            if (request.getId() != null) {
                requestMap.put(request.getId(), (ReindexRequest)request);
            }
            this.buildRequestMap(request.getSources(), requestMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReindexRequest> processPendingRequests(boolean waitForCompletion, Set<ReindexRequestType> reindexRequestTypes, boolean runInBackground) {
        Iterable<ReindexRequest> requests;
        ClusterLock lock = this.clusterLockService.getLockForName(PROCESS_REQUESTS_LOCK);
        lock.lock();
        try {
            if (this.isReindexInProgress()) {
                throw new IllegalStateException("Indexing already in progress.");
            }
            requests = this.readPendingReindexRequests(reindexRequestTypes, true);
            requests = this.transitionStatus(requests, ReindexStatus.ACTIVE);
        }
        finally {
            lock.unlock();
        }
        try {
            requests = this.performReindex(requests, waitForCompletion, runInBackground);
        }
        catch (Throwable e) {
            log.error((Object)("Error occured performing reindex: " + e), e);
            requests = this.transitionStatus(requests, ReindexStatus.FAILED);
            Throwables.propagate((Throwable)e);
        }
        return ImmutableSet.copyOf(requests);
    }

    @Nonnull
    private List<ReindexRequest> performReindex(@Nonnull Iterable<ReindexRequest> requests, boolean waitForCompletion, boolean runInBackground) throws InterruptedException {
        ArrayList<ReindexRequest> resultList = new ArrayList<ReindexRequest>();
        for (ReindexRequest request : requests) {
            resultList.add(this.performReindex(request, waitForCompletion, runInBackground));
        }
        return resultList;
    }

    @Nonnull
    @VisibleForTesting
    protected ReindexRequest performReindex(@Nonnull ReindexRequest request, boolean waitForCompletion, boolean runInBackground) throws InterruptedException {
        return this.reindex(request, waitForCompletion, runInBackground);
    }

    private ReindexRequest reindex(ReindexRequest request, boolean waitForTaskCompletion, boolean runInBackground) throws InterruptedException {
        TaskDescriptor<IndexCommandResult> task = this.taskDescriptorHelper.getActiveIndexTask();
        if (task != null) {
            log.warn((Object)"Indexing task already in progress, waiting for current task to complete.");
            try {
                this.taskDescriptorHelper.waitForTaskCompletion(task);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        task = runInBackground ? this.triggerBackgroundIndexing(request) : this.triggerForegroundIndexing(request);
        if (waitForTaskCompletion) {
            try {
                this.taskDescriptorHelper.waitForTaskCompletion(task);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getReindexProgress(request);
    }

    private TaskDescriptor<IndexCommandResult> triggerBackgroundIndexing(ReindexRequest request) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setChangeHistory(request.getAffectedIndexes().contains(AffectedIndex.CHANGEHISTORY)).setComments(request.getAffectedIndexes().contains(AffectedIndex.COMMENT)).setIssues(request.getAffectedIndexes().contains(AffectedIndex.ISSUE)).setWorklogs(request.getAffectedIndexes().contains(AffectedIndex.WORKLOG)).build();
        return this.submitIndexingTask(new ReIndexBackgroundIndexerCommand(this.indexLifecycleManager, issueIndexingParams, log, this.i18nHelper, this.i18nFactory), new BackgroundIndexTaskContext(), true, request);
    }

    private TaskDescriptor<IndexCommandResult> triggerForegroundIndexing(ReindexRequest request) {
        return this.submitIndexingTask(new ReIndexAsyncIndexerCommand(this.getJohnsonEventContainer(), this.indexLifecycleManager, log, this.i18nHelper, this.i18nFactory), new ForegroundIndexTaskContext(), false, request);
    }

    private <T extends Callable<IndexCommandResult> & ProvidesTaskProgress> TaskDescriptor<IndexCommandResult> submitIndexingTask(T cmd, IndexTaskContext indexTaskContext, boolean cancellable, ReindexRequest request) {
        return this.taskManager.submitTask(new RunReindexAndUpdateRequestTask(this, cmd, request), this.i18nHelper.getText("admin.indexing.jira.indexing"), indexTaskContext, cancellable);
    }

    private JohnsonEventContainer getJohnsonEventContainer() {
        return this.johnsonProvider.getContainer();
    }

    private List<ReindexRequestBase> getActiveOrRunningRequests() {
        ArrayList<ReindexRequestBase> requestsToCheck = new ArrayList<ReindexRequestBase>();
        requestsToCheck.addAll(this.reindexRequestDao.getRequestsWithStatus(ReindexStatus.RUNNING));
        requestsToCheck.addAll(this.reindexRequestDao.getRequestsWithStatus(ReindexStatus.ACTIVE));
        return requestsToCheck;
    }

    @Nonnull
    public List<ReindexRequest> failRunningRequestsFromDeadNodes() {
        if (!this.clusterManager.isClustered()) {
            return Collections.emptyList();
        }
        List<ReindexRequestBase> requestsToCheck = this.getActiveOrRunningRequests();
        if (requestsToCheck.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> liveNodeIds = new HashSet<String>();
        for (Node liveNode : this.clusterManager.findLiveNodes()) {
            liveNodeIds.add(liveNode.getNodeId());
        }
        ArrayList<ReindexRequest> requestsFromDeadNodes = new ArrayList<ReindexRequest>();
        for (ReindexRequestBase request : requestsToCheck) {
            String executionNodeId = request.getExecutionNodeId();
            if (liveNodeIds.contains(executionNodeId)) continue;
            log.warn((Object)("Detected active reindex request " + request.getId() + " on inactive node " + executionNodeId + ", marking as failed.  This reindex task should be re-run."));
            requestsFromDeadNodes.add(this.readFullRequest(request));
        }
        if (!requestsFromDeadNodes.isEmpty()) {
            return this.transitionStatus(requestsFromDeadNodes, ReindexStatus.FAILED);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<ReindexRequest> failRunningRequestsFromNode(@Nullable String nodeId) {
        List<ReindexRequestBase> requestsToCheck = this.getActiveOrRunningRequests();
        if (requestsToCheck.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReindexRequest> requestsFromDeadNodes = new ArrayList<ReindexRequest>();
        for (ReindexRequestBase request : requestsToCheck) {
            String executionNodeId = request.getExecutionNodeId();
            if (!Objects.equal((Object)nodeId, (Object)executionNodeId)) continue;
            log.warn((Object)("Detected active reindex request " + request.getId() + " on node " + executionNodeId + ", marking as failed.  This reindex task should be re-run."));
            requestsFromDeadNodes.add(this.readFullRequest(request));
        }
        if (!requestsFromDeadNodes.isEmpty()) {
            return this.transitionStatus(requestsFromDeadNodes, ReindexStatus.FAILED);
        }
        return Collections.emptyList();
    }

    public boolean isReindexInProgress() {
        this.failRunningRequestsFromDeadNodes();
        return !this.reindexRequestDao.getRequestsWithStatus(ReindexStatus.RUNNING).isEmpty() || !this.reindexRequestDao.getRequestsWithStatus(ReindexStatus.ACTIVE).isEmpty();
    }

    @Nonnull
    public ReindexRequest requestReindex(@Nonnull ReindexRequestType type, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> entityTypes) {
        long requestTime = this.clock.millis();
        ReindexRequestBase request = new ReindexRequestBase(null, type, requestTime, null, null, null, ReindexStatus.PENDING);
        request = this.reindexRequestDao.writeRequest(request);
        long requestId = request.getId();
        for (AffectedIndex affectedIndex : affectedIndexes) {
            this.reindexRequestDao.writeComponent(new ReindexComponent(null, requestId, affectedIndex, SharedEntityType.NONE));
        }
        for (SharedEntityType entityType : entityTypes) {
            this.reindexRequestDao.writeComponent(new ReindexComponent(null, requestId, AffectedIndex.SHAREDENTITY, entityType));
        }
        ReindexRequest fullRequest = new ReindexRequest(request, affectedIndexes, entityTypes);
        return fullRequest;
    }

    @Nonnull
    private ReindexRequest transitionStatus(@Nonnull ReindexRequest request, @Nonnull ReindexStatus newStatus, long transitionTime) {
        Long completionTime;
        Long startTime = request.getStartTime();
        String nodeId = null;
        switch (newStatus) {
            case COMPLETE: {
                completionTime = transitionTime;
                break;
            }
            case ACTIVE: {
                startTime = transitionTime;
                completionTime = null;
                nodeId = this.clusterManager.getNodeId();
                break;
            }
            case RUNNING: {
                startTime = transitionTime;
                completionTime = null;
                nodeId = this.clusterManager.getNodeId();
                break;
            }
            case FAILED: {
                completionTime = transitionTime;
                break;
            }
            case PENDING: {
                startTime = null;
                completionTime = null;
                break;
            }
            default: {
                throw new Error("Unsupported status: " + newStatus);
            }
        }
        ImmutableList.Builder sourceReplacementBuilder = ImmutableList.builder();
        for (ReindexRequest sourceRequest : request.getSources()) {
            ReindexRequest replacementRequest = this.transitionStatus(sourceRequest, newStatus, transitionTime);
            sourceReplacementBuilder.add((Object)replacementRequest);
        }
        if ((request = new ReindexRequest(request.getId(), request.getType(), request.getRequestTime(), startTime, completionTime, nodeId, newStatus, request.getAffectedIndexes(), request.getSharedEntities(), (List)sourceReplacementBuilder.build())).getId() != null) {
            this.reindexRequestDao.writeRequest((ReindexRequestBase)request);
        }
        return request;
    }

    @Nonnull
    public List<ReindexRequest> transitionStatus(@Nonnull Iterable<ReindexRequest> requests, @Nonnull ReindexStatus newStatus) {
        long transitionTime = this.clock.millis();
        ImmutableList.Builder transitionedRequestBuilder = ImmutableList.builder();
        for (ReindexRequest request : requests) {
            transitionedRequestBuilder.add((Object)this.transitionStatus(request, newStatus, transitionTime));
        }
        return transitionedRequestBuilder.build();
    }

    @Nonnull
    public ReindexRequest transitionStatus(@Nonnull ReindexRequest request, @Nonnull ReindexStatus newStatus) {
        return this.transitionStatus((Iterable<ReindexRequest>)ImmutableList.of((Object)request), newStatus).get(0);
    }

    @Nonnull
    public Set<ReindexRequest> getReindexProgress(@Nonnull Set<Long> requestIds) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (long requestId : requestIds) {
            ReindexRequest request = this.getReindexProgress(requestId);
            if (request == null) continue;
            builder.add((Object)request);
        }
        return builder.build();
    }

    public void clearAll() {
        this.reindexRequestDao.removeAllPendingRequests();
    }

    private ReindexRequest getReindexProgress(ReindexRequest request) {
        if (request.getId() != null) {
            return this.getReindexProgress(request.getId());
        }
        long earliestStartTime = Long.MAX_VALUE;
        long latestCompletionTime = Long.MIN_VALUE;
        String executionNodeId = null;
        ReindexStatus status = ReindexStatus.COMPLETE;
        ArrayList<ReindexRequest> newSources = new ArrayList<ReindexRequest>();
        for (ReindexRequest source : request.getSources()) {
            newSources.add(this.getReindexProgress(source));
            if (source.getStartTime() != null) {
                earliestStartTime = Math.min(earliestStartTime, source.getStartTime());
            }
            if (source.getCompletionTime() != null) {
                latestCompletionTime = Math.max(latestCompletionTime, source.getCompletionTime());
            }
            if (source.getExecutionNodeId() != null) {
                executionNodeId = source.getExecutionNodeId();
            }
            if (source.getStatus() == ReindexStatus.FAILED) {
                status = ReindexStatus.FAILED;
                continue;
            }
            if (source.getStatus() == ReindexStatus.RUNNING && status != ReindexStatus.FAILED) {
                status = ReindexStatus.RUNNING;
                continue;
            }
            if (source.getStatus() == ReindexStatus.ACTIVE && status != ReindexStatus.FAILED && status != ReindexStatus.RUNNING) {
                status = ReindexStatus.ACTIVE;
                continue;
            }
            if (source.getStatus() != ReindexStatus.PENDING || status == ReindexStatus.FAILED || status == ReindexStatus.RUNNING || status == ReindexStatus.PENDING) continue;
            status = ReindexStatus.PENDING;
        }
        Long actualStartTime = earliestStartTime == Long.MAX_VALUE ? null : Long.valueOf(earliestStartTime);
        Long actualCompletionTime = latestCompletionTime == Long.MIN_VALUE ? null : Long.valueOf(latestCompletionTime);
        ReindexRequest updated = new ReindexRequest(request.getId(), request.getType(), request.getRequestTime(), actualStartTime, actualCompletionTime, executionNodeId, status, request.getAffectedIndexes(), request.getSharedEntities(), newSources);
        return updated;
    }

    public ReindexRequest getReindexProgress(@Nonnull Long requestId) {
        ReindexRequestBase foundBase = this.reindexRequestDao.findRequestById(requestId);
        if (foundBase != null) {
            return this.readFullRequest(foundBase);
        }
        return null;
    }

    private static class RunReindexAndUpdateRequestTask<T extends Callable<IndexCommandResult> & ProvidesTaskProgress>
    implements Callable<IndexCommandResult>,
    ProvidesTaskProgress {
        private ReindexRequest request;
        private final T wrappedTask;
        final /* synthetic */ DefaultReindexRequestManager this$0;

        public RunReindexAndUpdateRequestTask(T wrappedTask, ReindexRequest request) {
            this.this$0 = var1_1;
            this.wrappedTask = wrappedTask;
            this.request = request;
        }

        @Override
        public IndexCommandResult call() throws Exception {
            IndexCommandResult result;
            this.request = this.this$0.transitionStatus(this.request, ReindexStatus.RUNNING);
            try {
                result = (IndexCommandResult)this.wrappedTask.call();
                if (result.isSuccessful()) {
                    this.request = this.this$0.transitionStatus(this.request, ReindexStatus.COMPLETE);
                } else {
                    log.error((Object)("Reindex failed: " + result.getErrorCollection().getErrorMessages()));
                    this.request = this.this$0.transitionStatus(this.request, ReindexStatus.FAILED);
                }
            }
            catch (Exception e) {
                log.error((Object)("Reindex failed: " + e), (Throwable)e);
                this.request = this.this$0.transitionStatus(this.request, ReindexStatus.FAILED);
                throw e;
            }
            return result;
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            ((ProvidesTaskProgress)this.wrappedTask).setTaskProgressSink(taskProgressSink);
        }
    }
}

