/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.io;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.SessionTempFileImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterSafe(value="Only because we have session affinity")
class SessionTempFiles
implements HttpSessionBindingListener,
Serializable {
    @VisibleForTesting
    static final String SESSION_ATTRIBUTE_NAME = "jira.SessionTempFiles";
    private static final Logger LOG = LoggerFactory.getLogger(SessionTempFiles.class);
    private final String sessionId;
    private final ConcurrentLinkedQueue<SessionTempFile> tempFiles = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static SessionTempFiles forSession(@Nonnull HttpSession session) {
        SessionTempFiles tempFiles = (SessionTempFiles)session.getAttribute(SESSION_ATTRIBUTE_NAME);
        if (tempFiles == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                tempFiles = (SessionTempFiles)session.getAttribute(SESSION_ATTRIBUTE_NAME);
                if (tempFiles == null) {
                    tempFiles = new SessionTempFiles(session);
                    session.setAttribute(SESSION_ATTRIBUTE_NAME, (Object)tempFiles);
                }
            }
        }
        return tempFiles;
    }

    @VisibleForTesting
    SessionTempFiles(@Nonnull HttpSession session) {
        Assertions.notNull((String)"session", (Object)session);
        this.sessionId = (String)Assertions.notNull((String)"sessionId", (Object)session.getId());
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        try {
            this.deleteAllSessionTempFiles();
        }
        catch (RuntimeException e) {
            LOG.error("Error deleting session temp files for session '" + this.sessionId + "'", (Throwable)e);
        }
    }

    String getSessionId() {
        return this.sessionId;
    }

    SessionTempFile createTempFile(File file) {
        SessionTempFileImpl sessionTempFile = new SessionTempFileImpl(this, file);
        this.tempFiles.add(sessionTempFile);
        return sessionTempFile;
    }

    @Nullable
    SessionTempFile getTempFile(File file) {
        for (SessionTempFile tempFile : this.tempFiles) {
            if (!tempFile.getFile().equals(file)) continue;
            return tempFile;
        }
        return null;
    }

    void remove(SessionTempFile sessionTempFile) {
        this.tempFiles.remove(sessionTempFile);
    }

    private void deleteAllSessionTempFiles() {
        Iterator<SessionTempFile> iter = this.tempFiles.iterator();
        while (iter.hasNext()) {
            SessionTempFile tempFile = iter.next();
            iter.remove();
            File file = tempFile.getFile();
            if (file.delete() || !file.exists()) continue;
            LOG.warn("Failed to delete {}. Marking this file for deletion with File.deleteOnExit()...", (Object)tempFile);
            file.deleteOnExit();
        }
    }
}

