/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;

public class OneMinuteAverageCalculator {
    private static final long ONE_MINUTE_IN_SECONDS = 60L;
    private final Clock clock;
    private final AtomicReference<Instant> lastReset = new AtomicReference<Object>(null);

    public OneMinuteAverageCalculator(Clock clock) {
        this.clock = clock;
        this.lastReset.set(clock.instant());
    }

    @VisibleForTesting
    OneMinuteAverageCalculator(Clock clock, Instant initLastReset) {
        this.clock = clock;
        this.lastReset.set(initLastReset);
    }

    public long getOneMinuteAverageAndReset(long value) {
        Instant now = this.clock.instant();
        Instant snapshotLastReset = this.lastReset.getAndSet(now);
        long diffInSeconds = now.getEpochSecond() - snapshotLastReset.getEpochSecond();
        if (diffInSeconds == 0L) {
            return 0L;
        }
        return (long)((double)value * (60.0 / (double)diffInSeconds));
    }
}

