/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.http;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.ipd.InProductDiagnosticUtils;
import com.atlassian.jira.ipd.exception.UnableReadAttributeException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionPoolService {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectionPoolService.class);
    private static final String SOURCE_METRIC_HTTP_NUM_MAX = "maxThreads";
    private static final String SOURCE_METRIC_HTTP_NUM_ACTIVE = "currentThreadsBusy";
    private static final String SOURCE_METRIC_HTTP_NUM_CURRENT = "currentThreadCount";
    private static final String[] ATTRIBUTE_LIST = new String[]{"maxThreads", "currentThreadsBusy", "currentThreadCount"};
    private static final String SOURCE_MBEAN = "Catalina:type=ThreadPool,*";
    private final MBeanServer platformMBeanServer;

    public HttpConnectionPoolService() {
        this(InProductDiagnosticUtils.getPlatformMBeanServer());
    }

    @VisibleForTesting
    HttpConnectionPoolService(MBeanServer platformMBeanServer) {
        this.platformMBeanServer = platformMBeanServer;
    }

    public HttpMetric getHttpPoolSizeValue() {
        Set<ObjectName> threadPoolBeans = this.findTomcatThreadPoolBeans();
        int numMax = 0;
        int numActive = 0;
        int numCurrent = 0;
        for (ObjectName threadPoolName : threadPoolBeans) {
            try {
                numMax += ((Integer)this.platformMBeanServer.getAttribute(threadPoolName, SOURCE_METRIC_HTTP_NUM_MAX)).intValue();
                numActive += ((Integer)this.platformMBeanServer.getAttribute(threadPoolName, SOURCE_METRIC_HTTP_NUM_ACTIVE)).intValue();
                numCurrent += ((Integer)this.platformMBeanServer.getAttribute(threadPoolName, SOURCE_METRIC_HTTP_NUM_CURRENT)).intValue();
            }
            catch (Exception ex) {
                log.warn("Unable to read attribute", (Throwable)ex);
            }
        }
        return new HttpMetric(numMax, numCurrent, numActive);
    }

    private Set<ObjectName> findTomcatThreadPoolBeans() {
        ObjectName objectName;
        try {
            objectName = new ObjectName(SOURCE_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            throw new UnableReadAttributeException(e, new String[0]);
        }
        return this.platformMBeanServer.queryNames(objectName, null).stream().filter(this::hasExpectedAttributes).collect(Collectors.toSet());
    }

    private boolean hasExpectedAttributes(ObjectName objectName) {
        try {
            return this.platformMBeanServer.getAttributes(objectName, ATTRIBUTE_LIST).size() == ATTRIBUTE_LIST.length;
        }
        catch (Exception ex) {
            log.debug(String.format("Couldn't find expected ThreadPool attributes in MBean: %s", objectName.getCanonicalName()), (Throwable)ex);
            return false;
        }
    }

    public static class HttpMetric {
        private final int numIdle;
        private final int numActive;
        private final int numMax;

        public HttpMetric(int numMax, int numCurrent, int numActive) {
            this.numIdle = Math.subtractExact(numCurrent, numActive);
            this.numActive = numActive;
            this.numMax = numMax;
        }

        public int getNumIdle() {
            return this.numIdle;
        }

        public int getNumActive() {
            return this.numActive;
        }

        public int getNumMax() {
            return this.numMax;
        }
    }
}

