/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.http;

import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ipd.IpdExecutors;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.web.filters.accesslog.AccessLogRequestInfo;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestsInProductDiagnosticJobScheduler
implements Startable {
    private static final Logger regularLogger = LoggerFactory.getLogger((String)"ipd-monitoring");
    private static final int INTERVAL_SECONDS = 60;
    private static final int TIMEOUT_SECONDS = 60;
    private static final int INITIAL_DELAY_SECONDS = 0;
    private static final String IPD_HTTP_REQUESTS_COUNTER_THREAD_WORKER = "ipd_http_requests_counter_worker";
    private static final String LOG_LABEL = "IPDHTTPREQUESTSCOUNTER";
    private final ScheduledExecutorService scheduledExecutorService;
    private long previousRequestsCount;
    private long requestsCountPerMinute;

    public HttpRequestsInProductDiagnosticJobScheduler(IpdExecutors ipdExecutors) {
        this.scheduledExecutorService = ipdExecutors.createSingleThreadScheduledExecutorService(IPD_HTTP_REQUESTS_COUNTER_THREAD_WORKER);
        this.previousRequestsCount = 0L;
    }

    public void start() throws Exception {
        regularLogger.info("Scheduling {} with poll interval of {} seconds", (Object)LOG_LABEL, (Object)60);
        this.scheduledExecutorService.scheduleAtFixedRate(JiraThreadLocalUtils.wrap(this::countRequestsPerMinute), 0L, 60L, TimeUnit.SECONDS);
    }

    public void countRequestsPerMinute() {
        long totalRequestsCount = AccessLogRequestInfo.requestCounter.get();
        this.requestsCountPerMinute = totalRequestsCount - this.previousRequestsCount;
        this.previousRequestsCount = totalRequestsCount;
    }

    public long getRequestsCountPerMinute() {
        return this.requestsCountPerMinute;
    }
}

