/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.mail;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCustomMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.ipd.IpdExecutors;
import com.atlassian.jira.ipd.mail.ConnectionVerifier;
import com.atlassian.jira.ipd.mail.DefaultIncomingConnectionVerifier;
import com.atlassian.jira.ipd.metric.type.IpdConnectionStateType;
import com.atlassian.mail.server.IncomingMailServer;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricTag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingMailServerConnectionIpdJob
implements IpdJob {
    private static final Logger LOG = LoggerFactory.getLogger(IncomingMailServerConnectionIpdJob.class);
    private final IpdMetricRegistry registry;
    private final ExecutorService executorService;
    private final ConnectionVerifier connectionVerifier;
    private Set<MetricKey> lastMailMetrics = new HashSet<MetricKey>();
    private final MailServerManager mailServerManager;

    public IncomingMailServerConnectionIpdJob(IpdJobRunner ipdJobRunner, IpdMainRegistry ipdMainRegistry, MailServerManager mailServerManager, IpdExecutors ipdExecutors) {
        this(ipdJobRunner, (IpdMetricRegistry)Objects.requireNonNull(ipdMainRegistry), ipdExecutors.createSingleTaskExecutorService("ipd-incoming-mail"), new DefaultIncomingConnectionVerifier(), mailServerManager);
    }

    @VisibleForTesting
    IncomingMailServerConnectionIpdJob(IpdJobRunner ipdJobRunner, IpdMetricRegistry ipdMetricRegistry, ExecutorService executorService, ConnectionVerifier connectionVerifier, MailServerManager mailServerManager) {
        this.connectionVerifier = connectionVerifier;
        ipdJobRunner.register((IpdJob)this);
        this.registry = ipdMetricRegistry;
        this.executorService = executorService;
        this.mailServerManager = mailServerManager;
    }

    public void runJob() {
        if (this.mailServerManager.getIncomingMailServers().isEmpty()) {
            this.removeObsoleteMetrics(this.mailServerManager.getIncomingMailServers());
            return;
        }
        try {
            this.executorService.execute(this::measureIncomingMailServerConnectivity);
        }
        catch (RejectedExecutionException ex) {
            LOG.debug("Unable to instantiate new process to check mail server connections, previous process is still running", (Throwable)ex);
        }
    }

    @VisibleForTesting
    void measureIncomingMailServerConnectivity() {
        List mailServers = this.mailServerManager.getIncomingMailServers();
        this.removeObsoleteMetrics(mailServers);
        this.generateMetrics(mailServers);
    }

    private void removeObsoleteMetrics(List<IncomingMailServer> mailServers) {
        Set currentMetricKeys = mailServers.stream().map(IncomingMailServerConnectionIpdJob::getBaseMetricKey).collect(Collectors.toSet());
        this.lastMailMetrics.stream().filter(lastKey -> !currentMetricKeys.contains(lastKey)).forEach(baseMetricKey -> this.registry.remove(this.getMetric((MetricKey)baseMetricKey).getMetricKey()));
        this.lastMailMetrics = currentMetricKeys;
    }

    private void generateMetrics(List<IncomingMailServer> mailServers) {
        mailServers.parallelStream().forEach(server -> {
            IpdCustomMetric<IpdConnectionStateType> metric = this.getMetric((IncomingMailServer)server);
            try {
                this.connectionVerifier.verifyConnection((MailServer)server);
                metric.update(m -> m.setConnected(true));
            }
            catch (Exception e) {
                metric.update(m -> m.setConnected(false));
                LOG.debug("IPD metric '" + metric.getMetricKey() + "' failed", (Throwable)e);
            }
        });
    }

    private static MetricKey getBaseMetricKey(IncomingMailServer mailServer) {
        return MetricKey.metricKey((String)"mail.incoming.connection.state", (MetricTag.RequiredMetricTag[])new MetricTag.RequiredMetricTag[]{MetricTag.of((String)"serverName", (String)mailServer.getName())});
    }

    private IpdCustomMetric<IpdConnectionStateType> getMetric(IncomingMailServer mailServer) {
        MetricKey key = IncomingMailServerConnectionIpdJob.getBaseMetricKey(mailServer);
        return this.getMetric(key);
    }

    private IpdCustomMetric<IpdConnectionStateType> getMetric(MetricKey key) {
        return this.registry.customMetric(key.getMetricName(), IpdConnectionStateType.class, key.getTags().toArray(new MetricTag.RequiredMetricTag[0]));
    }
}

