/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.mail;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCustomMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.ipd.mail.ConnectionVerifier;
import com.atlassian.jira.ipd.mail.DefaultSmtpConnectionVerifier;
import com.atlassian.jira.ipd.metric.type.IpdConnectionStateType;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.util.profiling.MetricTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingMailServerConnectionIpdJob
implements IpdJob {
    private static final Logger LOG = LoggerFactory.getLogger(OutgoingMailServerConnectionIpdJob.class);
    private final MailServerManager mailServerManager;
    private final ConnectionVerifier connectionVerifier;
    private final IpdMetricRegistry ipdMetricRegistry;
    private IpdCustomMetric<IpdConnectionStateType> smtpConnectionStateMetric;

    public OutgoingMailServerConnectionIpdJob(IpdJobRunner ipdJobRunner, IpdMainRegistry ipdMainRegistry, MailServerManager mailServerManager) {
        this(ipdJobRunner, (IpdMetricRegistry)ipdMainRegistry, mailServerManager, new DefaultSmtpConnectionVerifier());
    }

    @VisibleForTesting
    OutgoingMailServerConnectionIpdJob(IpdJobRunner ipdJobRunner, IpdMetricRegistry ipdMetricRegistry, MailServerManager mailServerManager, ConnectionVerifier connectionVerifier) {
        this.mailServerManager = mailServerManager;
        this.connectionVerifier = connectionVerifier;
        this.ipdMetricRegistry = ipdMetricRegistry;
        ipdJobRunner.register((IpdJob)this);
    }

    public void runJob() {
        SMTPMailServer smtpMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (smtpMailServer == null) {
            LOG.debug("IPD metric 'mail.outgoing.connection.state' skipped, SMTP server is not configured");
            if (this.smtpConnectionStateMetric != null) {
                this.ipdMetricRegistry.remove(this.smtpConnectionStateMetric.getMetricKey());
                this.smtpConnectionStateMetric = null;
            }
            return;
        }
        this.smtpConnectionStateMetric = this.ipdMetricRegistry.customMetric("mail.outgoing.connection.state", IpdConnectionStateType.class, new MetricTag.RequiredMetricTag[0]);
        try {
            this.connectionVerifier.verifyConnection((MailServer)smtpMailServer);
            this.smtpConnectionStateMetric.update(m -> m.setConnected(true));
        }
        catch (Exception e) {
            this.smtpConnectionStateMetric.update(m -> m.setConnected(false));
            LOG.debug("IPD metric 'mail.outgoing.connection.state' failed", (Throwable)e);
        }
    }
}

