/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.mailqueue;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.wrapper.IpdValueAndStatsMetricWrapper;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.ipd.OneMinuteAverageCalculator;
import com.atlassian.jira.ipd.mailqueue.EmailSentCounter;
import com.atlassian.jira.ipd.mailqueue.ErrorMailQueueItemsAddedCounter;
import com.atlassian.jira.ipd.mailqueue.MailMonitoringMetric;
import com.atlassian.jira.ipd.mailqueue.MailQueueItemsAddedCounter;
import com.atlassian.jira.ipd.mailqueue.MailQueueItemsProcessedCounter;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.util.profiling.MetricTag;
import java.time.Clock;
import java.util.EnumMap;
import java.util.Map;

public class MailQueueItemsInProductDiagnosticJob
implements IpdJob {
    private final MailQueueItemsAddedCounter mailQueueItemsAddedCounter;
    private final ErrorMailQueueItemsAddedCounter errorMailQueueItemsAddedCounter;
    private final MailQueueItemsProcessedCounter mailQueueItemsProcessedCounter;
    private final EmailSentCounter emailSentCounter;
    private final MailQueue mailQueue;
    private final Map<MailMonitoringMetric, OneMinuteAverageCalculator> oneMinuteAverageCalculators;
    private final IpdValueAndStatsMetricWrapper valueAndStatsItemsAdded;
    private final IpdValueAndStatsMetricWrapper valueAndStatsErrorItemsAdded;
    private final IpdValueAndStatsMetricWrapper valueAndStatsItemsProcessed;
    private final IpdValueAndStatsMetricWrapper valueAndStatsEmailSent;

    public MailQueueItemsInProductDiagnosticJob(MailQueueItemsAddedCounter mailQueueItemsAddedCounter, ErrorMailQueueItemsAddedCounter errorMailQueueItemsAddedCounter, MailQueueItemsProcessedCounter mailQueueItemsProcessedCounter, EmailSentCounter emailSentCounter, MailQueue mailQueue, Clock clock, IpdJobRunner inProductDiagnosticJobRunner, IpdMainRegistry ipdMainRegistry) {
        this.mailQueueItemsAddedCounter = mailQueueItemsAddedCounter;
        this.errorMailQueueItemsAddedCounter = errorMailQueueItemsAddedCounter;
        this.mailQueueItemsProcessedCounter = mailQueueItemsProcessedCounter;
        this.emailSentCounter = emailSentCounter;
        this.mailQueue = mailQueue;
        inProductDiagnosticJobRunner.register((IpdJob)this);
        IpdMetricRegistry registry = ipdMainRegistry.createRegistry("mail.queue", new MetricTag.RequiredMetricTag[0]);
        this.valueAndStatsItemsAdded = registry.valueAndStatsMetric("numItemsAddedPerMin", new MetricTag.RequiredMetricTag[0]);
        this.valueAndStatsErrorItemsAdded = registry.valueAndStatsMetric("numErrorsAddedPerMin", new MetricTag.RequiredMetricTag[0]);
        this.valueAndStatsItemsProcessed = registry.valueAndStatsMetric("numItemsProcessedPerMin", new MetricTag.RequiredMetricTag[0]);
        this.valueAndStatsEmailSent = registry.valueAndStatsMetric("numEmailsSentPerMin", new MetricTag.RequiredMetricTag[0]);
        this.oneMinuteAverageCalculators = new EnumMap<MailMonitoringMetric, OneMinuteAverageCalculator>(MailMonitoringMetric.class);
        this.oneMinuteAverageCalculators.put(MailMonitoringMetric.NUMBER_OF_ITEMS_ADDED_TO_QUEUE, new OneMinuteAverageCalculator(clock));
        this.oneMinuteAverageCalculators.put(MailMonitoringMetric.NUMBER_OF_ITEMS_ADDED_TO_ERROR_QUEUE, new OneMinuteAverageCalculator(clock));
        this.oneMinuteAverageCalculators.put(MailMonitoringMetric.NUMBER_OF_ITEMS_PROCESSED, new OneMinuteAverageCalculator(clock));
        this.oneMinuteAverageCalculators.put(MailMonitoringMetric.NUMBER_OF_EMAILS_SENT, new OneMinuteAverageCalculator(clock));
    }

    public void runJob() {
        this.errorMailQueueItemsAddedCounter.recordErrorQueueCurrentSize(this.mailQueue.errorSize());
        long itemsAddedToQueue = this.oneMinuteAverageCalculators.get((Object)MailMonitoringMetric.NUMBER_OF_ITEMS_ADDED_TO_QUEUE).getOneMinuteAverageAndReset(this.mailQueueItemsAddedCounter.getAndReset());
        long itemsAddedToErrorQueue = this.oneMinuteAverageCalculators.get((Object)MailMonitoringMetric.NUMBER_OF_ITEMS_ADDED_TO_ERROR_QUEUE).getOneMinuteAverageAndReset(this.errorMailQueueItemsAddedCounter.getAndReset());
        long itemsProcessed = this.oneMinuteAverageCalculators.get((Object)MailMonitoringMetric.NUMBER_OF_ITEMS_PROCESSED).getOneMinuteAverageAndReset(this.mailQueueItemsProcessedCounter.getAndReset());
        long emailsSent = this.oneMinuteAverageCalculators.get((Object)MailMonitoringMetric.NUMBER_OF_EMAILS_SENT).getOneMinuteAverageAndReset(this.emailSentCounter.getAndReset());
        this.valueAndStatsItemsAdded.update(Long.valueOf(itemsAddedToQueue));
        this.valueAndStatsErrorItemsAdded.update(Long.valueOf(itemsAddedToErrorQueue));
        this.valueAndStatsItemsProcessed.update(Long.valueOf(itemsProcessed));
        this.valueAndStatsEmailSent.update(Long.valueOf(emailsSent));
    }
}

