/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.stats;

import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.exceptions.IpdRegisterException;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCustomMetric;
import com.atlassian.jira.ipd.stats.IpdRegistered;
import com.atlassian.util.profiling.MetricTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.management.MXBean;

public final class IpdMetricScanner {
    private IpdMetricScanner() {
    }

    public static void scanAndRegisterIpdMetrics(Object obj, IpdMetricRegistry registry) {
        if (IpdMetricScanner.hasMXBeanInterface(obj)) {
            registry.remove(IpdCustomMetric.builder((String)"", (Object)obj, (MetricTag.RequiredMetricTag[])new MetricTag.RequiredMetricTag[0]));
            registry.register(IpdCustomMetric.builder((String)"", (Object)obj, (MetricTag.RequiredMetricTag[])new MetricTag.RequiredMetricTag[0]));
        }
        Arrays.stream(obj.getClass().getDeclaredFields()).filter(IpdMetricScanner::hasIpdRegisterAnnotation).forEach(field -> {
            field.setAccessible(true);
            try {
                String jmxName = IpdMetricScanner.getJmxName(field);
                MetricTag.RequiredMetricTag[] tags = IpdMetricScanner.getJmxTags(field);
                IpdMetricScanner.scanAndRegisterIpdMetrics(field.get(obj), registry.createRegistry(jmxName, tags));
            }
            catch (IllegalAccessException e) {
                throw new IpdRegisterException("Couldn't scan object for registering ipd metrics", (Throwable)e);
            }
        });
    }

    private static boolean hasIpdRegisterAnnotation(Field f) {
        return f.isAnnotationPresent(IpdRegistered.class);
    }

    private static boolean hasMXBeanInterface(Object obj) {
        return Arrays.stream(obj.getClass().getInterfaces()).anyMatch(c -> c.isAnnotationPresent(MXBean.class));
    }

    private static String getJmxName(Field field) {
        IpdRegistered ipdAnnotation = field.getAnnotation(IpdRegistered.class);
        return ipdAnnotation.value();
    }

    private static MetricTag.RequiredMetricTag[] getJmxTags(Field field) {
        IpdRegistered ipdAnnotation = field.getAnnotation(IpdRegistered.class);
        if (ipdAnnotation.metricTags().length % 2 != 0) {
            throw new IpdRegisterException("There is odd number of metricTags arguments in @IpdRegistered annotation for field " + field);
        }
        ArrayList<MetricTag.RequiredMetricTag> tags = new ArrayList<MetricTag.RequiredMetricTag>(ipdAnnotation.metricTags().length / 2);
        Iterator iterator = Arrays.stream(ipdAnnotation.metricTags()).iterator();
        while (iterator.hasNext()) {
            tags.add(MetricTag.of((String)((String)iterator.next()), (String)((String)iterator.next())));
        }
        return tags.toArray(new MetricTag.RequiredMetricTag[0]);
    }
}

