/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentItem;
import com.atlassian.jira.issue.attachment.AttachmentsCategoriser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class AttachmentItems
implements Iterable<AttachmentItem> {
    @Nonnull
    private final ImmutableList<AttachmentItem> items;

    public AttachmentItems(Iterable<AttachmentItem> items) {
        this.items = ImmutableList.copyOf(items);
    }

    public List<Attachment> attachments() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.items, (Function)new AttachmentsCategoriser.AttachmentGetter()));
    }

    @Override
    public Iterator<AttachmentItem> iterator() {
        return this.items.iterator();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentItems that = (AttachmentItems)o;
        return this.items.equals(that.items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public String toString() {
        return "AttachmentItems{items=" + this.items + "}";
    }
}

