/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.util.FileSize;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.ConvertTemporaryAttachmentParams;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentFactory;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.validation.AfterUploadAttachmentValidator;
import com.atlassian.jira.issue.attachment.validation.AttachmentValidationError;
import com.atlassian.jira.issue.attachment.validation.BeforeUploadAttachmentValidator;
import com.atlassian.jira.issue.attachment.validation.PluggableAttachmentValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.plugin.attachment.AttachmentValidatorModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EitherUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.TemporaryWebAttachmentsMonitor;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.atlassian.jira.web.util.PreValidatedActionExecutor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Unit;
import io.atlassian.util.concurrent.Promise;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultTemporaryWebAttachmentManager
implements TemporaryWebAttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemporaryWebAttachmentManager.class);
    private static final String PROJECT_TYPE_KEY = "project";
    private static final String ISSUE_TYPE_KEY = "issue";
    private final FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil;
    private final AttachmentManager attachmentManager;
    private final AttachmentValidator attachmentValidator;
    private final I18nHelper.BeanFactory beanFactory;
    private final TemporaryWebAttachmentsMonitorLocator temporaryWebAttachmentsMonitorLocator;
    private final ApplicationProperties applicationProperties;
    private final TemporaryWebAttachmentFactory temporaryWebAttachmentsFactory;
    private final FeatureManager featureManager;
    private final Cache<String, Pair<String, Long>> associatedObjectsCache;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final AttachmentConfigStore attachmentConfigStore;
    private final PluginAccessor pluginAccessor;
    private final StreamAttachmentStore streamAttachmentStore;

    public DefaultTemporaryWebAttachmentManager(AttachmentManager attachmentManager, AttachmentValidator attachmentValidator, I18nHelper.BeanFactory beanFactory, TemporaryWebAttachmentsMonitorLocator temporaryWebAttachmentsMonitorLocator, ApplicationProperties applicationProperties, TemporaryWebAttachmentFactory temporaryWebAttachmentsFactory, CacheManager cacheManager, ProjectManager projectManager, IssueManager issueManager, FeatureManager featureManager, AttachmentConfigStore attachmentConfigStore, PluginAccessor pluginAccessor, StreamAttachmentStore streamAttachmentStore) {
        this.attachmentManager = attachmentManager;
        this.attachmentValidator = attachmentValidator;
        this.beanFactory = beanFactory;
        this.temporaryWebAttachmentsMonitorLocator = temporaryWebAttachmentsMonitorLocator;
        this.applicationProperties = applicationProperties;
        this.temporaryWebAttachmentsFactory = temporaryWebAttachmentsFactory;
        this.featureManager = featureManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.attachmentConfigStore = attachmentConfigStore;
        this.pluginAccessor = pluginAccessor;
        this.streamAttachmentStore = streamAttachmentStore;
        this.fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
        this.associatedObjectsCache = cacheManager.getCache(DefaultTemporaryWebAttachmentManager.class.getName() + "_temporaryAttachmentsAssociatedObjectsCache", null, new CacheSettingsBuilder().replicateViaCopy().replicateAsynchronously().remote().expireAfterWrite(1L, TimeUnit.DAYS).build());
    }

    @ParametersAreNonnullByDefault
    public Either<AttachmentError, TemporaryWebAttachment> createTemporaryWebAttachment(InputStream stream, String fileName, String contentType, long size, Either<Issue, Project> target, String formToken, @Nullable ApplicationUser user) {
        Assertions.notBlank((String)"contentType", (String)contentType);
        Assertions.notNull((String)"stream", (Object)stream);
        Assertions.notNull((String)"target", target);
        Assertions.nonNegative((String)"size", (long)size);
        Issue issue = target.isLeft() ? (Issue)target.left().get() : null;
        Project project = issue != null ? issue.getProjectObject() : (Project)target.right().get();
        Assertions.notNull((String)PROJECT_TYPE_KEY, (Object)project);
        FileInfoImpl fileInfo = new FileInfoImpl(fileName, size, contentType);
        Either result = new PreValidatedActionExecutor().withValidator(this.createCanCreateTemporaryAttachmentsValidator(fileName, target, user)).withValidator(this.createFileSizeValidator(fileName, size, user)).withValidator(this.createFileNameValidator(fileName, user)).withValidator(() -> this.invokeBeforeUploadValidators(fileName, target, validator -> validator.validateBeforeUpload(user, project, issue, fileInfo))).executeFailOnFirstError(() -> this.createTemporaryWebAttachmentWithoutValidation(user, stream, size, fileName, contentType, formToken, target));
        if (result.isRight()) {
            TemporaryWebAttachment tempAttachment = (TemporaryWebAttachment)result.right().get();
            this.saveAssociatedObject(tempAttachment.getStringId(), target);
            result = this.invokeAfterUploadValidators(fileName, target, validator -> this.streamAttachmentStore.getTemporaryAttachment(tempAttachment.getTemporaryAttachmentId(), inputStream -> validator.validateAfterUpload(user, project, issue, fileInfo, inputStream))).toLeft(() -> tempAttachment);
            if (result.isLeft()) {
                log.debug("Cleaning up temporary attachment #{}", (Object)tempAttachment.getStringId());
                TemporaryWebAttachmentsMonitor monitor = this.temporaryWebAttachmentsMonitorLocator.getOrCreate();
                monitor.removeById(tempAttachment.getStringId());
                this.associatedObjectsCache.remove((Object)tempAttachment.getStringId());
                this.attachmentManager.deleteTemporaryAttachment(tempAttachment.getTemporaryAttachmentId());
            }
        }
        return result;
    }

    private void saveAssociatedObject(String stringId, Either<Issue, Project> target) {
        this.associatedObjectsCache.put((Object)stringId, (Object)new Pair((Object)(target.isLeft() ? ISSUE_TYPE_KEY : PROJECT_TYPE_KEY), (Object)(target.isLeft() ? ((Issue)target.left().get()).getId() : ((Project)target.right().get()).getId())));
    }

    public boolean canGetTemporaryWebAttachment(String attachmentId, ApplicationUser user) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.associatedObjectsCache.containsKey((Object)attachmentId)) {
            return false;
        }
        return (Boolean)this.getAssociatedObjectForTemporaryWebAttachment(attachmentId).map(arg_0 -> this.lambda$canGetTemporaryWebAttachment$6(user, (ErrorCollection)errorCollection, arg_0)).getOrElse((Object)false);
    }

    private Option<Either<Issue, Project>> getAssociatedObjectForTemporaryWebAttachment(String temporaryAttachmentId) {
        Pair associatedObject = (Pair)this.associatedObjectsCache.get((Object)temporaryAttachmentId);
        if (associatedObject == null) {
            return Option.none();
        }
        if (PROJECT_TYPE_KEY.equals(associatedObject.left())) {
            Project projectObj = this.projectManager.getProjectObj((Long)associatedObject.right());
            if (projectObj == null) {
                return Option.none();
            }
            return Option.some((Object)Either.right((Object)projectObj));
        }
        if (ISSUE_TYPE_KEY.equals(associatedObject.left())) {
            MutableIssue issueObject = this.issueManager.getIssueObject((Long)associatedObject.right());
            if (issueObject == null) {
                return Option.none();
            }
            return Option.some((Object)Either.left((Object)issueObject));
        }
        return Option.none();
    }

    public Option<TemporaryWebAttachment> getTemporaryWebAttachment(String temporaryAttachmentId) {
        return this.temporaryWebAttachmentsMonitorLocator.getOrCreate().getById(temporaryAttachmentId);
    }

    public Collection<TemporaryWebAttachment> getTemporaryWebAttachmentsByFormToken(String formToken) {
        return this.temporaryWebAttachmentsMonitorLocator.getOrCreate().getByFormToken(formToken);
    }

    public void updateTemporaryWebAttachment(final String temporaryAttachmentId, final TemporaryWebAttachment updated) {
        final TemporaryWebAttachmentsMonitor monitor = this.temporaryWebAttachmentsMonitorLocator.getOrCreate();
        monitor.getById(temporaryAttachmentId).fold((Supplier)new Supplier<Unit>(){

            @Override
            public Unit get() {
                throw new NoSuchElementException("Temporary Web Attachment with id " + temporaryAttachmentId + " does not exist.");
            }
        }, (Function)new Function<TemporaryWebAttachment, Unit>(){

            @Override
            public Unit apply(@Nullable TemporaryWebAttachment original) {
                monitor.removeById(temporaryAttachmentId);
                monitor.add(updated);
                return Unit.VALUE;
            }
        });
    }

    private Either<AttachmentError, TemporaryWebAttachment> createTemporaryWebAttachmentWithoutValidation(@Nullable ApplicationUser user, InputStream stream, long size, String fileName, String contentType, String formToken, Either<Issue, Project> target) {
        try {
            TemporaryAttachmentId attachmentId = this.attachmentManager.createTemporaryAttachment(stream, size);
            String uniqueFileName = this.getUniqueFilename(fileName, formToken, target);
            return this.addToMonitorCleanUpOnFailure(this.temporaryWebAttachmentsFactory.create(attachmentId, uniqueFileName, contentType, formToken, size), user);
        }
        catch (Exception e) {
            log.debug("Exception occurred while attaching file.", (Throwable)e);
            return Either.left((Object)new AttachmentError("Exception occurred while attaching file: " + e.toString(), this.getI18n(user).getText("attachfile.error.io.error", fileName, e.getMessage()), fileName, Option.some((Object)e), ErrorCollection.Reason.SERVER_ERROR));
        }
    }

    private String getUniqueFilename(String fileName, String formToken, Either<Issue, Project> target) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.JIRA_ATTACHMENT_GENERATE_UNIQUE_SUFFIX_ENABLED)) {
            return fileName;
        }
        Set<String> existingFilenames = this.getExistingAttachmentFilenames(formToken, target);
        return this.generateUniqueFilename(fileName, existingFilenames);
    }

    private Set<String> getExistingAttachmentFilenames(String formToken, Either<Issue, Project> target) {
        return ImmutableSet.builder().addAll(this.getTemporaryAttachmentFilenames(formToken)).addAll(this.getExistingAttachments(target)).build();
    }

    private Set<String> getExistingAttachments(Either<Issue, Project> target) {
        return (Set)target.fold(this::getIssueAttachments, project -> Collections.emptySet());
    }

    private Set<String> getIssueAttachments(Issue issue) {
        return issue.getAttachments().stream().map(Attachment::getFilename).collect(Collectors.toSet());
    }

    private Set<String> getTemporaryAttachmentFilenames(String formToken) {
        return this.getTemporaryWebAttachmentsByFormToken(formToken).stream().map(TemporaryWebAttachment::getFilename).collect(Collectors.toSet());
    }

    private String generateUniqueFilename(String fileName, Set<String> existingFilenames) {
        String newFilename = fileName;
        String baseFilename = Files.getNameWithoutExtension((String)fileName);
        Object extension = Files.getFileExtension((String)fileName);
        if (!StringUtils.isBlank((CharSequence)extension)) {
            extension = "." + (String)extension;
        }
        int counter = 1;
        while (existingFilenames.contains(newFilename)) {
            newFilename = String.format("%s-%d%s", baseFilename, counter, extension);
            ++counter;
        }
        return newFilename;
    }

    private Supplier<Option<AttachmentError>> createCanCreateTemporaryAttachmentsValidator(final String fileName, final Either<Issue, Project> target, final @Nullable ApplicationUser user) {
        return new Supplier<Option<AttachmentError>>(){

            @Override
            public Option<AttachmentError> get() {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                DefaultTemporaryWebAttachmentManager.this.attachmentValidator.canCreateTemporaryAttachments(user, target, (ErrorCollection)errorCollection);
                return DefaultTemporaryWebAttachmentManager.getFirstError(fileName, (ErrorCollection)errorCollection);
            }
        };
    }

    private Supplier<Option<AttachmentError>> createCanConvertTemporaryAttachmentsValidator(final Issue issue, final @Nullable ApplicationUser user) {
        return new Supplier<Option<AttachmentError>>(){

            @Override
            public Option<AttachmentError> get() {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                DefaultTemporaryWebAttachmentManager.this.attachmentValidator.canCreateAttachments(user, issue, (ErrorCollection)errorCollection);
                return DefaultTemporaryWebAttachmentManager.getFirstError("", (ErrorCollection)errorCollection);
            }
        };
    }

    private Supplier<Option<AttachmentError>> createFileNameValidator(final String fileName, final @Nullable ApplicationUser user) {
        return new Supplier<Option<AttachmentError>>(){

            @Override
            public Option<AttachmentError> get() {
                if (StringUtils.isBlank((CharSequence)fileName)) {
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, "Attachment file name is blank", DefaultTemporaryWebAttachmentManager.this.getI18n(user).getText("attachfile.error.no.name"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                String invalidChar = DefaultTemporaryWebAttachmentManager.this.fileNameCharacterCheckerUtil.assertFileNameDoesNotContainInvalidChars(fileName);
                if (invalidChar != null) {
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, String.format("Attachment file name contains invalid character %s", invalidChar), DefaultTemporaryWebAttachmentManager.this.getI18n(user).getText("attachfile.error.invalidcharacter", fileName, invalidChar), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                return Option.none();
            }
        };
    }

    private Supplier<Option<AttachmentError>> createFileSizeValidator(final String fileName, final long size, final @Nullable ApplicationUser user) {
        return new Supplier<Option<AttachmentError>>(){

            @Override
            public Option<AttachmentError> get() {
                long maxAttachmentSize = DefaultTemporaryWebAttachmentManager.this.attachmentConfigStore.getConfig().getMaxAttachmentSize();
                if (size == 0L) {
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, "Bad attachment size: 0", DefaultTemporaryWebAttachmentManager.this.getI18n(user).getText("attachfile.error.io.bad.size.zero", fileName), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                if (size > maxAttachmentSize) {
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, String.format("Attachment is too large. %s > %s", size, maxAttachmentSize), DefaultTemporaryWebAttachmentManager.this.getI18n(user).getText("attachfile.error.file.large", fileName, FileSize.format((long)maxAttachmentSize)), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                return Option.none();
            }
        };
    }

    private <T extends PluggableAttachmentValidator> Optional<T> getValidatorOfType(AttachmentValidatorModuleDescriptor descriptor, Class<T> moduleClass) {
        try {
            return Optional.of(descriptor).filter(desc -> moduleClass.isAssignableFrom(desc.getModuleClass())).map(ModuleDescriptor::getModule).map(moduleClass::cast);
        }
        catch (Exception e) {
            log.warn("Exception thrown while initialising pluggable attachment validator " + descriptor.getCompleteKey(), (Throwable)e);
            return Optional.empty();
        }
    }

    private Option<AttachmentError> invokeBeforeUploadValidators(String fileName, Either<Issue, Project> target, Function<BeforeUploadAttachmentValidator, Optional<AttachmentValidationError>> validation) {
        String loggableAttachmentInfo = DefaultTemporaryWebAttachmentManager.getLoggableAttachmentInfo(fileName, target);
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(AttachmentValidatorModuleDescriptor.class);
        for (AttachmentValidatorModuleDescriptor descriptor : descriptors) {
            Optional<BeforeUploadAttachmentValidator> validator = this.getValidatorOfType(descriptor, BeforeUploadAttachmentValidator.class);
            String completeKey = descriptor.getCompleteKey();
            if (!validator.isPresent()) continue;
            log.trace("Invoking before-upload validator {} for {}", (Object)completeKey, (Object)loggableAttachmentInfo);
            try {
                Optional<AttachmentValidationError> error = validation.apply(validator.get());
                if (error.isPresent()) {
                    log.debug("Before-upload validator {} returned error for {}: {}", new Object[]{completeKey, loggableAttachmentInfo, error.get().getLogMessage()});
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, error.get().getLogMessage(), error.get().getLocalisedMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                log.trace("Before-upload validator {} returned success for {}", (Object)completeKey, (Object)loggableAttachmentInfo);
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown while executing before-upload attachment validator %s for %s", completeKey, loggableAttachmentInfo), (Throwable)e);
            }
        }
        return Option.none();
    }

    private Option<AttachmentError> invokeAfterUploadValidators(String fileName, Either<Issue, Project> target, Function<AfterUploadAttachmentValidator, Promise<Optional<AttachmentValidationError>>> validation) {
        String loggableAttachmentInfo = DefaultTemporaryWebAttachmentManager.getLoggableAttachmentInfo(fileName, target);
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(AttachmentValidatorModuleDescriptor.class);
        LinkedHashMap<String, Promise<Optional<AttachmentValidationError>>> results = new LinkedHashMap<String, Promise<Optional<AttachmentValidationError>>>();
        for (AttachmentValidatorModuleDescriptor attachmentValidatorModuleDescriptor : descriptors) {
            Optional<AfterUploadAttachmentValidator> validator = this.getValidatorOfType(attachmentValidatorModuleDescriptor, AfterUploadAttachmentValidator.class);
            String completeKey = attachmentValidatorModuleDescriptor.getCompleteKey();
            if (!validator.isPresent()) continue;
            log.trace("Invoking after-upload validator {} for {}", (Object)completeKey, (Object)loggableAttachmentInfo);
            results.put(completeKey, validation.apply(validator.get()));
        }
        for (Map.Entry entry : results.entrySet()) {
            String completeKey = (String)entry.getKey();
            Promise promise = (Promise)entry.getValue();
            try {
                log.trace("Awaiting validation result from after-upload validator {} for {}", (Object)completeKey, (Object)loggableAttachmentInfo);
                Optional error = (Optional)promise.claim();
                if (error.isPresent()) {
                    log.debug("After-upload validator {} returned error for {}: {}", new Object[]{completeKey, loggableAttachmentInfo, ((AttachmentValidationError)error.get()).getLogMessage()});
                    return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, ((AttachmentValidationError)error.get()).getLogMessage(), ((AttachmentValidationError)error.get()).getLocalisedMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                log.trace("After-upload validator {} returned success for {}", (Object)completeKey, (Object)loggableAttachmentInfo);
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown while executing after-upload attachment validator %s for %s", completeKey, loggableAttachmentInfo), (Throwable)e);
            }
        }
        return Option.none();
    }

    private static Option<AttachmentError> createAttachmentError(String fileName, String logMessage, String localizedMessage, ErrorCollection.Reason reason) {
        return Option.some((Object)new AttachmentError(logMessage, localizedMessage, fileName, reason));
    }

    public AttachmentsBulkOperationResult<ChangeItemBean> convertTemporaryAttachments(final @Nullable ApplicationUser user, final Issue issue, final List<String> temporaryAttachmentsIds) {
        return (AttachmentsBulkOperationResult)new PreValidatedActionExecutor<AttachmentError>().executeFailOnFirstError(new Supplier<Either<AttachmentError, AttachmentsBulkOperationResult<ChangeItemBean>>>(){

            @Override
            public Either<AttachmentError, AttachmentsBulkOperationResult<ChangeItemBean>> get() {
                temporaryAttachmentsIds.forEach(arg_0 -> DefaultTemporaryWebAttachmentManager.this.associatedObjectsCache.remove(arg_0));
                return Either.right(DefaultTemporaryWebAttachmentManager.this.convertTemporaryAttachmentsWithoutValidation(user, issue, temporaryAttachmentsIds));
            }
        }).right().on((Function)new Function<AttachmentError, AttachmentsBulkOperationResult<ChangeItemBean>>(){

            @Override
            public AttachmentsBulkOperationResult<ChangeItemBean> apply(AttachmentError input) {
                return new AttachmentsBulkOperationResult((List)ImmutableList.of((Object)input), Collections.emptyList());
            }
        });
    }

    private AttachmentsBulkOperationResult<ChangeItemBean> convertTemporaryAttachmentsWithoutValidation(final @Nullable ApplicationUser user, final Issue issue, List<String> temporaryAttachmentsIds) {
        final TemporaryWebAttachmentsMonitor monitor = this.temporaryWebAttachmentsMonitorLocator.getOrCreate();
        return new AttachmentsBulkOperationResult(EitherUtils.splitEithers(ImmutableList.copyOf((Iterable)io.atlassian.fugue.Iterables.transform(temporaryAttachmentsIds, (Function)new Function<String, Either<AttachmentError, ChangeItemBean>>(){

            @Override
            public Either<AttachmentError, ChangeItemBean> apply(String selectedAttachmentId) {
                return DefaultTemporaryWebAttachmentManager.this.transformTemporaryAttachment(selectedAttachmentId, user, issue, monitor);
            }
        }))));
    }

    public void clearTemporaryAttachmentsByFormToken(final String formToken) {
        this.temporaryWebAttachmentsMonitorLocator.get().map((Function)new Function<TemporaryWebAttachmentsMonitor, Unit>(){

            @Override
            public Unit apply(TemporaryWebAttachmentsMonitor monitor) {
                monitor.getByFormToken(formToken).forEach(attachment -> DefaultTemporaryWebAttachmentManager.this.associatedObjectsCache.remove((Object)attachment.getStringId()));
                monitor.cleanByFormToken(formToken);
                return Unit.VALUE;
            }
        });
    }

    private Either<AttachmentError, ChangeItemBean> transformTemporaryAttachment(final String selectedAttachmentId, final @Nullable ApplicationUser user, Issue issue, TemporaryWebAttachmentsMonitor monitor) {
        return (Either)monitor.getById(selectedAttachmentId).map(this.transformTemporaryAttachmentFunction(selectedAttachmentId, user, issue, monitor)).getOrElse((Supplier)new Supplier<Either<AttachmentError, ChangeItemBean>>(){

            @Override
            public Either<AttachmentError, ChangeItemBean> get() {
                String errorMessage = DefaultTemporaryWebAttachmentManager.this.getI18n(user).getText("attachfile.error.temp.file.not.exists");
                log.warn("Temporary attachment missing: " + selectedAttachmentId);
                return Either.left((Object)new AttachmentError("Temporary attachment missing: " + selectedAttachmentId, errorMessage, "#" + selectedAttachmentId, Option.none(), ErrorCollection.Reason.SERVER_ERROR));
            }
        });
    }

    private Function<TemporaryWebAttachment, Either<AttachmentError, ChangeItemBean>> transformTemporaryAttachmentFunction(final String selectedAttachmentId, final @Nullable ApplicationUser user, final Issue issue, final TemporaryWebAttachmentsMonitor monitor) {
        return new Function<TemporaryWebAttachment, Either<AttachmentError, ChangeItemBean>>(){

            @Override
            public Either<AttachmentError, ChangeItemBean> apply(TemporaryWebAttachment tempAttachment) {
                Either conversionResult = DefaultTemporaryWebAttachmentManager.this.attachmentManager.convertTemporaryAttachment(ConvertTemporaryAttachmentParams.builder().setAuthor(user).setIssue(issue).setTemporaryAttachmentId(tempAttachment.getTemporaryAttachmentId()).setFilename(tempAttachment.getFilename()).setContentType(tempAttachment.getContentType()).setFileSize(tempAttachment.getSize()).setCreatedTime(tempAttachment.getCreated()).build());
                return conversionResult.map((Function)new Function<ChangeItemBean, ChangeItemBean>(){

                    @Override
                    public ChangeItemBean apply(ChangeItemBean changeItemBean) {
                        monitor.removeById(selectedAttachmentId);
                        return changeItemBean;
                    }
                });
            }
        };
    }

    private I18nHelper getI18n(@Nullable ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }

    private Either<AttachmentError, TemporaryWebAttachment> addToMonitorCleanUpOnFailure(TemporaryWebAttachment temporaryAttachment, @Nullable ApplicationUser user) {
        Either<AttachmentError, TemporaryWebAttachment> result = this.tryAddToMonitor(temporaryAttachment, user);
        if (result.isLeft()) {
            this.attachmentManager.deleteTemporaryAttachment(temporaryAttachment.getTemporaryAttachmentId());
        }
        return result;
    }

    private Either<AttachmentError, TemporaryWebAttachment> tryAddToMonitor(TemporaryWebAttachment temporaryAttachment, @Nullable ApplicationUser user) {
        try {
            this.temporaryWebAttachmentsMonitorLocator.getOrCreate().add(temporaryAttachment);
            return Either.right((Object)temporaryAttachment);
        }
        catch (Exception e) {
            ExceptionUtil.logExceptionWithWarn(log, "Got exception while adding temporary attachment to attachment monitor.", (Throwable)e);
            return Either.left((Object)new AttachmentError(String.format("Got exception while adding temporary attachment '%s' to attachment monitor: %s", temporaryAttachment.getFilename(), e.toString()), this.getI18n(user).getText("attachfile.error.session.error", temporaryAttachment.getFilename()), temporaryAttachment.getFilename(), Option.some((Object)e), ErrorCollection.Reason.SERVER_ERROR));
        }
    }

    private static Option<AttachmentError> getFirstError(String fileName, ErrorCollection collection) {
        if (collection.hasAnyErrors()) {
            String message = DefaultTemporaryWebAttachmentManager.getFirstErrorMessage(collection);
            return DefaultTemporaryWebAttachmentManager.createAttachmentError(fileName, "An error occurred: " + message, message, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return Option.none();
    }

    private static String getLoggableAttachmentInfo(String fileName, Either<Issue, Project> target) {
        return String.format("file '%s' attached to %s", fileName.replaceAll("[\n\r]", " "), target.fold(issue -> "issue " + issue.getKey(), project -> "new issue in project " + project.getKey()));
    }

    private static String getFirstErrorMessage(ErrorCollection collection) {
        Iterable allErrors = Iterables.concat((Iterable)collection.getErrorMessages(), DefaultTemporaryWebAttachmentManager.mapValues(collection.getErrors()));
        String firstErrorMessage = (String)Iterables.getFirst((Iterable)allErrors, null);
        return (String)Preconditions.checkNotNull((Object)firstErrorMessage, (Object)"Expected to find error message but cannot find one!");
    }

    private static Collection<String> mapValues(@Nullable Map<String, String> map) {
        return map != null ? map.values() : Collections.emptyList();
    }

    private /* synthetic */ Boolean lambda$canGetTemporaryWebAttachment$6(ApplicationUser user, ErrorCollection errorCollection, Either associatedObject) {
        return this.attachmentValidator.canCreateTemporaryAttachments(user, associatedObject, errorCollection);
    }

    private static class FileInfoImpl
    implements PluggableAttachmentValidator.FileInfo {
        private final String fileName;
        private final long fileSize;
        private final String contentType;

        private FileInfoImpl(String fileName, long fileSize, String contentType) {
            this.fileName = fileName;
            this.fileSize = fileSize;
            this.contentType = contentType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

