/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultThumbnailAccessor
implements ThumbnailAccessor {
    @VisibleForTesting
    public static final String THUMBNAIL_DESIGNATION = "_thumb_";
    private final StreamAttachmentStore streamAttachmentStore;

    public DefaultThumbnailAccessor(StreamAttachmentStore streamAttachmentStore) {
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
    }

    private static FileStore.Path getThumbnailFilePath(Attachment attachment, FileStore.Path thumbnailContainer) {
        return thumbnailContainer.path(new String[]{THUMBNAIL_DESIGNATION + attachment.getId() + ".png"});
    }

    @Override
    @Nonnull
    public FileStore.Path getThumbnailFilePath(Attachment attachment) {
        return this.getThumbnailFilePath(attachment.getIssueObject(), attachment);
    }

    @Override
    @Nonnull
    public FileStore.Path getThumbnailFilePath(Issue issue, Attachment attachment) {
        FileStore.Path thumbPath = this.getThumbnailContainer(issue).orElseThrow(() -> new AttachmentReadException("Attachments disabled or issue is missing project key"));
        return DefaultThumbnailAccessor.getThumbnailFilePath(attachment, thumbPath);
    }

    @Nonnull
    private Optional<FileStore.Path> getThumbnailContainer(Issue issue) {
        return this.streamAttachmentStore.getAttachmentPathForIssue(issue).map(attachmentPath -> attachmentPath.path(new String[]{"thumbs"}));
    }

    @Override
    public Promise<Void> deleteThumbnailDirectory(@Nonnull Issue issue) {
        Objects.requireNonNull(issue);
        return this.getThumbnailContainer(issue).map(path -> {
            try {
                FileAttachments.deletePathRecursive(path);
            }
            catch (IOException e) {
                return Promises.rejected((Throwable)new AttachmentCleanupException("Error deleting thumbnail path for issue " + issue, (Throwable)e));
            }
            return Promises.promise(null);
        }).orElse(Promises.rejected((Throwable)new AttachmentCleanupException("Could not find thumbnail path for issue " + issue.getKey())));
    }
}

