/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreConfigurationStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.time.Duration;

public interface StreamAttachmentStoreStats
extends ManagedStats {
    public void getAttachmentData(Duration var1, Duration var2, long var3, FileStoreAnalyticInfo var5);

    public static class MutableStreamAttachmentStoreStats
    implements StreamAttachmentStoreStats {
        final MutableLongStats getAttachmentDataTTFBInMillis = new MutableLongStats(new long[0]);
        final MutableLongStats getAttachmentDataRateInBytesPerSec = new MutableLongStats(new long[0]);
        final FileStoreConfigurationStats configuration = new FileStoreConfigurationStats();

        @Override
        public void getAttachmentData(Duration ttfb, Duration executionTime, long contentLength, FileStoreAnalyticInfo fileStoreAnalyticInfo) {
            this.getAttachmentDataTTFBInMillis.accept(ttfb.toMillis());
            this.getAttachmentDataRateInBytesPerSec.accept(this.getTransferRateInBytesPerSec(executionTime.toMillis(), contentLength));
            this.configuration.setFileStoreType(fileStoreAnalyticInfo.getFileStoreType());
            this.configuration.setCustomS3Url(fileStoreAnalyticInfo.isS3EndpointOverrideUsed());
        }

        private long getTransferRateInBytesPerSec(long executionTimeInMillis, long contentLengthInBytes) {
            long executionTimeRounded = executionTimeInMillis == 0L ? 1L : executionTimeInMillis;
            return (long)((double)contentLengthInBytes / (double)executionTimeRounded * 1000.0);
        }

        public String getStatsName() {
            return "StreamAttachmentStoreStats";
        }
    }
}

