/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class ChangeHistoryUsernameResolver {
    private final UserManager userManager;

    public ChangeHistoryUsernameResolver(UserManager userManager) {
        this.userManager = userManager;
    }

    public List<GenericValue> resolveUsernames(@Nonnull I18nHelper i18n, @Nullable List<GenericValue> changeItems) {
        if (changeItems == null) {
            return Collections.emptyList();
        }
        return changeItems.stream().map(changeItem -> this.isAssigneeOrReporterChangeItem((GenericValue)changeItem) ? this.getChangeItemWithUserKeyReplaced(i18n, (GenericValue)changeItem) : changeItem).collect(Collectors.toList());
    }

    private boolean isAssigneeOrReporterChangeItem(GenericValue changeItem) {
        String changedField = changeItem.getString("field");
        return changedField.equals("assignee") || changedField.equals("reporter");
    }

    private GenericValue getChangeItemWithUserKeyReplaced(I18nHelper i18n, GenericValue changeItem) {
        GenericValue newChangeItem = new GenericValue(changeItem);
        String oldUserKey = changeItem.getString("oldvalue");
        this.partiallyUpdateChangeItem(i18n, newChangeItem, oldUserKey, "oldstring", "oldvalue");
        String newUserKey = changeItem.getString("newvalue");
        this.partiallyUpdateChangeItem(i18n, newChangeItem, newUserKey, "newstring", "newvalue");
        return newChangeItem;
    }

    private void partiallyUpdateChangeItem(I18nHelper i18n, GenericValue changeItem, String userKey, String displayNameField, String usernameField) {
        if (userKey == null) {
            return;
        }
        Optional<ApplicationUser> user = this.lookupUser(userKey);
        if (user.isPresent()) {
            changeItem.set(displayNameField, (Object)user.get().getDisplayName());
            changeItem.set(usernameField, (Object)user.get().getUsername());
        } else {
            changeItem.set(usernameField, (Object)i18n.getText("changehistory.deactivated.user"));
        }
    }

    private Optional<ApplicationUser> lookupUser(@Nullable String userKey) {
        return Optional.ofNullable(this.userManager.getUserByKey(userKey));
    }
}

