/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.model.querydsl.ActionDTO;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ActionDTOToCommentConverter {
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;
    private final LoadingCache<Long, Issue> issueCache;

    public ActionDTOToCommentConverter(ProjectRoleManager projectRoleManager, final IssueManager issueManager, UserManager userManager) {
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
        this.issueCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Issue>(){

            public Issue load(Long key) {
                return issueManager.getIssueObject(key);
            }
        });
    }

    public Comment convert(ActionDTO action) throws ExecutionException {
        Issue issue = (Issue)this.issueCache.get((Object)action.getIssue());
        return this.convert(action, issue);
    }

    public Comment convert(ActionDTO actionDTO, Issue issue) {
        CommentImpl comment = new CommentImpl(this.projectRoleManager, this.userManager.getUserByKeyEvenWhenUnknown(actionDTO.getAuthor()), this.userManager.getUserByKeyEvenWhenUnknown(actionDTO.getUpdateauthor()), actionDTO.getBody(), actionDTO.getLevel(), actionDTO.getRolelevel(), JiraDateUtils.copyDateNullsafe((Date)actionDTO.getCreated()), JiraDateUtils.copyDateNullsafe((Date)actionDTO.getUpdated()), issue);
        comment.setId(actionDTO.getId());
        return comment;
    }
}

