/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentOrderManager;
import com.atlassian.jira.plugin.issuetabpanel.TabPanelOrder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.Collections;
import java.util.List;

public class CommentOrderManagerImpl
implements CommentOrderManager {
    private final CommentManager commentManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final ApplicationProperties applicationProperties;

    public CommentOrderManagerImpl(CommentManager commentManager, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties) {
        this.commentManager = commentManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = (UserPreferencesManager)ComponentAccessor.getComponentOfType(UserPreferencesManager.class);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void setIssueCommentsOrder(TabPanelOrder order) throws AtlassianCoreException {
        this.getUserExtendedPreferences().setString("user.issue.comments.order", order.asText());
    }

    @Override
    public TabPanelOrder getIssueCommentsOrder() {
        ExtendedPreferences userExtendedPreferences;
        if (this.jiraAuthenticationContext.isLoggedInUser() && (userExtendedPreferences = this.getUserExtendedPreferences()).containsValue("user.issue.comments.order")) {
            return TabPanelOrder.fromString((String)userExtendedPreferences.getString("user.issue.comments.order"));
        }
        return TabPanelOrder.fromString((String)this.applicationProperties.getDefaultBackedString("jira.issue.actions.order"));
    }

    @Override
    public List<Comment> getSortedComments(Issue issue, ApplicationUser user) {
        List comments = this.commentManager.getCommentsForUser(issue, user);
        if (TabPanelOrder.NEWEST_FIRST == this.getIssueCommentsOrder()) {
            Collections.reverse(comments);
        }
        return comments;
    }

    private ExtendedPreferences getUserExtendedPreferences() {
        return this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getLoggedInUser());
    }
}

