/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.issue.comparator.CustomFieldComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class CustomFieldComparators {
    public static Comparator<CustomField> byName() {
        return new NameComparator();
    }

    public static Comparator<CustomField> byTranslatedName(Locale locale, TranslationManager translationManager) {
        return new TranslatedNameComparator(locale, translationManager);
    }

    public static Comparator<GenericValue> byGvName() {
        return new CustomFieldComparator();
    }

    static int compareNames(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    private static class NameComparator
    implements Comparator<CustomField> {
        @Override
        public int compare(CustomField o1, CustomField o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return CustomFieldComparators.compareNames(this.getCustomFieldName(o1), this.getCustomFieldName(o2));
        }

        protected String getCustomFieldName(CustomField customField) {
            return customField.getUntranslatedName();
        }
    }

    private static class TranslatedNameComparator
    extends NameComparator
    implements Comparator<CustomField> {
        private final TranslationManager translationManager;
        private final Locale locale;

        public TranslatedNameComparator(Locale locale, TranslationManager translationManager) {
            this.locale = locale;
            this.translationManager = translationManager;
        }

        @Override
        protected String getCustomFieldName(CustomField customField) {
            String translatedName = this.translationManager.getCustomFieldNameTranslation(customField, this.locale);
            if (StringUtils.isNotEmpty((CharSequence)translatedName)) {
                return translatedName;
            }
            return customField.getUntranslatedName();
        }
    }
}

