/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.CascadingSelectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.CascadingSelectCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.statistics.CascadingOptionComparator;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.CustomFieldOptionJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ObjectUtils;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

public class CascadingSelectCFType
extends AbstractCustomFieldType<Map<String, Option>, Option>
implements MultipleSettableCustomFieldType<Map<String, Option>, Option>,
SortableCustomField<Map<String, Option>>,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    public static final String PARENT_KEY = null;
    public static final String CHILD_KEY = "1";
    public static final String HIERARCHY_SEPARATOR = " -> ";
    private static final Logger log = LoggerFactory.getLogger(CascadingSelectCFType.class);
    public static final PersistenceFieldType CASCADE_VALUE_TYPE = PersistenceFieldType.TYPE_LIMITED_TEXT;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final OptionsManager optionsManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final GenericConfigManager genericConfigManager;
    private final JiraBaseUrls jiraBaseUrls;
    private Comparator<Option> optionComparator;

    public CascadingSelectCFType(OptionsManager optionsManager, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, JiraBaseUrls jiraBaseUrls) {
        this.customFieldValuePersister = customFieldValuePersister;
        this.optionsManager = optionsManager;
        this.genericConfigManager = genericConfigManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectCustomFieldImporter = new CascadingSelectCustomFieldImporter();
        this.optionComparator = CascadingOptionComparator.getComparator();
    }

    public void removeValue(CustomField field, Issue issue, Option option) {
        if (option != null) {
            this.customFieldValuePersister.removeValue(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, (Object)option.getOptionId().toString());
        }
    }

    public Set<Long> remove(CustomField field) {
        this.optionsManager.removeCustomFieldOptions(field);
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    public Options getOptions(FieldConfig fieldConfig, JiraContextNode jiraContextNode) {
        return this.getOptions(fieldConfig);
    }

    public Options getOptions(FieldConfig fieldConfig) {
        return this.optionsManager.getOptions(fieldConfig);
    }

    public Set<Long> getIssueIdsWithValue(CustomField field, Option option) {
        HashSet<Long> allIssues = new HashSet<Long>();
        if (option != null) {
            allIssues.addAll(this.customFieldValuePersister.getIssueIdsWithValue(field, CASCADE_VALUE_TYPE, (Object)option.getOptionId().toString()));
            List childOptions = option.getChildOptions();
            if (!childOptions.isEmpty()) {
                for (Option childOption : childOptions) {
                    allIssues.addAll(this.customFieldValuePersister.getIssueIdsWithValue(field, CASCADE_VALUE_TYPE, (Object)childOption.getOptionId().toString()));
                }
            }
        }
        return allIssues;
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Option parentOption;
        if (relevantParams == null || relevantParams.isEmpty()) {
            return;
        }
        String customFieldId = config.getCustomField().getId();
        if (this.formHasTheSameOptionsAsDatabase(relevantParams, config)) {
            return;
        }
        try {
            parentOption = this.extractOptionFromParams(PARENT_KEY, relevantParams);
        }
        catch (FieldValidationException e) {
            parentOption = null;
        }
        if (parentOption == null) {
            ArrayList<String> params = new ArrayList<String>(relevantParams.getValuesForKey(null));
            if (!params.isEmpty() && !this.isNoneOptionSelected(params)) {
                errorCollectionToAddTo.addError(customFieldId, this.getI18nBean().getText("admin.errors.option.invalid.parent", "'" + params.get(0).toString() + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (!this.parentOptionValidForConfig(config, parentOption)) {
            errorCollectionToAddTo.addError(customFieldId, this.getI18nBean().getText("admin.errors.option.invalid.for.context", "'" + parentOption.getValue() + "'", "'" + config.getName() + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            try {
                Collection valuesForChild = relevantParams.getValuesForKey(CHILD_KEY);
                if (valuesForChild != null) {
                    ArrayList<String> params = new ArrayList<String>(valuesForChild);
                    Option currentOption = null;
                    if (!this.isNoneOptionSelected(params) && !this.currentOptionValidForConfig(config, currentOption = this.extractOptionFromParams(CHILD_KEY, relevantParams))) {
                        String optionValue = currentOption == null ? ((String)params.get(0)).toString() : currentOption.getValue();
                        errorCollectionToAddTo.addError(customFieldId, this.getI18nBean().getText("admin.errors.option.invalid.for.context", "'" + optionValue + "'", "'" + config.getName() + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
                        return;
                    }
                    if (currentOption != null && currentOption.getParentOption() != null && !parentOption.equals(currentOption.getParentOption())) {
                        errorCollectionToAddTo.addError(customFieldId, this.getI18nBean().getText("admin.errors.option.invalid.for.parent", "'" + currentOption.getValue() + "'", "'" + parentOption.getValue() + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                }
            }
            catch (FieldValidationException e) {
                errorCollectionToAddTo.addError(customFieldId, e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public boolean areAllRequiredParametersPresent(Map<String, Object> params, String customFieldId) {
        return super.areAllRequiredParametersPresent(params, customFieldId) && this.areAllNecessaryFieldsSet(params, customFieldId);
    }

    private boolean areAllNecessaryFieldsSet(Map<String, Object> params, String customFieldId) {
        CustomFieldParams customFieldParams = (CustomFieldParams)params.get(customFieldId);
        if (this.isChildOptionRequiredForSelectedParentOption(customFieldParams)) {
            return this.isChildOptionValueSet(customFieldParams);
        }
        return true;
    }

    private boolean isChildOptionRequiredForSelectedParentOption(CustomFieldParams customFieldParams) {
        Long parentOptionId = this.getParentOptionIdFromParams(customFieldParams);
        return this.isChildOptionPresentForParentId(parentOptionId);
    }

    private Long getParentOptionIdFromParams(CustomFieldParams customFieldParams) {
        String id = (String)Objects.requireNonNull(customFieldParams.getValuesForKey(PARENT_KEY)).iterator().next();
        return id != null ? Long.valueOf(Long.parseLong(id)) : null;
    }

    private boolean isChildOptionPresentForParentId(Long parentOptionId) {
        List childOptions = this.optionsManager.findByParentId(parentOptionId);
        return childOptions != null && this.isAtLeastOneChildOptionEnabled(childOptions);
    }

    private boolean isAtLeastOneChildOptionEnabled(List<Option> childOptions) {
        return childOptions.stream().anyMatch(option -> option.getDisabled() == false);
    }

    private boolean isChildOptionValueSet(CustomFieldParams customFieldParams) {
        Object customFieldValues = this.getValueFromCustomFieldParams(customFieldParams);
        return customFieldValues != null && customFieldValues.containsKey(CHILD_KEY) && customFieldValues.get(CHILD_KEY) != null;
    }

    private boolean formHasTheSameOptionsAsDatabase(@Nonnull CustomFieldParams relevantParams, @Nonnull FieldConfig config) {
        String issueId = (String)relevantParams.getFirstValueForKey(CustomFieldUtils.getParamKeyIssueId());
        if (issueId != null) {
            Map<String, Option> databaseValues = this.getValueFromIssue(config.getCustomField(), Longs.tryParse((String)issueId));
            return databaseValues != null && this.areOptionsEqual(PARENT_KEY, relevantParams, databaseValues) && this.areOptionsEqual(CHILD_KEY, relevantParams, databaseValues);
        }
        return false;
    }

    private boolean areOptionsEqual(@Nullable String key, @Nonnull CustomFieldParams formParams, @Nonnull Map<String, Option> databaseValues) {
        Option databaseValue = databaseValues.get(key);
        Long databaseOptionId = databaseValue != null ? databaseValue.getOptionId() : null;
        String formValue = (String)formParams.getFirstValueForKey(key);
        Long formOptionId = formValue != null ? Longs.tryParse((String)formValue) : null;
        return Objects.equals(databaseOptionId, formOptionId);
    }

    private boolean isNoneOptionSelected(List<String> params) {
        String parentOptionParam = params.iterator().next();
        return parentOptionParam == null || "-1".equals(parentOptionParam);
    }

    private boolean parentOptionValidForConfig(FieldConfig config, Option parentOption) {
        List rootOptions;
        Options options = this.optionsManager.getOptions(config);
        if (options != null && (rootOptions = options.getRootOptions()) != null) {
            return rootOptions.contains(parentOption);
        }
        return false;
    }

    private boolean currentOptionValidForConfig(FieldConfig config, Option currentOption) {
        List rootOptions;
        Options options = this.optionsManager.getOptions(config);
        if (options != null && (rootOptions = options.getRootOptions()) != null && currentOption != null) {
            return options.getOptionById(currentOption.getOptionId()) != null;
        }
        return false;
    }

    public void createValue(CustomField field, Issue issue, @Nonnull Map<String, Option> cascadingOptions) {
        Option parent = cascadingOptions.get(PARENT_KEY);
        Option child = cascadingOptions.get(CHILD_KEY);
        if (parent != null) {
            this.customFieldValuePersister.createValues(field, issue.getId(), CASCADE_VALUE_TYPE, (Collection)Lists.newArrayList((Object[])new String[]{parent.getOptionId().toString()}), null);
            if (child != null) {
                this.customFieldValuePersister.createValues(field, issue.getId(), CASCADE_VALUE_TYPE, (Collection)Lists.newArrayList((Object[])new String[]{child.getOptionId().toString()}), parent.getOptionId().toString());
            }
        }
    }

    public void updateValue(CustomField field, Issue issue, Map<String, Option> cascadingOptions) {
        this.customFieldValuePersister.updateValues(field, issue.getId(), CASCADE_VALUE_TYPE, null);
        if (cascadingOptions != null) {
            Option parent = cascadingOptions.get(PARENT_KEY);
            Option child = cascadingOptions.get(CHILD_KEY);
            if (parent != null) {
                this.customFieldValuePersister.updateValues(field, issue.getId(), CASCADE_VALUE_TYPE, (Collection)Lists.newArrayList((Object[])new String[]{parent.getOptionId().toString()}), null);
                if (child != null) {
                    this.customFieldValuePersister.updateValues(field, issue.getId(), CASCADE_VALUE_TYPE, (Collection)Lists.newArrayList((Object[])new String[]{child.getOptionId().toString()}), parent.getOptionId().toString());
                }
            }
        }
    }

    @Nullable
    public Map<String, Option> getValueFromIssue(CustomField field, Issue issue) {
        return this.getValueFromIssue(field, issue.getId());
    }

    @Nullable
    private Map<String, Option> getValueFromIssue(@Nonnull CustomField field, @Nullable Long issueId) {
        Option parentOption = this.getOptionValueForParentId(field, null, issueId);
        if (parentOption != null) {
            HashMap<String, Option> options = new HashMap<String, Option>();
            options.put(PARENT_KEY, parentOption);
            Option childOption = this.getOptionValueForParentId(field, parentOption.getOptionId().toString(), issueId);
            if (childOption != null) {
                options.put(CHILD_KEY, childOption);
            }
            return options;
        }
        return null;
    }

    public Map<String, Option> getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        if (relevantParams != null && !relevantParams.isEmpty()) {
            try {
                return this.getOptionMapFromCustomFieldParams(relevantParams);
            }
            catch (FieldValidationException e) {
                return null;
            }
        }
        return null;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters;
    }

    @Nullable
    public Map<String, Option> getDefaultValue(FieldConfig fieldConfig) {
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (o != null) {
            CustomFieldParamsImpl params = new CustomFieldParamsImpl(fieldConfig.getCustomField(), o);
            return this.getOptionMapFromCustomFieldParams((CustomFieldParams)params);
        }
        return null;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Map<String, Option> cascadingOptions) {
        if (cascadingOptions != null) {
            CustomFieldParamsImpl customFieldParams = new CustomFieldParamsImpl(fieldConfig.getCustomField(), cascadingOptions);
            customFieldParams.transformObjectsToStrings();
            customFieldParams.setCustomField(null);
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), (Object)customFieldParams);
        } else {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), null);
        }
    }

    public String getChangelogValue(CustomField field, Map<String, Option> cascadingOptions) {
        if (cascadingOptions != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Parent values: ");
            Option parent = cascadingOptions.get(PARENT_KEY);
            sb.append(parent.getValue()).append("(").append(parent.getOptionId()).append(")");
            Option child = cascadingOptions.get(CHILD_KEY);
            if (child != null) {
                sb.append("Level ").append(CHILD_KEY).append(" values: ");
                sb.append(child.getValue()).append("(").append(child.getOptionId()).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    public String getStringFromSingularObject(Option optionObject) {
        if (optionObject != null) {
            return optionObject.getOptionId().toString();
        }
        log.warn("Object passed '" + optionObject + "' is not an Option but is null");
        return null;
    }

    public Option getSingularObjectFromString(String string) throws FieldValidationException {
        return this.getOptionFromStringValue(string);
    }

    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new SettableOptionsConfigItem((CustomFieldType)this, this.optionsManager));
        return configurationItemTypes;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(@Nullable Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Option> databaseOptions;
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        velocityParams.put("request", ServletActionContext.getRequest());
        if (issue != null && (databaseOptions = this.getValueFromIssue(field, issue.getId())) != null) {
            velocityParams.put("databaseParent", databaseOptions.get(PARENT_KEY));
            velocityParams.put("databaseChild", databaseOptions.get(CHILD_KEY));
        }
        return velocityParams;
    }

    private Map<String, Option> getOptionMapFromCustomFieldParams(CustomFieldParams params) throws FieldValidationException {
        Option parentOption = this.extractOptionFromParams(PARENT_KEY, params);
        Option childOption = this.extractOptionFromParams(CHILD_KEY, params);
        if (parentOption == null && childOption == null) {
            return null;
        }
        HashMap<String, Option> options = new HashMap<String, Option>();
        options.put(PARENT_KEY, parentOption);
        if (childOption != null) {
            options.put(CHILD_KEY, childOption);
        }
        return options;
    }

    @Nullable
    private Option extractOptionFromParams(String key, CustomFieldParams relevantParams) throws FieldValidationException {
        String selectValue;
        Collection params = relevantParams.getValuesForKey(key);
        if (params != null && !params.isEmpty() && ObjectUtils.isValueSelected((Object)(selectValue = (String)params.iterator().next())) && selectValue != null && !selectValue.equalsIgnoreCase("none")) {
            return this.getOptionFromStringValue(selectValue);
        }
        return null;
    }

    @Nullable
    private Option getOptionFromStringValue(String selectValue) throws FieldValidationException {
        Long aLong = OptionUtils.safeParseLong((String)selectValue);
        if (aLong != null) {
            return this.optionsManager.findByOptionId(aLong);
        }
        List options = this.optionsManager.findByOptionValue(selectValue);
        if (options.size() == 0) {
            throw new FieldValidationException("Value: '" + selectValue + "' is an invalid Option");
        }
        if (options.size() == 1) {
            return (Option)options.get(0);
        }
        throw new FieldValidationException("Value: '" + selectValue + "' has multiple possible options, please use the custom field id instead");
    }

    @Nullable
    private Option getOptionValueForParentId(CustomField field, @Nullable String sParentOptionId, @Nullable Long issueId) {
        List values = this.customFieldValuePersister.getValues(field, issueId, CASCADE_VALUE_TYPE, sParentOptionId);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        String optionId = (String)values.iterator().next();
        return this.optionsManager.findByOptionId(OptionUtils.safeParseLong((String)optionId));
    }

    public int compare(@Nonnull Map<String, Option> o1, @Nonnull Map<String, Option> o2, FieldConfig fieldConfig) {
        Option option2;
        Option option1 = o1.get(PARENT_KEY);
        int parentCompare = this.compareOption(option1, option2 = o2.get(PARENT_KEY));
        if (parentCompare == 0) {
            Option childOption1 = o1.get(CHILD_KEY);
            Option childOption2 = o2.get(CHILD_KEY);
            return this.compareOption(childOption1, childOption2);
        }
        return parentCompare;
    }

    public int compareOption(@Nullable Option option1, @Nullable Option option2) {
        return this.optionComparator.compare(option1, option2);
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitCascadingSelect(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        Object selectValue = this.getValueFromIssue(context.getCustomField(), issue);
        Object value = "";
        if (selectValue != null && selectValue.get(PARENT_KEY) != null) {
            value = ((Option)selectValue.get(PARENT_KEY)).getValue();
            if (selectValue.get(CHILD_KEY) != null) {
                value = (String)value + HIERARCHY_SEPARATOR + ((Option)selectValue.get(CHILD_KEY)).getValue();
            }
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)value);
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == CascadingSelectCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        FieldConfig config = ((CustomField)fieldTypeInfoContext.getOderableField()).getRelevantConfig(fieldTypeInfoContext.getIssueContext());
        Options options = this.optionsManager.getOptions(config);
        Collection optionBeans = CustomFieldOptionJsonBean.shortBeans((Collection)options, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldTypeInfo(optionBeans, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"option-with-child", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Object options = this.getValueFromIssue(field, issue);
        if (options == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        Option parent = (Option)options.get(PARENT_KEY);
        Option child = (Option)options.get(CHILD_KEY);
        return new FieldJsonRepresentation(new JsonData((Object)CustomFieldOptionJsonBean.shortBean((Option)parent, (Option)child, (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new CascadingSelectCustomFieldOperationsHandler(this.optionsManager, field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig fieldConfig = field.getRelevantConfig(issueCtx);
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (o != null) {
            CustomFieldParamsImpl params = new CustomFieldParamsImpl(fieldConfig.getCustomField(), o);
            Map<String, Option> options = this.getOptionMapFromCustomFieldParams((CustomFieldParams)params);
            if (options == null) {
                return new JsonData(null);
            }
            Option parent = options.get(PARENT_KEY);
            Option child = options.get(CHILD_KEY);
            return new JsonData((Object)CustomFieldOptionJsonBean.shortBean((Option)parent, (Option)child, (JiraBaseUrls)this.jiraBaseUrls));
        }
        return null;
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitCascadingSelect(CascadingSelectCFType var1);
    }
}

