/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.ProjectPickerCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.ProjectOptionsConfigItem;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.ProjectCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCFType
extends AbstractSingleFieldType<Project>
implements SortableCustomField<GenericValue>,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    private final ProjectConverter projectConverter;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;

    public ProjectCFType(CustomFieldValuePersister customFieldValuePersister, ProjectConverter projectConverter, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GenericConfigManager genericConfigManager, JiraBaseUrls jiraBaseUrls, ProjectManager projectManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.projectConverter = projectConverter;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectManager = projectManager;
        this.projectCustomFieldImporter = new ProjectPickerCustomFieldImporter();
    }

    public int compare(@Nonnull GenericValue customFieldObjectValue1, @Nonnull GenericValue customFieldObjectValue2, FieldConfig fieldConfig) {
        return OfBizComparators.NAME_COMPARATOR.compare(customFieldObjectValue1, customFieldObjectValue2);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    protected Object getDbValueFromObject(Project customFieldObject) {
        if (customFieldObject == null) {
            return null;
        }
        return new Double(customFieldObject.getId().longValue());
    }

    protected Project getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        Double projectId = (Double)databaseValue;
        return this.projectConverter.getProject(new Long(projectId.intValue()));
    }

    public String getStringFromSingularObject(Project customFieldObject) {
        return this.projectConverter.getString(customFieldObject);
    }

    public Project getSingularObjectFromString(String string) throws FieldValidationException {
        return this.projectConverter.getProject(string);
    }

    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new ProjectOptionsConfigItem(this.permissionManager, this.jiraAuthenticationContext));
        return configurationItemTypes;
    }

    public String getChangelogString(CustomField field, Project value) {
        if (value == null) {
            return null;
        }
        return value.getName();
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Project project;
        Map params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null && (project = (Project)this.getValueFromIssue(field, issue)) != null) {
            boolean hasPermission = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.jiraAuthenticationContext.getUser());
            params.put("isProjectVisible", hasPermission ? Boolean.TRUE : Boolean.FALSE);
        }
        return params;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitProject(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        Project project = (Project)this.getValueFromIssue(context.getCustomField(), issue);
        String value = project != null ? project.getName() : "";
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)value);
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == ProjectCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.jiraAuthenticationContext.getUser());
        return new FieldTypeInfo(ProjectJsonBean.shortBeans((Collection)projects, (JiraBaseUrls)this.jiraBaseUrls), null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"project", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Project valueFromIssue = (Project)this.getValueFromIssue(field, issue);
        if (valueFromIssue == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        Project project = this.projectConverter.getProjectObject(valueFromIssue.getId());
        return new FieldJsonRepresentation(new JsonData((Object)ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new ProjectCustomFieldOperationsHandler(this.projectManager, field, this.getI18nBean());
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitProject(ProjectCFType var1);
    }
}

