/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.UserCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.UserFilterConfigItem;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.UserCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.math.NumberUtils;

public class UserCFType
extends AbstractSingleFieldType<ApplicationUser>
implements SortableCustomField<ApplicationUser>,
UserCFNotificationTypeAware,
ProjectImportableCustomField,
UserField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    public static final SharedEntity.TypeDescriptor<SharedEntity.Identifier> ENTITY_TYPE = SharedEntity.TypeDescriptor.Factory.get().create("UserPicker");
    private final ProjectCustomFieldImporter userCustomFieldImporter = new UserCustomFieldImporter();
    private final UserConverter userConverter;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ProjectManager projectManager;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserSearchService searchService;
    private final JiraBaseUrls jiraBaseUrls;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserHistoryManager userHistoryManager;
    private final UserFilterManager userFilterManager;
    private final I18nHelper i18nHelper;
    private final UserBeanFactory userBeanFactory;
    private final FeatureManager featureManager;

    public UserCFType(CustomFieldValuePersister customFieldValuePersister, UserConverter userConverter, GenericConfigManager genericConfigManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager, SoyTemplateRendererProvider soyTemplateRendererProvider, GroupManager groupManager, ProjectRoleManager projectRoleManager, UserSearchService searchService, JiraBaseUrls jiraBaseUrls, UserHistoryManager userHistoryManager, UserFilterManager userFilterManager, I18nHelper i18nHelper, UserBeanFactory userBeanFactory, FeatureManager featureManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.userConverter = userConverter;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.projectManager = projectManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.searchService = searchService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userBeanFactory = userBeanFactory;
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.userHistoryManager = userHistoryManager;
        this.userFilterManager = userFilterManager;
        this.i18nHelper = i18nHelper;
        this.featureManager = featureManager;
    }

    public void updateValue(CustomField customField, Issue issue, ApplicationUser user) {
        super.updateValue(customField, issue, (Object)user);
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        ApplicationUser defaultValue = (ApplicationUser)this.getDefaultValue(customField.getRelevantConfig(issue));
        if (user != null && !user.equals((Object)loggedInUser) && !user.equals((Object)defaultValue)) {
            this.userHistoryManager.addUserToHistory(UserHistoryItem.USED_USER, loggedInUser, user);
        }
    }

    public String getChangelogValue(CustomField field, ApplicationUser value) {
        if (value == null) {
            return "";
        }
        return value.getKey();
    }

    public String getChangelogString(CustomField field, ApplicationUser value) {
        if (value == null) {
            return "";
        }
        return value.getDisplayName();
    }

    protected Object getDbValueFromObject(ApplicationUser customFieldObject) {
        return this.userConverter.getDbString(customFieldObject);
    }

    protected ApplicationUser getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return this.userConverter.getUserFromDbString((String)databaseValue);
    }

    public String getStringFromSingularObject(ApplicationUser value) {
        return this.userConverter.getHttpParameterValue(value);
    }

    public ApplicationUser getSingularObjectFromString(String string) throws FieldValidationException {
        return this.userConverter.getUserFromHttpParameterWithValidation(string);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            ApplicationUser oldValue;
            ApplicationUser newUser = (ApplicationUser)super.getValueFromCustomFieldParams(relevantParams);
            if (newUser == null) {
                return;
            }
            Long issueId = this.getLongFromParamsByKey(relevantParams, CustomFieldUtils.getParamKeyIssueId());
            if (issueId != null && newUser.equals((Object)(oldValue = (ApplicationUser)this.getValueFromIssue(config.getCustomField(), issueId, null)))) {
                return;
            }
            UserFilter filter = this.userFilterManager.getFilter(config);
            if (filter == null) {
                throw new FieldValidationException(this.i18nHelper.getText("user.picker.errors.notconfigured"));
            }
            Object requireProjectIds = relevantParams.getFirstValueForKey(CustomFieldUtils.getParamKeyRequireProjectIds());
            if (requireProjectIds == null || !Boolean.parseBoolean(requireProjectIds.toString())) {
                return;
            }
            Long projectId = this.getLongFromParamsByKey(relevantParams, CustomFieldUtils.getParamKeyProjectId());
            Collection projectIds = CustomFieldUtils.getProjectIdsFromProjectOrFieldConfig((Long)projectId, (FieldConfig)config, (FieldConfigSchemeManager)this.fieldConfigSchemeManager, (ProjectManager)this.projectManager);
            UserSearchParams userSearchParams = UserSearchParams.builder().filter(filter).filterByProjectIds(projectIds).build();
            if (!this.searchService.userMatches(newUser, userSearchParams)) {
                throw new FieldValidationException(this.i18nHelper.getText("user.picker.errors.notvaliduser", newUser.getUsername()));
            }
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private Long getLongFromParamsByKey(CustomFieldParams relevantParams, String key) {
        long parsedLong;
        Object obj = relevantParams.getFirstValueForKey(key);
        if (obj != null && obj instanceof String && (parsedLong = NumberUtils.toLong((String)obj.toString(), (long)-1L)) != -1L) {
            return parsedLong;
        }
        return null;
    }

    public ApplicationUser getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        ApplicationUser value = null;
        try {
            value = (ApplicationUser)super.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException fieldValidationException) {
            // empty catch block
        }
        return value;
    }

    public int compare(@Nonnull ApplicationUser customFieldObjectValue1, @Nonnull ApplicationUser customFieldObjectValue2, FieldConfig fieldConfig) {
        return new ApplicationUserBestNameComparator(this.authenticationContext.getLocale()).compare(customFieldObjectValue1, customFieldObjectValue2);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.authenticationContext.getUser());
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
        }
        WebResourceManager webResourceManager = (WebResourceManager)ComponentAccessor.getComponent(WebResourceManager.class);
        webResourceManager.requireResource("jira.webresources:autocomplete");
        velocityParams.put("useFrotherControl", !this.featureManager.getDarkFeatures().isFeatureEnabled("jira.no.frother.userpicker.field"));
        velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        velocityParams.put(CustomFieldUtils.getParamKeyRequireProjectIds(), Boolean.TRUE);
        return velocityParams;
    }

    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List types = super.getConfigurationItemTypes();
        types.add(new UserFilterConfigItem(this.groupManager, this.projectRoleManager, this.soyTemplateRenderer, this.userFilterManager));
        return types;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.userCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitUser(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        ApplicationUser user = (ApplicationUser)this.getValueFromIssue(context.getCustomField(), issue);
        String value = user != null ? user.getUsername() : "";
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)value);
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == UserCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String userPickerAutoCompleteUrl = String.format("%s/rest/api/1.0/users/picker?fieldName=%s&query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getOderableField().getId());
        return new FieldTypeInfo(null, userPickerAutoCompleteUrl);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"user", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)this.userBeanFactory.createBean((ApplicationUser)this.getValueFromIssue(field, issue), this.authenticationContext.getUser())));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new UserCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public Set<Long> remove(CustomField field) {
        this.userFilterManager.removeFilter(field.getIdAsLong());
        return super.remove(field);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitUser(UserCFType var1);
    }
}

