/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.customfields.manager.DefaultOptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachedOptionsManager
extends DefaultOptionsManager {
    private static final Logger LOG = LoggerFactory.getLogger(CachedOptionsManager.class);
    private final CachedReference<List<Option>> allCache;
    private final CachedReference<Map<Long, List<Option>>> parentCache;
    private final Cache<Long, CacheObject<Options>> optionsCache;
    private final Cache<Long, CacheObject<Option>> optionCache;
    private final Cache<String, List<Option>> valueCache;

    public CachedOptionsManager(OfBizDelegator delegator, FieldConfigManager fieldConfigManager, CacheManager cacheManager, QueryDslAccessor queryDslAccessor) {
        super(delegator, fieldConfigManager, queryDslAccessor);
        this.allCache = cacheManager.getCachedReference(CachedOptionsManager.class, "allCache", (Supplier)new AllOptionsSupplier());
        this.parentCache = cacheManager.getCachedReference(CachedOptionsManager.class, "parentCache", this::loadParentCache, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.optionsCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".optionsCache", (CacheLoader)new OptionsCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.optionCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".optionCache", (CacheLoader)new OptionCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.valueCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".valueCache", (CacheLoader)new ValueCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clear();
    }

    private void clear() {
        LOG.debug("Flushing custom field options caches.");
        this.optionsCache.removeAll();
        this.optionCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
        this.valueCache.removeAll();
    }

    @Override
    public List<Option> getAllOptions() {
        return (List)this.allCache.get();
    }

    @Override
    public List<Option> findByOptionValue(String value) {
        if (value == null) {
            LOG.debug("You are searching the option by the null value, which is not allowed.");
            return Collections.emptyList();
        }
        value = CaseFolding.foldString((String)value);
        return (List)this.valueCache.get((Object)value);
    }

    @Override
    public Options getOptions(FieldConfig fieldConfig) {
        Long fieldConfigId;
        Long l = fieldConfigId = fieldConfig == null ? null : fieldConfig.getId();
        if (fieldConfigId == null) {
            LOG.debug("Trying to get options by null fieldConfigId");
            return super.getOptions(fieldConfig);
        }
        CacheObject returnedOptions = (CacheObject)this.optionsCache.get((Object)fieldConfigId);
        if (returnedOptions == null) {
            LOG.debug("Options returned for fieldConfigId={} are null", (Object)fieldConfigId);
            return null;
        }
        return (Options)returnedOptions.getValue();
    }

    @Override
    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        super.setRootOptions(fieldConfig, options);
        this.clear();
    }

    @Override
    public void removeCustomFieldOptions(CustomField customField) {
        super.removeCustomFieldOptions(customField);
        LOG.debug("Removing options for custom field with id={}", (Object)customField.getIdAsLong());
        this.clear();
    }

    @Override
    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        super.removeCustomFieldConfigOptions(fieldConfig);
        this.clear();
    }

    @Override
    public void updateOptions(Collection<Option> options) {
        super.updateOptions(options);
        LOG.debug("Updating multiple options and resetting the caches.");
        for (Option option : options) {
            this.removeOptionFromCaches(option);
        }
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
    }

    @Override
    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        Option option = super.createOption(fieldConfig, parentOptionId, sequence, value);
        LOG.debug("Resetting caches after creating the option");
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
        return option;
    }

    @Override
    public List<Option> createOptions(FieldConfig config, Long parentOptionId, Long sequence, Iterable<String> options) {
        List<Option> result = super.createOptions(config, parentOptionId, sequence, options);
        LOG.debug("Creating multiple options and resetting the caches.");
        for (Option option : result) {
            this.removeOptionFromCaches(option);
        }
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
        return result;
    }

    @Override
    public void deleteOptionAndChildren(Option option) {
        super.deleteOptionAndChildren(option);
        this.clear();
    }

    @Override
    public void setValue(Option option, String value) {
        String oldValue = option.getValue();
        super.setValue(option, value);
        this.removeOptionFromCaches(option);
        if (option.getValue() != null) {
            this.valueCache.remove((Object)CaseFolding.foldString((String)oldValue));
            this.valueCache.remove((Object)CaseFolding.foldString((String)value));
            LOG.debug("Setting a new value={} on the custom field option", (Object)value);
        }
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
    }

    @Override
    public void disableOption(Option option) {
        super.disableOption(option);
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
    }

    @Override
    public void enableOption(Option option) {
        super.enableOption(option);
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
        this.parentCache.reset();
    }

    private void removeOptionFromCaches(Option option) {
        Long optionId = option.getOptionId();
        String optionValue = option.getValue();
        if (optionId != null) {
            this.optionCache.remove((Object)optionId);
        }
        if (optionValue != null) {
            this.valueCache.remove((Object)CaseFolding.foldString((String)optionValue));
        }
    }

    @Override
    public Option findByOptionId(Long optionId) {
        if (optionId == null) {
            LOG.debug("Couldn't search for the option with id=null");
            return null;
        }
        CacheObject returnedOption = (CacheObject)this.optionCache.get((Object)optionId);
        if (returnedOption == null) {
            LOG.debug("Option returned for optionId={} is null", (Object)optionId);
            return null;
        }
        return (Option)returnedOption.getValue();
    }

    @Override
    @Nonnull
    public List<Option> findByParentId(Long parentOptionId) {
        return ((Map)this.parentCache.get()).getOrDefault(parentOptionId, Collections.emptyList());
    }

    private Map<Long, List<Option>> loadParentCache() {
        return this.getAllOptions().stream().filter(option -> option.getParentOptionId() != null).collect(Collectors.groupingBy(Option::getParentOptionId, Collectors.mapping(option -> option, Collectors.toList())));
    }

    private class AllOptionsSupplier
    implements Supplier<List<Option>> {
        private AllOptionsSupplier() {
        }

        public List<Option> get() {
            return ImmutableList.copyOf((Collection)CachedOptionsManager.super.getAllOptions());
        }
    }

    private class OptionsCacheLoader
    implements CacheLoader<Long, CacheObject<Options>> {
        private OptionsCacheLoader() {
        }

        @Nonnull
        public CacheObject<Options> load(@Nonnull Long fieldConfigId) {
            FieldConfig fieldConfig = CachedOptionsManager.this.fieldConfigManager.getFieldConfig(fieldConfigId);
            return CacheObject.wrap(CachedOptionsManager.super.getOptions(fieldConfig));
        }
    }

    private class OptionCacheLoader
    implements CacheLoader<Long, CacheObject<Option>> {
        private OptionCacheLoader() {
        }

        @Nonnull
        public CacheObject<Option> load(@Nonnull Long id) {
            return CacheObject.wrap(CachedOptionsManager.super.findByOptionId(id));
        }
    }

    private class ValueCacheLoader
    implements CacheLoader<String, List<Option>> {
        private ValueCacheLoader() {
        }

        @Nonnull
        public List<Option> load(@Nonnull String value) {
            return ImmutableList.copyOf((Collection)CachedOptionsManager.super.findByOptionValue(value));
        }
    }
}

