/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.option.OptionsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.model.querydsl.QCustomFieldOption;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOptionsManager
implements OptionsManager {
    public static final String ENTITY_CONFIG_ID = "customfieldconfig";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOptionsManager.class);
    private static final String DB_ASC_SUFFIX = " ASC";
    @VisibleForTesting
    protected static final List<String> ORDER_BY_LIST = ImmutableList.of((Object)"parentoptionid ASC", (Object)"sequence ASC");
    private static final String CUSTOM_FIELD_OPTION_TABLE = "CustomFieldOption";
    private final OfBizDelegator delegator;
    protected final FieldConfigManager fieldConfigManager;
    private final QueryDslAccessor queryDslAccessor;

    public DefaultOptionsManager(OfBizDelegator delegator, FieldConfigManager fieldConfigManager, QueryDslAccessor queryDslAccessor) {
        this.delegator = delegator;
        this.fieldConfigManager = fieldConfigManager;
        this.queryDslAccessor = queryDslAccessor;
    }

    public Options getOptions(FieldConfig fieldConfig) {
        if (fieldConfig != null) {
            Map<String, Object> params = new PrimitiveMap.Builder().add(ENTITY_CONFIG_ID, fieldConfig.getId()).toMap();
            return new OptionsImpl(this.convertGVsToOptions(this.delegator.findByAnd(CUSTOM_FIELD_OPTION_TABLE, params, ORDER_BY_LIST)), fieldConfig, this);
        }
        LOG.debug("The fieldConfig was null, couldn't get the options for it.");
        return null;
    }

    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        this.removeCustomFieldConfigOptions(fieldConfig);
        if (options != null) {
            int counter = 0;
            for (Option o : options) {
                Map<String, Object> params = new PrimitiveMap.Builder().add("customfield", fieldConfig.getCustomField().getIdAsLong()).add(ENTITY_CONFIG_ID, fieldConfig.getId()).add("value", o.getValue()).add("parentoptionid", (String)null).add("sequence", Long.valueOf(counter)).toMap();
                this.delegator.createValue(CUSTOM_FIELD_OPTION_TABLE, params);
                ++counter;
            }
        }
    }

    public void removeCustomFieldOptions(CustomField customField) {
        this.delegator.removeByAnd(CUSTOM_FIELD_OPTION_TABLE, PrimitiveMap.builder().add("customfield", customField.getIdAsLong()).toMap());
    }

    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        this.delegator.removeByAnd(CUSTOM_FIELD_OPTION_TABLE, PrimitiveMap.builder().add(ENTITY_CONFIG_ID, fieldConfig.getId()).toMap());
    }

    public void updateOptions(Collection<Option> options) {
        if (options != null) {
            for (Option option : options) {
                option.store();
            }
        }
    }

    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        return this.createOptionInDb(fieldConfig, parentOptionId, sequence, value);
    }

    public List<Option> createOptions(FieldConfig config, Long parentOptionId, Long sequence, Iterable<String> options) {
        Long customFieldId = config.getCustomField().getIdAsLong();
        Long configId = config.getId();
        ArrayList<Option> createdOptions = new ArrayList<Option>();
        for (String option : options) {
            Long l = sequence;
            sequence = sequence + 1L;
            Option created = this.createOptionInDb(customFieldId, configId, parentOptionId, l, option);
            if (created == null) continue;
            createdOptions.add(created);
        }
        return createdOptions;
    }

    public void deleteOptionAndChildren(Option option) {
        List<GenericValue> gvToRemove = this.convertOptionsToGV(option.getChildOptions());
        gvToRemove.add(option.getGenericValue());
        LOG.debug("Removing {} options.", (Object)gvToRemove.size());
        this.delegator.removeAll(gvToRemove);
    }

    public List<Option> getAllOptions() {
        List optionGVs = this.delegator.findAll(CUSTOM_FIELD_OPTION_TABLE, ORDER_BY_LIST);
        return this.convertGVsToOptions(optionGVs);
    }

    public void disableOption(Option option) {
        option.setDisabled(Boolean.TRUE);
        option.store();
    }

    public void enableOption(Option option) {
        option.setDisabled(Boolean.FALSE);
        option.store();
    }

    public void setValue(Option option, String value) {
        option.setValue(value);
        option.store();
    }

    public List<Option> findByOptionValue(String value) {
        if (value == null) {
            LOG.debug("You are searching the option by the null value, which is not allowed.");
            return Collections.emptyList();
        }
        List<GenericValue> optionGVs = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QCustomFieldOption.CUSTOM_FIELD_OPTION).from((Expression)QCustomFieldOption.CUSTOM_FIELD_OPTION)).where((Predicate)QCustomFieldOption.CUSTOM_FIELD_OPTION.value.equalsIgnoreCase(value))).orderBy(new OrderSpecifier[]{QCustomFieldOption.CUSTOM_FIELD_OPTION.parentoptionid.asc(), QCustomFieldOption.CUSTOM_FIELD_OPTION.sequence.asc()})).fetch()).stream().map(dto -> dto.toGenericValue(this.delegator)).collect(Collectors.toList());
        return this.convertGVsToOptions(optionGVs);
    }

    public Option findByOptionId(Long optionId) {
        GenericValue option = this.delegator.findById(CUSTOM_FIELD_OPTION_TABLE, optionId);
        return option == null ? null : new LazyLoadedOption(option, this, this.fieldConfigManager);
    }

    public List<Option> findByParentId(Long parentOptionId) {
        List optionGVs = this.delegator.findByAnd(CUSTOM_FIELD_OPTION_TABLE, PrimitiveMap.builder().add("parentoptionid", parentOptionId).toMap(), ORDER_BY_LIST);
        return this.convertGVsToOptions(optionGVs);
    }

    @Nonnull
    public List<Option> getOptions(@Nonnull CustomField field, @Nonnull Collection<Long> projectIds, @Nonnull Collection<String> issueTypeIds) {
        SearchContextImpl searchContext = SearchContextImpl.builder().projectIds(projectIds).issueTypeIds(issueTypeIds).build();
        FieldConfig fieldConfig = field.getReleventConfig((SearchContext)searchContext);
        if (fieldConfig == null) {
            return Collections.emptyList();
        }
        return this.getOptions(fieldConfig);
    }

    List<Option> convertGVsToOptions(List<GenericValue> optionGvs) {
        return new ArrayList<Option>(CollectionUtil.transform(optionGvs, (Function)new GenericValueToOption()));
    }

    private Option createOptionInDb(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        return this.createOptionInDb(fieldConfig.getCustomField().getIdAsLong(), fieldConfig.getId(), parentOptionId, sequence, value);
    }

    private Option createOptionInDb(Long customFieldId, Long configId, Long parentOptionId, Long sequence, String value) {
        Map<String, Object> params = new PrimitiveMap.Builder().add("customfield", customFieldId).add(ENTITY_CONFIG_ID, configId).add("value", value).add("parentoptionid", parentOptionId).add("sequence", sequence).add("disabled", "N").toMap();
        GenericValue gv = this.delegator.createValue(CUSTOM_FIELD_OPTION_TABLE, params);
        if (gv != null) {
            return new LazyLoadedOption(gv, this, this.fieldConfigManager);
        }
        LOG.debug("Couldn't create the option with customFieldId={}, fieldConfigId={} in the database", (Object)customFieldId, (Object)configId);
        return null;
    }

    private List<GenericValue> convertOptionsToGV(List<Option> options) {
        return new ArrayList<GenericValue>(CollectionUtil.transform(options, (Function)new OptionToGenericValue()));
    }

    private static final class Entity {
        private static final String CONFIG_ID = "customfieldconfig";
        private static final String PARENT_OPTION = "parentoptionid";
        private static final String ISSUE_VALUE = "value";
        private static final String CUSTOMFIELD_ID = "customfield";
        private static final String SEQUENCE = "sequence";
        private static final String DISABLED = "disabled";

        private Entity() {
        }
    }

    private final class GenericValueToOption
    implements Function<GenericValue, Option> {
        private GenericValueToOption() {
        }

        public Option apply(GenericValue input) {
            return new LazyLoadedOption(input, DefaultOptionsManager.this, DefaultOptionsManager.this.fieldConfigManager);
        }
    }

    private static final class OptionToGenericValue
    implements Function<Option, GenericValue> {
        private OptionToGenericValue() {
        }

        public GenericValue apply(Option option) {
            return option.getGenericValue();
        }
    }
}

