/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XmlTimestampConverter
extends AbstractSingleValueConverter {
    private static final Logger log = LoggerFactory.getLogger(XmlTimestampConverter.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";

    XmlTimestampConverter() {
    }

    public boolean canConvert(Class type) {
        return type != null && type.equals(Timestamp.class);
    }

    public String toString(Object source) {
        Date date = new Date(((Timestamp)source).getTime());
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(date);
    }

    public Object fromString(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        try {
            Date date = formatter.parse(str);
            return new Timestamp(date.getTime());
        }
        catch (ParseException ex) {
            log.error("Could not parse {} as Timestamp", (Object)str);
            return null;
        }
    }
}

