/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldRetrievalHelper;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValue;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValues;
import com.atlassian.jira.issue.customfields.persistence.OfBizCustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.ReindexIssueCacheClearRequestEvent;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class EagerLoadingOfBizCustomFieldPersister
extends OfBizCustomFieldValuePersister
implements InitializingComponent {
    static final String CUSTOMFIELD_VALUES_CACHE_MAX_SIZE = "jira.customfield.values.cache.max.size";
    static final int DEFAULT_CACHE_SIZE = 10;
    private final JiraProperties properties;
    private final EventPublisher eventPublisher;

    public EagerLoadingOfBizCustomFieldPersister(OfBizDelegator delegator, Clock clock, JiraProperties properties, EventPublisher eventPublisher) {
        super(delegator, clock);
        this.properties = properties;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.createValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.createValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.updateValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.updateValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public Set<Long> removeValue(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Object value) {
        Set<Long> set = super.removeValue(field, issueId, persistenceFieldType, value);
        this.clearCache();
        return set;
    }

    public Set removeAllValues(String customFieldId) {
        Set<Long> set = super.removeAllValues(customFieldId);
        this.clearCache();
        return set;
    }

    @Override
    public Map<Long, List<CustomFieldValue>> getValues(Set<Long> issueIds) {
        return this.getValuesForIssueIds(issueIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CustomFieldValues.fromOrderedByUpdate((Collection)entry.getValue())));
    }

    public void clearCache() {
        this.getCache().invalidateAll();
    }

    @EventListener
    public void clearCache(ReindexIssueCacheClearRequestEvent event) {
        this.getCache().invalidate((Object)new CacheKey(event.getIssueId()));
    }

    @Override
    protected List<GenericValue> getValuesForTypeAndParent(CustomField field, Long issueId, String parentKey) {
        List<GenericValue> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (String)"parentkey", (Object)parentKey));
    }

    @Override
    protected List<GenericValue> getValuesForType(CustomField field, Long issueId) {
        List<GenericValue> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId())));
    }

    private List<GenericValue> getValuesForIssueId(Long issueId) {
        CacheKey key = new CacheKey(issueId);
        try {
            return (List)this.getCache().get((Object)key, () -> {
                ImmutableMap limitClause = ImmutableMap.of((Object)"issue", (Object)issueId);
                return CustomFieldRetrievalHelper.getValuesOrderedByUpdate(this.delegator, (Map<String, Object>)limitClause);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private Map<Long, List<GenericValue>> getValuesForIssueIds(Set<Long> issueIds) {
        List cacheKeys;
        Cache<CacheKey, List<GenericValue>> queryToResultsCache = this.getCache();
        Map<Long, List<GenericValue>> valuesFromCache = queryToResultsCache.getAllPresent(cacheKeys = issueIds.stream().map(CacheKey::new).collect(Collectors.toList())).entrySet().stream().collect(Collectors.toMap(entry -> ((CacheKey)entry.getKey()).getIssueId(), Map.Entry::getValue));
        Sets.SetView idsToFetch = Sets.difference(issueIds, valuesFromCache.keySet());
        if (CollectionUtils.isEmpty((Collection)idsToFetch)) {
            return valuesFromCache;
        }
        try (OfBizListIterator iterator = this.delegator.findListIteratorByCondition("CustomFieldValue", (EntityCondition)new EntityExpr("issue", EntityOperator.IN, (Object)idsToFetch));){
            Map<Long, List<GenericValue>> valuesFromDb = iterator.getCompleteList().stream().collect(Collectors.groupingBy(value -> value.getLong("issue")));
            valuesFromDb.forEach((k, v) -> queryToResultsCache.put((Object)new CacheKey((Long)k), v));
            HashMap<Long, List<GenericValue>> result = new HashMap<Long, List<GenericValue>>(valuesFromDb);
            result.putAll(valuesFromCache);
            HashMap<Long, List<GenericValue>> hashMap = result;
            return hashMap;
        }
    }

    private Cache<CacheKey, List<GenericValue>> getCache() {
        return (Cache)JiraAuthenticationContextImpl.getRequestCache("jira.customfield.values.cache", () -> CacheBuilder.newBuilder().maximumSize((long)EagerLoadingOfBizCustomFieldPersister.getCacheSize(this.properties).intValue()).build());
    }

    public static Integer getCacheSize(JiraProperties properties) {
        return properties.getInteger(CUSTOMFIELD_VALUES_CACHE_MAX_SIZE, Integer.valueOf(10));
    }

    static final class CacheKey {
        private final Long issueId;

        CacheKey(Long issueId) {
            this.issueId = issueId;
        }

        public Long getIssueId() {
            return this.issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.issueId == null ? cacheKey.issueId == null : this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            return this.issueId != null ? this.issueId.hashCode() : 0;
        }
    }
}

