/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Set;

public class ProjectCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final JqlOperandResolver jqlOperandResolver;
    private final ProjectIndexInfoResolver indexInfoResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final NameResolver<Project> projectResolver;
    private IndexedInputHelper indexedInputHelper;

    public ProjectCustomFieldSearchInputTransformer(String urlParameterName, ClauseNames clauseNames, CustomField field, JqlOperandResolver jqlOperandResolver, ProjectIndexInfoResolver indexInfoResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, NameResolver<Project> projectResolver, CustomFieldInputHelper customFieldInputHelper) {
        super(field, clauseNames, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
        this.jqlOperandResolver = jqlOperandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.projectResolver = (NameResolver)Assertions.notNull((String)"projectResolver", projectResolver);
        this.indexedInputHelper = this.createIndexedInputHelper();
    }

    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        if (query == null) {
            return null;
        }
        Set valuesAsStrings = this.indexedInputHelper.getAllNavigatorValuesForMatchingClauses(user, this.clauseNames, query);
        return new CustomFieldParamsImpl(this.getCustomField(), (Object)valuesAsStrings);
    }

    Clause createSearchClause(ApplicationUser user, String value) {
        if (!value.equals("-1")) {
            SingleValueOperand o = this.getProjectOperandForIdString(value);
            return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.EQUALS, (Operand)o);
        }
        return null;
    }

    private SingleValueOperand getProjectOperandForIdString(String idStr) {
        try {
            Long id = new Long(idStr);
            Project project = (Project)this.projectResolver.get(id);
            SingleValueOperand o = project == null ? new SingleValueOperand(id) : new SingleValueOperand(project.getKey());
            return o;
        }
        catch (NumberFormatException e) {
            return new SingleValueOperand(idStr);
        }
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return this.convertForNavigator(query).fitsNavigator();
    }

    IndexedInputHelper createIndexedInputHelper() {
        return new DefaultIndexedInputHelper((IndexInfoResolver)this.indexInfoResolver, this.jqlOperandResolver, this.fieldFlagOperandRegistry);
    }
}

