/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.fields.option.AssigneeOption;
import com.atlassian.jira.issue.fields.option.AssigneeOptions;
import com.atlassian.jira.issue.fields.option.OptionGroup;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Assignees {
    private static final String SEPERATOR_STRING = "---------------";
    private final AssigneeService assigneeService;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final EmailFormatter emailFormatter;

    public Assignees(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, AssigneeService assigneeService, AvatarService avatarService, UserManager userManager, EmailFormatter emailFormatter) {
        this.assigneeService = assigneeService;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.emailFormatter = emailFormatter;
    }

    List<AssigneeOption> optionsForHtmlSelect(Issue issue, ActionDescriptor actionDescriptor) {
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        List assignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        return this.makeAssigneeOptionsList(assignableUsers, suggestedAssignees);
    }

    AssigneeOptions optionsForFrotherControl(Issue issue, ActionDescriptor actionDescriptor, String currentAssigneeUsername) {
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, actionDescriptor);
        ApplicationUser assignee = issue.getAssignee();
        if (assignee == null && currentAssigneeUsername != null && (assignee = this.userManager.getUserByName(currentAssigneeUsername)) != null && this.isAssignable(assignee, Collections.singletonList(issue), actionDescriptor)) {
            suggestedAssignees.add(assignee);
            Collections.sort(suggestedAssignees, new UserCachingComparator(this.authenticationContext.getLocale()));
        }
        AssigneeOptions assigneeOptions = this.makeAssigneeOptions(Collections.singletonList(issue), actionDescriptor, suggestedAssignees, assignee, this.isNew(issue));
        if (assignee != null && !assignee.getName().equals(currentAssigneeUsername)) {
            assigneeOptions.setInvalidAssigneeSelected(true);
        }
        return assigneeOptions;
    }

    AssigneeOptions bulkOptionsForFrotherControl(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        HashSet<String> suggestedAssigneeNames = new HashSet<String>();
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        if (loggedInUser != null) {
            suggestedAssigneeNames.add(loggedInUser.getName());
        }
        for (Issue issue : issues) {
            suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForIssue(issue));
        }
        suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForUser(loggedInUser));
        ArrayList<ApplicationUser> suggestedAssignees = new ArrayList<ApplicationUser>();
        for (String suggestedAssigneeName : suggestedAssigneeNames) {
            ApplicationUser curUser = this.userManager.getUserByName(suggestedAssigneeName);
            if (curUser == null || !this.isAssignableToAllIssues(curUser, issues, actionDescriptor)) continue;
            suggestedAssignees.add(curUser);
        }
        suggestedAssignees.sort((Comparator<ApplicationUser>)new UserCachingComparator(this.authenticationContext.getLocale()));
        return this.makeAssigneeOptions(issues, actionDescriptor, suggestedAssignees, null, true);
    }

    private boolean isAssignableToAllIssues(ApplicationUser user, Collection<? extends Issue> issues, ActionDescriptor actionDescriptor) {
        return issues.stream().allMatch(issue -> this.assigneeService.isAssignable(issue, user, actionDescriptor));
    }

    List<AssigneeOption> bulkOptionsForHtmlSelect(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        List bulkAssignableUsers = null;
        HashSet suggestedAssigneeNames = new HashSet();
        for (Issue issue : issues) {
            List issueAssignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
            if (bulkAssignableUsers == null) {
                bulkAssignableUsers = issueAssignableUsers;
            } else {
                bulkAssignableUsers.retainAll(issueAssignableUsers);
            }
            suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForIssue(issue));
        }
        Collections.sort(bulkAssignableUsers, new UserCachingComparator(this.authenticationContext.getLocale()));
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForUser(loggedInUser));
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(suggestedAssigneeNames, bulkAssignableUsers);
        return this.makeAssigneeOptionsList(bulkAssignableUsers, suggestedAssignees);
    }

    private List<AssigneeOption> makeAssigneeOptionsList(List<ApplicationUser> assignableUsers, List<ApplicationUser> suggestedUsers) {
        ArrayList<AssigneeOption> options = new ArrayList<AssigneeOption>();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (this.isUnassignedIssuesEnabled()) {
            options.add(new AssigneeOption(null, i18n.getText("common.concepts.unassigned"), true));
        }
        options.add(new AssigneeOption("-1", "- " + i18n.getText("common.concepts.automatic") + " -", true));
        AssigneeOption separator = new AssigneeOption("-2", SEPERATOR_STRING, false);
        separator.setOptionEnabled(false);
        options.add(separator);
        Map uniqueFullNames = this.assigneeService.makeUniqueFullNamesMap(assignableUsers);
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        if (!suggestedUsers.isEmpty()) {
            for (ApplicationUser suggestedUser : suggestedUsers) {
                options.add(this.createAssigneeOption(suggestedUser, loggedInUser, uniqueFullNames));
            }
            options.add(separator);
        }
        for (ApplicationUser user : assignableUsers) {
            options.add(this.createAssigneeOption(user, loggedInUser, uniqueFullNames));
        }
        return options;
    }

    public AssigneeOptions makeAssigneeOptions(Collection<Issue> issues, ActionDescriptor actionDescriptor, List<ApplicationUser> suggestedUsers, ApplicationUser currentAssignee, boolean assignAutomaticIfUnassigned) {
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        AssigneeOptions options = new AssigneeOptions();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        OptionGroup suggestedAssignees = new OptionGroup("suggested", i18n.getText("assignee.picker.group.suggested"), null, 0);
        if (suggestedUsers.contains(loggedInUser)) {
            suggestedUsers.remove(loggedInUser);
            AssigneeOption assignToMe = this.createAssigneeOption(loggedInUser, loggedInUser, null);
            suggestedAssignees.add(assignToMe);
        }
        String defaultAvatarURL = this.avatarService.getAvatarURL(loggedInUser, (String)null, Avatar.Size.SMALL).toString();
        AssigneeOption unassignedAssignee = new AssigneeOption("", i18n.getText("common.concepts.unassigned"), "", defaultAvatarURL);
        if (this.isUnassignedIssuesEnabled()) {
            suggestedAssignees.add(unassignedAssignee);
        }
        AssigneeOption automaticAssignee = new AssigneeOption("-1", i18n.getText("common.concepts.automatic"), "", defaultAvatarURL);
        if (currentAssignee == null) {
            if (assignAutomaticIfUnassigned) {
                automaticAssignee.setSelected(true);
            } else if (this.isUnassignedIssuesEnabled()) {
                unassignedAssignee.setSelected(true);
            }
        }
        suggestedAssignees.add(automaticAssignee);
        for (ApplicationUser suggestedUser : suggestedUsers) {
            AssigneeOption assigneeOption = this.createAssigneeOption(suggestedUser, loggedInUser, null);
            if (suggestedUser.equals((Object)loggedInUser)) {
                assigneeOption.setLoggedInUser(true);
            }
            if (currentAssignee != null && suggestedUser.equals((Object)currentAssignee)) {
                assigneeOption.setSelected(true);
            }
            suggestedAssignees.add(assigneeOption);
        }
        options.add(suggestedAssignees);
        if (loggedInUser != null && !loggedInUser.equals((Object)currentAssignee)) {
            options.setLoggedInUserIsAssignable(this.isAssignable(loggedInUser, issues, actionDescriptor));
        }
        return options;
    }

    private boolean isAssignable(ApplicationUser loggedInUser, Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        boolean loggedInUserIsAssignable;
        if (Users.isAnonymous((ApplicationUser)loggedInUser)) {
            loggedInUserIsAssignable = false;
        } else {
            loggedInUserIsAssignable = true;
            for (Issue issue : issues) {
                if (this.assigneeService.isAssignable(issue, loggedInUser, actionDescriptor)) continue;
                loggedInUserIsAssignable = false;
                break;
            }
        }
        return loggedInUserIsAssignable;
    }

    private AssigneeOption createAssigneeOption(ApplicationUser user, ApplicationUser loggedInUser, @Nullable Map<String, Boolean> fullNames) {
        boolean isUnique;
        Object displayName = user.getDisplayName();
        boolean bl = isUnique = fullNames == null || fullNames.get(displayName) != false;
        if (!isUnique) {
            displayName = (String)displayName + " (" + user.getName() + ")";
        }
        URI avatarURL = this.avatarService.getAvatarURL(loggedInUser, user.getName(), Avatar.Size.SMALL);
        String email = this.emailFormatter.formatEmail(user.getEmailAddress(), loggedInUser);
        AssigneeOption option = new AssigneeOption(user.getName(), (String)displayName, email, avatarURL.toString());
        option.setLoggedInUser(user.equals((Object)loggedInUser));
        return option;
    }

    private boolean isNew(Issue issue) {
        return issue.getId() == null;
    }

    private boolean isUnassignedIssuesEnabled() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }
}

